/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited.javaintegration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.codecompletion.PyCodeCompletionImages;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.JavaDefinition;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.JavaElementToken;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.CompiledToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaClassModule
extends AbstractModule {
    public static final boolean DEBUG_JAVA_COMPLETIONS = false;
    protected static final CompiledToken[] EMPTY_ITOKEN = new CompiledToken[0];
    protected CompiledToken[] tokens;
    public static HashMap<String, String> replacementMap = new HashMap();
    private static boolean imageDescriptorCreated;
    private static HashMap<Integer, Integer> typesMapping;

    static {
        replacementMap.put("object", "obj");
        replacementMap.put("class", "class_");
        replacementMap.put("[QString", "str");
        replacementMap.put("[I", "int");
        imageDescriptorCreated = false;
        typesMapping = new HashMap();
        typesMapping.put(6, 1);
        typesMapping.put(5, 1);
        typesMapping.put(11, 6);
        typesMapping.put(4, 6);
        typesMapping.put(3, 6);
    }

    public boolean hasFutureImportAbsoluteImportDeclared() {
        return false;
    }

    protected AbstractJavaClassModule(String name) {
        super(name);
        this.checkJavaImageDescriptorCreated();
    }

    protected void checkJavaImageDescriptorCreated() {
        if (imageDescriptorCreated) {
            return;
        }
        try {
            JavaPlugin.getImageDescriptorRegistry();
        }
        catch (Throwable throwable) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        JavaPlugin.getImageDescriptorRegistry();
                    }
                    catch (Throwable throwable) {}
                }
            });
        }
        imageDescriptorCreated = true;
    }

    protected CompiledToken[] createTokens(String packagePlusactTok) {
        ArrayList<JavaElementToken> lst = new ArrayList<JavaElementToken>();
        try {
            IJavaElement javaElement;
            List<Tuple<IJavaElement, CompletionProposal>> elementsFound = this.getJavaCompletionProposals(packagePlusactTok, null);
            HashMap<String, IJavaElement> generatedProperties = new HashMap<String, IJavaElement>();
            FastStringBuffer tempBuffer = new FastStringBuffer(128);
            for (Tuple<IJavaElement, CompletionProposal> tuple : elementsFound) {
                javaElement = (IJavaElement)tuple.o1;
                String args = "";
                if (javaElement instanceof IMethod) {
                    tempBuffer.clear();
                    tempBuffer.append("()");
                    IMethod method = (IMethod)javaElement;
                    String[] stringArray = method.getParameterTypes();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String replacement;
                        String lastPart;
                        String param = stringArray[n2];
                        if (tempBuffer.length() > 2) {
                            tempBuffer.insert(1, ", ");
                        }
                        if ((lastPart = FullRepIterable.getLastPart((String)param)).length() > 0 && (lastPart = PyAction.lowerChar(lastPart, 0)).charAt(lastPart.length() - 1) == ';') {
                            lastPart = lastPart.substring(0, lastPart.length() - 1);
                        }
                        if ((replacement = replacementMap.get(lastPart)) != null) {
                            lastPart = replacement;
                        }
                        tempBuffer.insert(1, lastPart);
                        ++n2;
                    }
                    args = tempBuffer.toString();
                    String elementName = method.getElementName();
                    if (elementName.startsWith("get") || elementName.startsWith("set")) {
                        tempBuffer.clear();
                        elementName = elementName.substring(3);
                        if (elementName.length() > 0) {
                            tempBuffer.append(Character.toLowerCase(elementName.charAt(0)));
                            tempBuffer.append(elementName.substring(1));
                            String propertyName = tempBuffer.toString();
                            IJavaElement existing = (IJavaElement)generatedProperties.get(propertyName);
                            if (existing != null) {
                                if (existing.getElementName().startsWith("set")) {
                                    generatedProperties.put(propertyName, javaElement);
                                }
                            } else {
                                generatedProperties.put(propertyName, javaElement);
                            }
                        }
                    }
                }
                lst.add(new JavaElementToken(javaElement.getElementName(), "", args, this.name, this.getType(javaElement.getElementType()), javaElement, (CompletionProposal)tuple.o2));
            }
            for (Map.Entry entry : generatedProperties.entrySet()) {
                javaElement = (IJavaElement)entry.getValue();
                lst.add(new JavaElementToken((String)entry.getKey(), "", "", this.name, 3, javaElement, PyCodeCompletionImages.getImageForType(3)));
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return lst.toArray(new CompiledToken[lst.size()]);
    }

    private int getType(int elementType) {
        Integer found = typesMapping.get(elementType);
        if (found != null) {
            return found;
        }
        return 3;
    }

    @Override
    public IToken[] getWildImportedModules() {
        return EMPTY_ITOKEN;
    }

    @Override
    public IToken[] getTokenImportedModules() {
        return EMPTY_ITOKEN;
    }

    @Override
    public IToken[] getGlobalTokens() {
        return this.tokens;
    }

    @Override
    public String getDocString() {
        return "Java class module extension";
    }

    @Override
    public IToken[] getGlobalTokens(ICompletionState state, ICodeCompletionASTManager manager) {
        String actTok = state.getFullActivationToken();
        if (actTok == null) {
            actTok = state.getActivationToken();
        }
        if (actTok == null) {
            return new IToken[0];
        }
        String act = new FastStringBuffer(this.name, 2 + actTok.length()).append('.').append(actTok).toString();
        return this.createTokens(act);
    }

    @Override
    public boolean isInDirectGlobalTokens(String tok, ICompletionCache completionCache) {
        if (this.tokens != null) {
            return AbstractJavaClassModule.binaryHasObject(this.tokens, new CompiledToken(tok, "", "", "", 0));
        }
        return false;
    }

    @Override
    public boolean isInGlobalTokens(String tok, IPythonNature nature, ICompletionCache completionCache) {
        if (tok.indexOf(46) == -1) {
            return this.isInDirectGlobalTokens(tok, completionCache);
        }
        System.err.println("Still no treated isInDirectGlobalTokens with dotted string:" + tok);
        return false;
    }

    private static boolean binaryHasObject(CompiledToken[] a, CompiledToken key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            CompiledToken midVal = a[mid];
            int cmp = midVal.getRepresentation().compareTo(key.getRepresentation());
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public Definition[] findDefinition(ICompletionState state, int line, int col, IPythonNature nature) throws Exception {
        String foundAs;
        List splitted = StringUtils.dotSplit((String)state.getActivationToken());
        FastStringBuffer modNameBuf = new FastStringBuffer(this.getName(), 128);
        AbstractJavaClassModule validModule = null;
        IModule module = null;
        int i = 0;
        for (String s : splitted) {
            modNameBuf.append(".");
            modNameBuf.append(s);
            module = nature.getAstManager().getModule(modNameBuf.toString(), nature, true, false);
            if (module == null) break;
            validModule = module;
        }
        modNameBuf.clear();
        FastStringBuffer pathInJavaClass = modNameBuf;
        if (validModule == null) {
            validModule = this;
            pathInJavaClass.clear();
            pathInJavaClass.append(state.getActivationToken());
        } else {
            if (!(validModule instanceof AbstractJavaClassModule)) {
                throw new RuntimeException("The module found from a java class module was found as another kind: " + validModule.getClass());
            }
            int j = i;
            while (j < splitted.size()) {
                if (j != i) {
                    pathInJavaClass.append('.');
                }
                pathInJavaClass.append((String)splitted.get(j));
                ++j;
            }
        }
        AbstractJavaClassModule javaClassModule = validModule;
        IJavaElement elementFound = null;
        if (pathInJavaClass.length() == 0) {
            foundAs = "";
            elementFound = this.findJavaElement(javaClassModule.getName());
        } else {
            foundAs = pathInJavaClass.toString();
            List<Tuple<IJavaElement, CompletionProposal>> javaCompletionProposals = this.getJavaCompletionProposals(javaClassModule.getName(), foundAs);
            if (javaCompletionProposals.size() > 0) {
                elementFound = (IJavaElement)javaCompletionProposals.get((int)0).o1;
            } else if (javaClassModule.getName().endsWith("." + foundAs)) {
                foundAs = "";
                elementFound = this.findJavaElement(javaClassModule.getName());
            }
        }
        if (elementFound != null) {
            return new Definition[]{new JavaDefinition(foundAs, javaClassModule, elementFound)};
        }
        return new Definition[0];
    }

    protected abstract IJavaElement findJavaElement(String var1) throws Exception;

    protected abstract List<Tuple<IJavaElement, CompletionProposal>> getJavaCompletionProposals(String var1, String var2) throws Exception;

    protected abstract List<Tuple<IJavaElement, CompletionProposal>> getJavaCompletionProposals(String var1, int var2, String var3) throws Exception;

    protected CompletionProposalCollector createCollector(final String filterCompletionName, final List<Tuple<IJavaElement, CompletionProposal>> ret, ICompilationUnit unit) {
        CompletionProposalCollector collector = new CompletionProposalCollector(unit){

            public IJavaCompletionProposal createJavaCompletionProposal(CompletionProposal proposal) {
                AbstractJavaCompletionProposal prop;
                IJavaElement javaElement;
                IJavaCompletionProposal javaCompletionProposal = super.createJavaCompletionProposal(proposal);
                if (javaCompletionProposal instanceof AbstractJavaCompletionProposal && (javaElement = (prop = (AbstractJavaCompletionProposal)javaCompletionProposal).getJavaElement()) != null) {
                    if (filterCompletionName == null) {
                        ret.add(new Tuple((Object)javaElement, (Object)proposal));
                        return null;
                    }
                    if (javaElement.getElementName().equals(filterCompletionName)) {
                        ret.add(new Tuple((Object)javaElement, (Object)proposal));
                        return null;
                    }
                }
                return null;
            }
        };
        return collector;
    }

    @Override
    public String getPackageFolderName() {
        return this.name;
    }
}

