/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.python.pydev.core.IToken;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.AbstractPyCompletionProposalExtension2;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.hover.PyTextHover;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_ui.utils.RunInUiThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PyLinkedModeCompletionProposal
extends AbstractPyCompletionProposalExtension2
implements ICompletionProposalExtension {
    private int firstParameterLen = 0;
    private int nPositionsAdded = 0;
    private boolean goToLinkedMode = true;
    private IToken element;
    private int newForcedOffset = -1;
    private String computedInfo = null;

    public PyLinkedModeCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, IToken element, String displayString, IContextInformation contextInformation, int priority, int onApplyAction, String args) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, null, displayString, contextInformation, "", priority, onApplyAction, args);
        this.element = element;
    }

    public IToken getElement() {
        return this.element;
    }

    public PyLinkedModeCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, int onApplyAction, String args) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority, onApplyAction, args);
    }

    public PyLinkedModeCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, int onApplyAction, String args, boolean goToLinkedMode) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority, onApplyAction, args);
        this.goToLinkedMode = goToLinkedMode;
    }

    @Override
    public Image getImage() {
        if (this.element != null) {
            return this.element.getImage();
        }
        return super.getImage();
    }

    @Override
    public String getAdditionalProposalInfo() {
        if (this.computedInfo != null) {
            return this.computedInfo;
        }
        if (this.element != null) {
            if (this.element instanceof SourceToken) {
                SourceToken sourceToken = (SourceToken)this.element;
                SimpleNode ast = sourceToken.getAst();
                if (ast != null && (ast instanceof FunctionDef || ast instanceof ClassDef)) {
                    this.computedInfo = PyTextHover.printAst(null, ast);
                }
                if (this.computedInfo != null) {
                    return this.computedInfo;
                }
            }
            this.computedInfo = this.element.getDocStr();
            return this.computedInfo;
        }
        return super.getAdditionalProposalInfo();
    }

    @Override
    public Point getSelection(IDocument document) {
        if (this.newForcedOffset >= 0) {
            return new Point(this.newForcedOffset, 0);
        }
        if (this.onApplyAction == 2) {
            return null;
        }
        if (this.onApplyAction == 3) {
            if (this.fArgs.length() > 0) {
                return new Point(this.fReplacementOffset + this.fCursorPosition - 1, this.firstParameterLen);
            }
            return null;
        }
        if (this.onApplyAction == 1) {
            return new Point(this.fReplacementOffset + this.fCursorPosition + this.nPositionsAdded, this.firstParameterLen);
        }
        throw new RuntimeException("Unexpected apply mode:" + this.onApplyAction);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        boolean eat = (stateMask & SWT.MOD1) != 0;
        IDocument doc = viewer.getDocument();
        if (!this.triggerCharAppliesCurrentCompletion(trigger, doc, offset)) {
            this.newForcedOffset = offset + 1;
            return;
        }
        if (this.onApplyAction == 2) {
            return;
        }
        if (this.onApplyAction == 3) {
            try {
                String args = this.fArgs.length() > 0 ? this.fArgs.substring(1, this.fArgs.length() - 1) : "";
                super.apply(doc);
                if (!this.goToLinkedMode) {
                    return;
                }
                int iPar = -1;
                int exitPos = offset + args.length() + 1;
                this.goToLinkedModeFromArgs(viewer, offset, doc, exitPos, iPar, args);
            }
            catch (BadLocationException e) {
                Log.log((Throwable)e);
            }
            return;
        }
        if (this.onApplyAction == 1) {
            try {
                int dif = offset - this.fReplacementOffset;
                String strToAdd = this.fReplacementString.substring(dif);
                boolean doReturn = this.applyOnDoc(offset, eat, doc, dif, trigger);
                if (doReturn || !this.goToLinkedMode) {
                    return;
                }
                int iPar = strToAdd.indexOf(40);
                if (iPar != -1 && strToAdd.charAt(strToAdd.length() - 1) == ')') {
                    String newStr = strToAdd.substring(iPar + 1, strToAdd.length() - 1);
                    this.goToLinkedModeFromArgs(viewer, offset, doc, offset + strToAdd.length() + this.nPositionsAdded, iPar, newStr);
                }
            }
            catch (BadLocationException e) {
                Log.log((Throwable)e);
            }
            return;
        }
        throw new RuntimeException("Unexpected apply mode:" + this.onApplyAction);
    }

    public boolean applyOnDoc(int offset, boolean eat, IDocument doc, int dif, char trigger) throws BadLocationException {
        boolean doReturn = false;
        String rep = this.fReplacementString;
        int iPar = rep.indexOf(40);
        if (eat) {
            if (iPar != -1) {
                rep = rep.substring(0, iPar);
                doc.replace(offset - dif, dif + this.fLen, rep);
                if (!this.fLastIsPar) {
                    this.nPositionsAdded = -1;
                }
                doReturn = true;
            } else {
                int sumReplace = 0;
                if (rep.endsWith("=")) {
                    try {
                        char c = doc.getChar(offset + this.fLen);
                        if (c == '=') {
                            ++sumReplace;
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
                doc.replace(offset - dif, dif + this.fLen + sumReplace, rep);
            }
        } else {
            if (trigger == '.' || trigger == '(') {
                if (iPar != -1) {
                    rep = rep.substring(0, iPar);
                } else {
                    this.nPositionsAdded = 1;
                }
                rep = String.valueOf(rep) + trigger;
                if (trigger == '(') {
                    rep = String.valueOf(rep) + ')';
                }
                doReturn = true;
            }
            doc.replace(offset - dif, dif, rep);
        }
        return doReturn;
    }

    private void goToLinkedModeFromArgs(ITextViewer viewer, int offset, IDocument doc, int exitPos, int iPar, String newStr) throws BadLocationException {
        if (!this.goToLinkedMode) {
            return;
        }
        ArrayList<Integer> offsetsAndLens = new ArrayList<Integer>();
        FastStringBuffer buffer = new FastStringBuffer();
        int i = 0;
        while (i < newStr.length()) {
            char c = newStr.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                if (buffer.length() == 0) {
                    offsetsAndLens.add(i);
                    buffer.append(c);
                } else {
                    buffer.append(c);
                }
            } else if (buffer.length() > 0) {
                offsetsAndLens.add(buffer.length());
                buffer.clear();
            }
            ++i;
        }
        if (buffer.length() > 0) {
            offsetsAndLens.add(buffer.length());
        }
        buffer = null;
        this.goToLinkedMode(viewer, offset, doc, exitPos, iPar, offsetsAndLens);
    }

    private void goToLinkedMode(ITextViewer viewer, int offset, IDocument doc, int exitPos, int iPar, List<Integer> offsetsAndLens) throws BadLocationException {
        if (!this.goToLinkedMode) {
            return;
        }
        if (offsetsAndLens.size() > 0) {
            LinkedModeModel model = new LinkedModeModel();
            int i = 0;
            while (i < offsetsAndLens.size()) {
                Integer offs = offsetsAndLens.get(i);
                Integer len = offsetsAndLens.get(++i);
                if (i == 1) {
                    this.firstParameterLen = len;
                }
                int location = offset + iPar + offs + 1;
                LinkedPositionGroup group = new LinkedPositionGroup();
                ProposalPosition proposalPosition = new ProposalPosition(doc, location, len.intValue(), 0, new ICompletionProposal[0]);
                group.addPosition((LinkedPosition)proposalPosition);
                model.addGroup(group);
                ++i;
            }
            model.forceInstall();
            EditorLinkedModeUI ui = new EditorLinkedModeUI(model, viewer);
            ui.setDoContextInfo(true);
            ui.setExitPosition(viewer, exitPos, 0, Integer.MAX_VALUE);
            Runnable r = new Runnable((LinkedModeUI)ui){
                private final /* synthetic */ LinkedModeUI val$ui;
                {
                    this.val$ui = linkedModeUI;
                }

                public void run() {
                    this.val$ui.enter();
                }
            };
            RunInUiThread.async((Runnable)r);
        }
    }

    @Override
    public char[] getTriggerCharacters() {
        if (this.onApplyAction != 1) {
            return null;
        }
        return super.getTriggerCharacters();
    }

    public String toString() {
        return "PyLinkedModeCompletionProposal(" + this.getDisplayString() + ")";
    }

    void setLen(int i) {
        this.fLen = i;
    }
}

