/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import java.io.IOException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.editor.codecompletion.AbstractPyCompletionProposalExtension2;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Pass;
import org.python.pydev.parser.jython.ast.factory.AdapterPrefs;
import org.python.pydev.parser.jython.ast.factory.PyAstFactory;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.prettyprinterv2.IPrettyPrinterPrefs;
import org.python.pydev.parser.prettyprinterv2.MakeAstValidForPrettyPrintingVisitor;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterPrefsV2;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterV2;

public class OverrideMethodCompletionProposal
extends AbstractPyCompletionProposalExtension2 {
    private final FunctionDef functionDef;
    private final String parentClassName;
    private String currentClassName;

    public OverrideMethodCompletionProposal(int replacementOffset, int replacementLength, int cursorPosition, Image image, FunctionDef functionDef, String parentClassName, String currentClassName) {
        super("", replacementOffset, replacementLength, cursorPosition, 5);
        this.fImage = image;
        this.functionDef = functionDef;
        this.fDisplayString = String.valueOf(((NameTok)functionDef.name).id) + " (Override method in " + parentClassName + ")";
        this.parentClassName = parentClassName;
        this.currentClassName = currentClassName;
    }

    public void apply(IDocument document) {
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        int finalOffset = this.applyOnDocument(viewer, document, trigger, stateMask, offset);
        if (finalOffset >= 0) {
            try {
                PySelection ps = new PySelection(document, finalOffset);
                int firstCharPosition = PySelection.getFirstCharPosition((String)ps.getLine());
                int lineOffset = ps.getLineOffset();
                int location = lineOffset + firstCharPosition;
                int len = finalOffset - location;
                this.fCursorPosition = location;
                this.fReplacementLength = len;
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    public int applyOnDocument(ITextViewer viewer, IDocument document, char trigger, int stateMask, int offset) {
        Object versionProvider = null;
        PyEdit edit = null;
        if (viewer instanceof PySourceViewer) {
            PySourceViewer pySourceViewer = (PySourceViewer)viewer;
            edit = pySourceViewer.getEdit();
            versionProvider = edit;
        } else {
            versionProvider = new IGrammarVersionProvider(){

                public int getGrammarVersion() throws MisconfigurationException {
                    return 13;
                }
            };
        }
        String delimiter = PySelection.getDelimiter((IDocument)document);
        PyAstFactory factory = new PyAstFactory(new AdapterPrefs(delimiter, versionProvider));
        stmtType overrideBody = factory.createOverrideBody(this.functionDef, this.parentClassName, this.currentClassName);
        FunctionDef functionDef = this.functionDef.createCopy(false);
        functionDef.body = new stmtType[]{overrideBody != null ? overrideBody : new Pass()};
        try {
            MakeAstValidForPrettyPrintingVisitor.makeValid((SimpleNode)functionDef);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        String printed = OverrideMethodCompletionProposal.printAst(edit, (SimpleNode)functionDef, delimiter);
        PySelection ps = new PySelection(document, offset);
        try {
            String lineContentsToCursor = ps.getLineContentsToCursor();
            int defIndex = lineContentsToCursor.indexOf("def");
            int defOffset = ps.getLineOffset() + defIndex;
            printed = StringUtils.indentTo((String)printed, (String)lineContentsToCursor.substring(0, defIndex), (boolean)false);
            printed = StringUtils.rightTrim((String)printed);
            this.fLen += offset - defOffset;
            document.replace(defOffset, this.fLen, printed);
            return defOffset + printed.length();
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public static String printAst(PyEdit edit, SimpleNode astToPrint, String lineDelimiter) {
        String str = null;
        if (astToPrint != null) {
            IIndentPrefs indentPrefs = edit != null ? edit.getIndentPrefs() : DefaultIndentPrefs.get();
            PrettyPrinterPrefsV2 prefsV2 = PrettyPrinterV2.createDefaultPrefs((IGrammarVersionProvider)edit, (IIndentPrefs)indentPrefs, (String)lineDelimiter);
            PrettyPrinterV2 prettyPrinterV2 = new PrettyPrinterV2((IPrettyPrinterPrefs)prefsV2);
            try {
                str = prettyPrinterV2.print(astToPrint);
            }
            catch (IOException e) {
                Log.log((Throwable)e);
            }
        }
        return str;
    }

    public char[] getTriggerCharacters() {
        return null;
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fCursorPosition, this.fReplacementLength);
    }
}

