/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.actions.PyFormatStd;
import org.python.pydev.shared_core.actions.LineCommentAction;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyComment
extends PyAction {
    protected PyFormatStd.FormatStd std;

    public PyComment(PyFormatStd.FormatStd std) {
        this.std = std;
    }

    public PyComment() {
        this(null);
    }

    public void run(IAction action) {
        try {
            if (!this.canModifyEditor()) {
                return;
            }
            PyEdit pyEdit = this.getPyEdit();
            this.std = pyEdit.getFormatStd();
            IDocument document = pyEdit.getDocumentProvider().getDocument((Object)pyEdit.getEditorInput());
            ITextSelection selection = (ITextSelection)pyEdit.getSelectionProvider().getSelection();
            TextSelectionUtils ps = new TextSelectionUtils(document, selection);
            Tuple<Integer, Integer> repRegion = this.perform(ps);
            pyEdit.selectAndReveal((Integer)repRegion.o1, (Integer)repRegion.o2);
        }
        catch (Exception e) {
            PyComment.beep(e);
        }
    }

    public Tuple<Integer, Integer> perform(TextSelectionUtils ps) throws BadLocationException {
        return this.performComment(ps);
    }

    protected Tuple<Integer, Integer> performComment(TextSelectionUtils ps) throws BadLocationException {
        LineCommentAction lineCommentAction = new LineCommentAction(ps, "#", this.std.spacesInStartComment);
        return lineCommentAction.execute();
    }
}

