/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.templating.velocity.engine;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oracle.eclipse.tools.common.templating.velocity.logging.MessageServiceLogSystem;
import oracle.eclipse.tools.common.templating.velocity.registry.DirectiveRegistry;
import org.apache.velocity.app.VelocityEngine;

public class VelocityEngineFactory {
    public static final String USERDIRECTIVE = "userdirective";
    public static final String MAX_RECURSION_DEPTH = "20";

    public static VelocityEngine makeEngine(Properties origProps) throws Exception {
        Properties configProps = new Properties();
        configProps.putAll((Map<?, ?>)origProps);
        String userdirective = configProps.getProperty(USERDIRECTIVE);
        assert (userdirective == null) : "userdirectives cannot be specified at this time -- " + userdirective;
        StringBuffer buffer = new StringBuffer();
        Set<String> directives = DirectiveRegistry.getUserDirectives();
        for (String nextDirective : directives) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(nextDirective);
        }
        userdirective = buffer.toString();
        configProps.setProperty(USERDIRECTIVE, userdirective);
        configProps.setProperty("runtime.log.logsystem.class", MessageServiceLogSystem.class.getName());
        configProps.setProperty("directive.parse.max.depth", MAX_RECURSION_DEPTH);
        VelocityEngine instance = new VelocityEngine();
        instance.init(configProps);
        return instance;
    }
}

