/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.templating.filetemplate;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateCorePlugin;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateDescriptor;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateProjectDescriptor;
import oracle.eclipse.tools.common.templating.filetemplate.IFileTemplateBean;
import oracle.eclipse.tools.common.templating.filetemplate.TemplateProjectCache;
import oracle.eclipse.tools.common.templating.filetemplate.templatedef.model.TemplateProjectDocument;
import oracle.eclipse.tools.common.util.ResourceLoader;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.apache.xmlbeans.XmlException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;

public class WorkspaceTemplateProjectCache
extends TemplateProjectCache {
    private static final ResourceLoader _resourceLoader = new ResourceLoader(WorkspaceTemplateProjectCache.class);

    private static Collection<FileTemplateProjectDescriptor> getWorkspaceTemplateProjects() {
        IProject[] projects;
        ArrayList<FileTemplateProjectDescriptor> workspaceProjects = new ArrayList<FileTemplateProjectDescriptor>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                IProject nextProject = iProjectArray[n2];
                if (nextProject.isOpen()) {
                    try {
                        IFile projectXML;
                        if (!nextProject.hasNature("oracle.eclipse.tools.common.templating.filetemplate.templateProjectNature") || !(projectXML = nextProject.getFile("templateProject.xml")).exists()) break block9;
                        InputStream inStream = projectXML.getContents();
                        try {
                            TemplateProjectDocument.TemplateProject project = WorkspaceTemplateProjectCache.parseTemplateProject(inStream);
                            String description = _resourceLoader.resource("templateProjectDescription", new Object[]{nextProject.getName()});
                            FileTemplateProjectDescriptor projectDescriptor = FileTemplateProjectDescriptor.createFileTemplateProjectDesccriptor(project, nextProject.getLocation().append("templateProject.xml"), description, nextProject);
                            workspaceProjects.add(projectDescriptor);
                        }
                        catch (IOException ioe) {
                            LoggingService.logException((Plugin)FileTemplateCorePlugin.getDefault(), (Throwable)ioe);
                            assert (false) : ioe.getLocalizedMessage();
                        }
                        catch (XmlException xmle) {
                            LoggingService.logException((Plugin)FileTemplateCorePlugin.getDefault(), (Throwable)xmle);
                            assert (false) : xmle.getLocalizedMessage();
                        }
                    }
                    catch (CoreException ce) {
                        LoggingService.logException((Plugin)FileTemplateCorePlugin.getDefault(), (CoreException)ce);
                    }
                }
            }
            ++n2;
        }
        return workspaceProjects;
    }

    public static FileTemplateDescriptor getWorkspaceFileTemplateDescriptorByID(String id) {
        Collection<FileTemplateProjectDescriptor> workspaceProjects = WorkspaceTemplateProjectCache.getWorkspaceTemplateProjects();
        for (FileTemplateProjectDescriptor nextProject : workspaceProjects) {
            FileTemplateDescriptor descriptor = nextProject.getTemplateByID(id);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    public static Collection<FileTemplateProjectDescriptor> getWorkspaceProjectsForType(Class<? extends IFileTemplateBean> type) {
        ArrayList<FileTemplateProjectDescriptor> projectsWithType = new ArrayList<FileTemplateProjectDescriptor>();
        Collection<FileTemplateProjectDescriptor> workspaceProjects = WorkspaceTemplateProjectCache.getWorkspaceTemplateProjects();
        for (FileTemplateProjectDescriptor nextProject : workspaceProjects) {
            if (!nextProject.hasType(type)) continue;
            projectsWithType.add(nextProject);
        }
        return projectsWithType;
    }
}

