/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.templating.filetemplate;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateCorePlugin;
import oracle.eclipse.tools.common.templating.filetemplate.templatedef.model.TemplateProjectDocument;
import oracle.eclipse.tools.common.util.ResourceLoader;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.apache.xmlbeans.XmlException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;

abstract class TemplateProjectCache {
    private static final ResourceLoader _resourceLoader = new ResourceLoader(TemplateProjectCache.class);

    TemplateProjectCache() {
    }

    static TemplateProjectDocument.TemplateProject parseTemplateProject(InputStream inStream) throws IOException, XmlException {
        assert (inStream != null);
        TemplateProjectDocument parsedDoc = TemplateProjectDocument.Factory.parse(inStream);
        return parsedDoc.getTemplateProject();
    }

    static TemplateProjectDocument.TemplateProject parseTemplateProject(File file) {
        TemplateProjectDocument.TemplateProject templateProject;
        block6: {
            assert (file != null);
            templateProject = null;
            try (FileInputStream inStream = new FileInputStream(file);){
                TemplateProjectDocument parsedDoc = TemplateProjectDocument.Factory.parse(inStream);
                templateProject = parsedDoc.getTemplateProject();
            }
            catch (Exception e) {
                String message = _resourceLoader.resource("error.templateProjectParseError", new Object[]{file.getAbsolutePath()});
                LoggingService.logException((Plugin)FileTemplateCorePlugin.getDefault(), (Throwable)e, (String)message);
                if ($assertionsDisabled || e instanceof CoreException || e instanceof IOException || e instanceof XmlException) break block6;
                throw new AssertionError();
            }
        }
        return templateProject;
    }
}

