/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.templating.filetemplate;

import java.io.IOException;
import java.util.Map;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateCorePlugin;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.FormatProcessorsExtensionReader;

public class FormattingService {
    private static final String LINE_DELIMITER = System.getProperty("line.separator", "\n");

    private static void edit(IDocument doc, TextEdit edit) {
        if (edit == null) {
            return;
        }
        try {
            edit.apply(doc, 0);
        }
        catch (MalformedTreeException mte) {
            LoggingService.logException((Plugin)FileTemplateCorePlugin.getDefault(), (Throwable)mte);
        }
        catch (BadLocationException ble) {
            LoggingService.logException((Plugin)FileTemplateCorePlugin.getDefault(), (Throwable)ble);
        }
    }

    private static String formatJava(IProject project, String source) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        Map options = null;
        if (javaProject != null) {
            options = javaProject.getOptions(true);
        }
        TextEdit edit = ToolFactory.createCodeFormatter(options).format(8, source, 0, source.length(), 0, LINE_DELIMITER);
        Document doc = new Document(source);
        FormattingService.edit((IDocument)doc, edit);
        return doc.get();
    }

    public static String formatSource(IProject project, IPath filePath, String contents) {
        assert (filePath != null);
        String outputContents = null;
        String fileName = filePath.lastSegment();
        outputContents = JavaConventions.validateCompilationUnitName((String)fileName, (String)"1.3", (String)"1.3").isOK() ? FormattingService.formatJava(project, contents) : contents;
        return outputContents;
    }

    public static void formatJsp(IFile file, int offset, int length) {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IPath path = file.getFullPath();
        try {
            try {
                bufferManager.connect(path, LocationKind.NORMALIZE, null);
                ITextFileBuffer buff = bufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.NORMALIZE);
                assert (buff != null) : "Couldn't get a TextFileBuffer for: " + file;
                IDocument doc = buff.getDocument();
                IContentDescription contentDescription = null;
                contentDescription = file.getContentDescription();
                if (contentDescription != null) {
                    FormattingService.formatDocument(doc, contentDescription, offset, length);
                }
            }
            finally {
                bufferManager.disconnect(path, LocationKind.NORMALIZE, null);
            }
        }
        catch (IOException e) {
            LoggingService.logException((Plugin)FileTemplateCorePlugin.getDefault(), (Throwable)e);
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)FileTemplateCorePlugin.getDefault(), (CoreException)e);
        }
    }

    public static void formatDocument(IDocument doc, IContentDescription contentDescription, int offset, int length) throws IOException, CoreException {
        if (contentDescription != null) {
            IContentType contentType = contentDescription.getContentType();
            IStructuredFormatProcessor formatProcessor = FormatProcessorsExtensionReader.getInstance().getFormatProcessor(contentType.getId());
            if (formatProcessor != null) {
                formatProcessor.formatDocument(doc, offset, length);
            } else {
                LoggingService.logDebug((Plugin)FileTemplateCorePlugin.getDefault(), (String)"tried to format inserted text, but no FormatProcessor was found");
            }
        }
    }
}

