/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.templating.filetemplate;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateCorePlugin;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateDescriptor;
import oracle.eclipse.tools.common.templating.filetemplate.IFileTemplateBean;
import oracle.eclipse.tools.common.templating.filetemplate.templatedef.model.TemplateDocument;
import oracle.eclipse.tools.common.templating.filetemplate.templatedef.model.TemplateProjectDocument;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class FileTemplateProjectDescriptor {
    private String _description;
    private ImageDescriptor _icon;
    private IPath _location;
    private TemplateProjectDocument.TemplateProject _project;
    private List<FileTemplateDescriptor> _allTemplates;
    private Map<String, List<FileTemplateDescriptor>> _typeTemplateMap;
    private Map<String, FileTemplateDescriptor> _idTemplateMap;
    private static final String DEFAULT_PROJECT_ICON_PATH = "icons/templateproject_16.gif";
    private static final ImageDescriptor DEFAULT_PROJECT_ICON = FileTemplateProjectDescriptor.getImageDescriptorFromRoot("icons/templateproject_16.gif");
    private static final String DEFAULT_TEMPLATE_ICON_PATH = "icons/template_16.gif";
    private static final ImageDescriptor DEFAULT_TEMPLATE_ICON = FileTemplateProjectDescriptor.getImageDescriptorFromRoot("icons/template_16.gif");
    private IProject _workspaceProject;
    private Bundle _bundle;
    private boolean _isDeclared;

    private FileTemplateProjectDescriptor(TemplateProjectDocument.TemplateProject project, IPath location, String description, Bundle bundle) {
        this(project, location, description, true);
        assert (bundle != null);
        this._bundle = bundle;
    }

    private FileTemplateProjectDescriptor(TemplateProjectDocument.TemplateProject project, IPath location, String description, IProject workspaceProject) {
        this(project, location, description, false);
        assert (workspaceProject != null);
        this._workspaceProject = workspaceProject;
    }

    private FileTemplateProjectDescriptor(TemplateProjectDocument.TemplateProject project, IPath location, String description, boolean isDeclared) {
        assert (project != null);
        assert (location != null);
        assert (location.isAbsolute());
        this._project = project;
        this._location = location;
        this._description = description;
        this._isDeclared = isDeclared;
        this._typeTemplateMap = new HashMap<String, List<FileTemplateDescriptor>>();
        this._allTemplates = new Vector<FileTemplateDescriptor>();
        this._idTemplateMap = new HashMap<String, FileTemplateDescriptor>();
        String projectIcon = project.getIcon();
        if (projectIcon != null) {
            IPath iconPath = location.append(projectIcon);
            try {
                URL url = new URL(iconPath.toString());
                this._icon = ImageDescriptor.createFromURL((URL)url);
            }
            catch (MalformedURLException mfue) {
                LoggingService.logException((Plugin)FileTemplateCorePlugin.getDefault(), (Throwable)mfue);
                this._icon = DEFAULT_PROJECT_ICON;
            }
        } else {
            this._icon = DEFAULT_PROJECT_ICON;
        }
    }

    public static FileTemplateProjectDescriptor createFileTemplateProjectDesccriptor(TemplateProjectDocument.TemplateProject project, IPath location, String description, Bundle bundle) {
        FileTemplateProjectDescriptor descriptor = new FileTemplateProjectDescriptor(project, location, description, bundle);
        descriptor.init();
        return descriptor;
    }

    public static FileTemplateProjectDescriptor createFileTemplateProjectDesccriptor(TemplateProjectDocument.TemplateProject project, IPath location, String description, IProject workspaceProject) {
        FileTemplateProjectDescriptor descriptor = new FileTemplateProjectDescriptor(project, location, description, workspaceProject);
        descriptor.init();
        return descriptor;
    }

    public String getDisplayName() {
        return this._description != null ? this._description : this._location.toString();
    }

    public ImageDescriptor getIcon() {
        return this._icon;
    }

    static ImageDescriptor getImageDescriptorFromRoot(String iconPath) {
        ImageDescriptor descriptor = null;
        Bundle bundle = FileTemplateCorePlugin.getDefault().getBundle();
        URL iconDir = FileLocator.find((Bundle)bundle, (IPath)new Path(iconPath), null);
        try {
            URL localURL = FileLocator.toFileURL((URL)iconDir);
            descriptor = ImageDescriptor.createFromURL((URL)localURL);
        }
        catch (IOException ioe) {
            LoggingService.logException((Plugin)FileTemplateCorePlugin.getDefault(), (Throwable)ioe);
        }
        return descriptor;
    }

    public IPath getLocation() {
        return this._location;
    }

    public IPath getLocationContainer() {
        return this._location.removeLastSegments(1);
    }

    public List<FileTemplateDescriptor> getTemplates() {
        return this._allTemplates;
    }

    public FileTemplateDescriptor getTemplateByID(String id) {
        return this._idTemplateMap.get(id);
    }

    public List<FileTemplateDescriptor> getTemplatesForType(Class<? extends IFileTemplateBean> typeClass) {
        List<FileTemplateDescriptor> templates = this._typeTemplateMap.get(typeClass.getName());
        if (templates == null) {
            templates = Collections.emptyList();
        }
        return templates;
    }

    TemplateProjectDocument.TemplateProject getTemplateProject() {
        return this._project;
    }

    public Set<String> getTypes() {
        return this._typeTemplateMap.keySet();
    }

    public boolean hasType(Class<? extends IFileTemplateBean> type) {
        return this._typeTemplateMap.containsKey(type.getName());
    }

    private void init() {
        this._typeTemplateMap = this.parseTemplates(this._project, this._location);
    }

    ImageDescriptor loadTemplateImageDescriptor(String iconPath) {
        ImageDescriptor descriptor = DEFAULT_TEMPLATE_ICON;
        if (iconPath != null) {
            if (this._isDeclared) {
                URL iconURL = FileLocator.find((Bundle)this._bundle, (IPath)new Path(iconPath), null);
                if (iconURL != null) {
                    try {
                        URL localIconURL = FileLocator.toFileURL((URL)iconURL);
                        descriptor = ImageDescriptor.createFromURL((URL)localIconURL);
                    }
                    catch (IOException iOException) {
                        LoggingService.logDebug((Plugin)FileTemplateCorePlugin.getDefault(), (String)("Could not load the bundle image:" + iconURL.toString()));
                        descriptor = DEFAULT_TEMPLATE_ICON;
                    }
                }
            } else {
                IPath location = this._workspaceProject.getLocation();
                IPath iconLocation = location.append(iconPath);
                ImageData imageData = new ImageData(iconLocation.toString());
                Image image = new Image((Device)Display.getCurrent(), imageData);
                descriptor = ImageDescriptor.createFromImage((Image)image);
            }
        }
        return descriptor;
    }

    private Map<String, List<FileTemplateDescriptor>> parseTemplates(TemplateProjectDocument.TemplateProject project, IPath projectLocation) {
        TemplateDocument.Template[] templates;
        HashMap<String, List<FileTemplateDescriptor>> descriptors = new HashMap<String, List<FileTemplateDescriptor>>();
        TemplateDocument.Template[] templateArray = templates = project.getTemplateArray();
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateDocument.Template nextTemplate = templateArray[n2];
            FileTemplateDescriptor templateDescriptor = new FileTemplateDescriptor(nextTemplate, this, this._bundle);
            this._idTemplateMap.put(templateDescriptor.getID(), templateDescriptor);
            this._allTemplates.add(templateDescriptor);
            String type = nextTemplate.getTypeClass();
            List<FileTemplateDescriptor> types = descriptors.get(type);
            if (types == null) {
                types = new ArrayList<FileTemplateDescriptor>();
                descriptors.put(type, types);
            }
            types.add(templateDescriptor);
            ++n2;
        }
        return descriptors;
    }
}

