/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.templating.filetemplate;

import com.bea.wlw.template.ITemplateBean;
import com.bea.wlw.template.TemplateBeanAdapter;
import com.bea.wlw.template.exceptions.GenerationFailedException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateCorePlugin;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateDescriptor;
import oracle.eclipse.tools.common.templating.filetemplate.FileTemplateGenerationFailedException;
import oracle.eclipse.tools.common.templating.filetemplate.FormattingService;
import oracle.eclipse.tools.common.templating.filetemplate.IContextAdapter;
import oracle.eclipse.tools.common.templating.filetemplate.IFileTemplateBean;
import oracle.eclipse.tools.common.templating.filetemplate.templatedef.model.ResourceDocument;
import oracle.eclipse.tools.common.templating.filetemplate.templatedef.model.ResourceRefDocument;
import oracle.eclipse.tools.common.templating.filetemplate.templatedef.model.SourceDocument;
import oracle.eclipse.tools.common.templating.filetemplate.templatedef.model.SourceRefDocument;
import oracle.eclipse.tools.common.templating.template.core.TemplateService;
import oracle.eclipse.tools.common.util.ResourceLoader;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

class FileTemplateProcessor {
    private static final ResourceLoader _resourceLoader = new ResourceLoader(FileTemplateProcessor.class);
    private boolean _forceCreate;
    private IPath _projectSourceRoot;
    private boolean _formatOutput;
    private final FileTemplateDescriptor _templateDescriptor;
    private static final char BEGIN_SUBSTITUTION_CHAR = '$';
    private static final char BEGIN_SUBSTITUTION_SET = '{';
    private static final char END_SUBSTITUTION_SET = '}';

    FileTemplateProcessor(FileTemplateDescriptor templateDescriptor, boolean forceCreate, boolean formatOutput) {
        assert (templateDescriptor != null);
        this._templateDescriptor = templateDescriptor;
        this._projectSourceRoot = templateDescriptor.getParentProject().getLocation().removeLastSegments(1);
        this._forceCreate = forceCreate;
        this._formatOutput = formatOutput;
    }

    private IContainer ensureFolder(IPath folderPath, IProject root) throws CoreException {
        if (folderPath.isEmpty() || folderPath.isRoot()) {
            return root;
        }
        IFolder folder = root.getFolder(folderPath);
        if (!folder.exists()) {
            if (folderPath.toString().indexOf("/") != -1) {
                this.ensureFolder(folderPath.removeLastSegments(1), root);
            }
            folder.create(this._forceCreate, true, null);
        }
        return folder;
    }

    private ResourceDocument.Resource findResourceByID(String id) {
        ResourceDocument.Resource[] allResources;
        assert (id != null);
        ResourceDocument.Resource found = null;
        ResourceDocument.Resource[] resourceArray = allResources = this._templateDescriptor.getParentProject().getTemplateProject().getResourceArray();
        int n = allResources.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceDocument.Resource nextResource = resourceArray[n2];
            if (id.equals(nextResource.getId())) {
                found = nextResource;
                break;
            }
            ++n2;
        }
        return found;
    }

    private SourceDocument.Source findSourceByID(String id) {
        SourceDocument.Source[] allSources;
        assert (id != null);
        SourceDocument.Source found = null;
        SourceDocument.Source[] sourceArray = allSources = this._templateDescriptor.getParentProject().getTemplateProject().getSourceArray();
        int n = allSources.length;
        int n2 = 0;
        while (n2 < n) {
            SourceDocument.Source nextSource = sourceArray[n2];
            if (id.equals(nextSource.getId())) {
                found = nextSource;
                break;
            }
            ++n2;
        }
        return found;
    }

    private String getProjectName(IProject project) {
        String projectName = _resourceLoader.resource("label.project", new Object[0]);
        if (project != null) {
            projectName = project.getName();
        }
        return projectName;
    }

    private IFileTemplateBean getTemplateBeanForSource(IProject targetProject, SourceRefDocument.SourceRef sourceRef, Map<String, IFileTemplateBean> context) {
        IContextAdapter contextAdapter;
        String contextRef = sourceRef.getContext();
        IFileTemplateBean bean = context.get(contextRef);
        String contextAdapterClass = sourceRef.getContextAdapter();
        if (contextAdapterClass != null && (contextAdapter = this._templateDescriptor.loadContextAdapter(contextAdapterClass)) != null) {
            bean = contextAdapter.getAdaptedBean(targetProject, bean);
        }
        return bean;
    }

    private IPath processTemplateSource(SourceDocument.Source inputSource, IProject targetProject, IPath targetPath, IPath targetFileName, IFileTemplateBean context, String encoding, IProgressMonitor progressMonitor, boolean isPreview) throws GenerationFailedException, FileTemplateGenerationFailedException {
        assert (inputSource != null);
        assert (targetPath != null);
        assert (targetFileName != null);
        IPath resultPath = null;
        String templateSource = inputSource.getFile();
        Path templateSourcePath = new Path(templateSource);
        IPath templateInputFilePath = this._projectSourceRoot.append((IPath)templateSourcePath);
        IPath targetProjectPath = targetPath;
        String targetFilePathString = targetFileName.toString();
        IPath templateFileOutputPath = targetProjectPath.append((IPath)new Path(targetFilePathString));
        InputStream stream = null;
        try {
            if (!isPreview) {
                ArrayList<ITemplateBean> contextList = new ArrayList<ITemplateBean>();
                if (context != null) {
                    contextList.add(context);
                }
                CommonFileTemplateParametersBean commonContext = new CommonFileTemplateParametersBean(templateFileOutputPath);
                contextList.add(commonContext);
                StringWriter stringWriter = new StringWriter();
                TemplateService.generate(templateInputFilePath, contextList, stringWriter);
                String fileContent = stringWriter.toString();
                if (this._formatOutput) {
                    fileContent = FormattingService.formatSource(targetProject, templateFileOutputPath, fileContent);
                }
                if (encoding != null && !isPreview) {
                    try {
                        stream = new ByteArrayInputStream(fileContent.getBytes(encoding));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new GenerationFailedException(e);
                    }
                } else {
                    stream = new ByteArrayInputStream(fileContent.getBytes());
                }
            }
            resultPath = this.setFileContents(targetProject, templateFileOutputPath, stream, progressMonitor, isPreview);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ioe) {
                LoggingService.logException((Plugin)FileTemplateCorePlugin.getDefault(), (Throwable)ioe);
            }
        }
        return resultPath;
    }

    private IPath processTemplateResource(ResourceDocument.Resource resource, IProject targetProject, String rawOutputPath, Map<String, String> projectVariables, IProgressMonitor progressMonitor, boolean isPreview) throws FileTemplateGenerationFailedException {
        IPath resultingPath;
        block10: {
            resultingPath = null;
            String resourcePathString = resource.getPath();
            IPath resourceInputPath = this._projectSourceRoot.append(resourcePathString);
            File resourceInFile = resourceInputPath.toFile();
            if (resourceInFile.exists()) {
                try {
                    IPath resourceOutputPath = this.substituteOutputPath(rawOutputPath, projectVariables);
                    if (resourceOutputPath.isEmpty()) {
                        throw new FileTemplateGenerationFailedException(_resourceLoader.resource("error.fileTemplateGenerationFailed.nullResourcePath", new Object[0]));
                    }
                    this.verifyOutputPath(targetProject, resourceOutputPath, isPreview);
                    FileInputStream fileInput = null;
                    if (!isPreview) {
                        fileInput = new FileInputStream(resourceInFile);
                    }
                    try {
                        resultingPath = this.setFileContents(targetProject, resourceOutputPath, fileInput, progressMonitor, isPreview);
                        break block10;
                    }
                    finally {
                        if (fileInput != null) {
                            fileInput.close();
                        }
                    }
                }
                catch (FileNotFoundException fnfe) {
                    String message = _resourceLoader.resource("error.fileTemplateGenerationFailed.generic", new Object[]{fnfe.getLocalizedMessage()});
                    throw new FileTemplateGenerationFailedException(message);
                }
                catch (IOException ioe) {
                    String message = _resourceLoader.resource("error.fileTemplateGenerationFailed.generic", new Object[]{ioe.getLocalizedMessage()});
                    throw new FileTemplateGenerationFailedException(message);
                }
            }
            String message = _resourceLoader.resource("error.fileTemplateGenerationFailed.sourceNotFound", new Object[]{resourceInputPath});
            throw new FileTemplateGenerationFailedException(message);
        }
        return resultingPath;
    }

    List<IPath> processTemplate(final IProject targetProject, final Map<String, IFileTemplateBean> context, final Map<String, String> projectVariables, final boolean isPreview) throws InvocationTargetException, InterruptedException, FileTemplateGenerationFailedException {
        assert (context != null);
        assert (projectVariables != null);
        final Vector<IPath> results = new Vector<IPath>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation((ISchedulingRule)root){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                try {
                    ResourceRefDocument.ResourceRef[] resourceFiles;
                    SourceRefDocument.SourceRef[] sourceFiles;
                    SourceRefDocument.SourceRef[] sourceRefArray = sourceFiles = FileTemplateProcessor.this._templateDescriptor.getTemplate().getSourceRefArray();
                    int n = sourceFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int lastDot;
                        String fileName;
                        String encoding;
                        SourceRefDocument.SourceRef nextSourceRef = sourceRefArray[n2];
                        String sourceID = nextSourceRef.getSource();
                        SourceDocument.Source source = FileTemplateProcessor.this.findSourceByID(sourceID);
                        String string = encoding = nextSourceRef.isSetEncoding() ? nextSourceRef.getEncoding() : null;
                        if (source == null) {
                            String message = _resourceLoader.resource("error.fileTemplateGenerationFailed.sourceDefinitionNotFound", new Object[]{nextSourceRef.getSource()});
                            throw new InvocationTargetException(new FileTemplateGenerationFailedException(message));
                        }
                        IFileTemplateBean contextBean = FileTemplateProcessor.this.getTemplateBeanForSource(targetProject, nextSourceRef, context);
                        Path sourceFilePath = new Path(source.getFile());
                        String string2 = fileName = contextBean != null ? contextBean.getOutputFileName() : null;
                        if (fileName == null && (lastDot = (fileName = sourceFilePath.lastSegment()).lastIndexOf(46)) > 0) {
                            fileName = fileName.substring(0, lastDot);
                        }
                        if (fileName != null && fileName.indexOf(46) == 0 && fileName.length() == 1) {
                            String message = _resourceLoader.resource("error.fileTemplateGenerationFailed.illegalInputPath", new Object[0]);
                            FileTemplateGenerationFailedException rootException = new FileTemplateGenerationFailedException(message);
                            throw new InvocationTargetException(rootException);
                        }
                        Path fileNameExtensionPath = new Path(fileName);
                        String extension = fileNameExtensionPath.getFileExtension();
                        if (extension == null || extension.length() == 0) {
                            IPath fileNamePath = fileNameExtensionPath.removeFileExtension();
                            fileNameExtensionPath = fileNamePath.addFileExtension(source.getType());
                        }
                        try {
                            IPath targetPath;
                            IPath iPath = targetPath = contextBean != null ? contextBean.getProjectRelativeOutputPath() : null;
                            if (targetPath == null) {
                                targetPath = sourceFilePath.removeLastSegments(1);
                            }
                            FileTemplateProcessor.this.verifyOutputPath(targetProject, targetPath, isPreview);
                            IPath resultPath = FileTemplateProcessor.this.processTemplateSource(source, targetProject, targetPath, (IPath)fileNameExtensionPath, contextBean, encoding, monitor, isPreview);
                            if (resultPath != null) {
                                results.add(resultPath);
                            }
                        }
                        catch (GenerationFailedException gfe) {
                            throw new InvocationTargetException(gfe);
                        }
                        catch (FileTemplateGenerationFailedException ftgfe) {
                            throw new InvocationTargetException(ftgfe);
                        }
                        ++n2;
                    }
                    ResourceRefDocument.ResourceRef[] resourceRefArray = resourceFiles = FileTemplateProcessor.this._templateDescriptor.getTemplate().getResourceRefArray();
                    int n3 = resourceFiles.length;
                    n = 0;
                    while (n < n3) {
                        ResourceRefDocument.ResourceRef nextResourceRef = resourceRefArray[n];
                        String resourceID = nextResourceRef.getResource();
                        if (resourceID == null) {
                            String descriptorID = FileTemplateProcessor.this._templateDescriptor.getID();
                            LoggingService.logWarning((Plugin)FileTemplateCorePlugin.getDefault(), (String)_resourceLoader.resource("warning.noResourceIDGiven", new Object[]{descriptorID}));
                        } else {
                            String outputPath = nextResourceRef.getOutputpath();
                            ResourceDocument.Resource resource = FileTemplateProcessor.this.findResourceByID(resourceID);
                            if (resource == null) {
                                String message = _resourceLoader.resource("error.fileTemplateGenerationFailed.resourceDefinitionNotFound", new Object[]{nextResourceRef.getResource()});
                                throw new InvocationTargetException(new FileTemplateGenerationFailedException(message));
                            }
                            try {
                                IPath resultPath = FileTemplateProcessor.this.processTemplateResource(resource, targetProject, outputPath, projectVariables, monitor, isPreview);
                                if (resultPath != null) {
                                    results.add(resultPath);
                                }
                            }
                            catch (FileTemplateGenerationFailedException ftgfe) {
                                throw new InvocationTargetException(ftgfe);
                            }
                        }
                        ++n;
                    }
                    return;
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException(e.getMessage());
                }
            }
        };
        try {
            op.run(null);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof FileTemplateGenerationFailedException) {
                throw (FileTemplateGenerationFailedException)cause;
            }
            throw ite;
        }
        return results;
    }

    private IPath setFileContents(IProject outputProject, IPath outputFile, InputStream fileContents, IProgressMonitor progressMonitor, boolean isPreview) throws FileTemplateGenerationFailedException {
        IPath results = null;
        if (!isPreview) {
            assert (fileContents != null);
            IPath containerPath = outputFile.removeLastSegments(1);
            try {
                IContainer outputContainer = this.ensureFolder(containerPath, outputProject);
                String outputFileName = outputFile.lastSegment();
                IFile file = outputContainer.getFile((IPath)new Path(outputFileName));
                if (file.exists()) {
                    file.setContents(fileContents, this._forceCreate, true, progressMonitor);
                } else {
                    file.create(fileContents, this._forceCreate, progressMonitor);
                }
                results = new Path(outputProject.getName()).append(file.getProjectRelativePath());
            }
            catch (CoreException ce) {
                String message = _resourceLoader.resource("error.fileTemplateGenerationFailed.copyFailed", new Object[]{outputFile, ce.getLocalizedMessage()});
                throw new FileTemplateGenerationFailedException(message);
            }
        } else {
            results = new Path(this.getProjectName(outputProject)).append(outputFile);
        }
        return results;
    }

    private IPath substituteOutputPath(String rawPath, Map<String, String> variables) throws FileTemplateGenerationFailedException {
        String newValue;
        int index;
        String firstSegment;
        if (rawPath == null) {
            throw new FileTemplateGenerationFailedException(_resourceLoader.resource("error.fileTemplateGenerationFailed.nullResourcePath", new Object[0]));
        }
        Path newPath = new Path(rawPath);
        if (!newPath.isEmpty() && (firstSegment = newPath.segment(0)).length() > 3 && firstSegment.charAt(0) == '$' && firstSegment.charAt(1) == '{' && (index = (firstSegment = firstSegment.substring(2)).indexOf(125)) > 0 && (firstSegment = firstSegment.substring(0, index)).length() > 0 && (newValue = variables.get(firstSegment)) != null) {
            IPath tempPath = newPath.removeFirstSegments(1);
            newPath = new Path(newValue).append(tempPath);
        }
        return newPath;
    }

    private void verifyOutputPath(IProject project, IPath targetPath, boolean isPreview) throws FileTemplateGenerationFailedException {
        assert (project != null);
        assert (targetPath != null);
        if (!targetPath.isEmpty() && !targetPath.isRoot()) {
            try {
                project.getFolder(targetPath);
            }
            catch (Exception e) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("VERIFY OUTPUT PATH FAILED: PROJECT<");
                buffer.append(project.getName());
                buffer.append("> PATH<");
                buffer.append(targetPath.toString());
                buffer.append(">");
                LoggingService.logDebug((Plugin)FileTemplateCorePlugin.getDefault(), (String)buffer.toString());
                throw new FileTemplateGenerationFailedException(e.getLocalizedMessage());
            }
            if (!isPreview) {
                if (!project.exists()) {
                    String message = _resourceLoader.resource("error.fileTemplateGenerationFailed.projectDoesNotExist", new Object[]{project.getName()});
                    throw new FileTemplateGenerationFailedException(message);
                }
                if (!project.isOpen()) {
                    String message = _resourceLoader.resource("error.fileTemplateGenerationFailed.projectIsNotOpen", new Object[]{project.getName()});
                    throw new FileTemplateGenerationFailedException(message);
                }
            }
        }
    }

    public class CommonFileTemplateParametersBean
    extends TemplateBeanAdapter {
        private static final String COMMON_CONTEXT_ID = "common";
        private final String _date;
        private final String _fileName;
        private final IPath _filePath;
        private final String _time;
        private final String _user;
        private final int _year;

        public CommonFileTemplateParametersBean(IPath filePath) {
            assert (filePath != null);
            GregorianCalendar cal = new GregorianCalendar();
            Date time = cal.getTime();
            DateFormat dateFormat = DateFormat.getDateInstance();
            this._date = dateFormat.format(time);
            this._filePath = filePath;
            this._fileName = filePath.lastSegment();
            DateFormat timeFormat = DateFormat.getTimeInstance();
            this._time = timeFormat.format(time);
            this._user = System.getProperty("user.name");
            this._year = cal.get(1);
        }

        @Override
        public String getContextID() {
            return COMMON_CONTEXT_ID;
        }

        public String getDate() {
            return this._date;
        }

        public String getFileName() {
            return this._fileName;
        }

        public String getFilePath() {
            return this._filePath.toPortableString();
        }

        public String getTime() {
            return this._time;
        }

        public String getUser() {
            return this._user;
        }

        public int getYear() {
            return this._year;
        }
    }
}

