/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.template.textinserter;

import com.bea.wlw.template.ITemplateBean;
import com.bea.wlw.template.exceptions.GenerationFailedException;
import com.bea.wlw.template.textinserter.IInsertionPointFinder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import oracle.eclipse.tools.common.templating.template.core.TemplateService;
import oracle.eclipse.tools.common.templating.template.core.TemplateServicePlugin;
import oracle.eclipse.tools.common.util.ResourceLoader;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.InsertEdit;

public class TextInserter {
    private static final ResourceLoader _resourceLoader = new ResourceLoader(TextInserter.class);

    public static int insertText(IFile file, String templateId, ITemplateBean templateBean, int insertionPoint) throws CoreException, GenerationFailedException {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        IPath path = file.getFullPath();
        bufferManager.connect(path, LocationKind.NORMALIZE, null);
        IDocument doc = null;
        String generated = "";
        ITextFileBuffer buff = bufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.NORMALIZE);
        assert (buff != null) : "Couldn't get a TextFileBuffer for: " + file;
        ISchedulingRule rule = buff.computeCommitRule();
        try {
            try {
                Job.getJobManager().beginRule(rule, (IProgressMonitor)new NullProgressMonitor());
                doc = buff.getDocument();
                boolean saveWhenDone = !buff.isDirty() && !buff.isShared();
                generated = TextInserter.removeBlankLines(TemplateService.generate(templateId, templateBean));
                InsertEdit insertEdit = new InsertEdit(insertionPoint, generated);
                insertEdit.apply(doc);
                if (saveWhenDone) {
                    buff.commit(null, false);
                }
            }
            catch (BadLocationException e) {
                throw new GenerationFailedException(e);
            }
        }
        finally {
            bufferManager.disconnect(path, LocationKind.NORMALIZE, null);
            Job.getJobManager().endRule(rule);
        }
        return generated.length();
    }

    public static void insertText(IFile file, String templateId, ITemplateBean templateBean, IInsertionPointFinder insertionPointFinder) throws CoreException, GenerationFailedException {
        int insertionPoint = insertionPointFinder.findInsertionPoint(file);
        TextInserter.insertText(file, templateId, templateBean, insertionPoint);
    }

    private static String removeBlankLines(String s) throws GenerationFailedException {
        assert (s != null && s.length() > 0) : "null or zero length codegen string";
        StringBuilder result = new StringBuilder();
        BufferedReader reader = new BufferedReader(new StringReader(s));
        try {
            try {
                String currentLine;
                block9: while ((currentLine = reader.readLine()) != null) {
                    char[] chars = new char[currentLine.length()];
                    currentLine.getChars(0, currentLine.length(), chars, 0);
                    char[] cArray = chars;
                    int n = chars.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char c = cArray[n2];
                        if (!Character.isWhitespace(c)) {
                            result.append(String.valueOf(currentLine) + '\n');
                            continue block9;
                        }
                        ++n2;
                    }
                }
            }
            catch (IOException e) {
                String message = _resourceLoader.resource("exception.codegen.blankLines", new Object[0]);
                throw new GenerationFailedException(message, e);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                LoggingService.logException((Plugin)TemplateServicePlugin.getDefault(), (Throwable)e);
            }
        }
        return result.toString().trim();
    }
}

