/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.template.textinserter;

import com.bea.wlw.template.textinserter.IInsertionPointFinder;
import oracle.eclipse.tools.common.templating.template.core.TemplateServicePlugin;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IDocument;

public class GenericInsertionPointFinder
implements IInsertionPointFinder {
    private Hint _hint;
    private char _char;

    public GenericInsertionPointFinder(Hint hint) {
        assert (hint == Hint.Beginning || hint == Hint.End) : "Hint type: " + (Object)((Object)hint) + " requires a character parameter";
        this._hint = hint;
    }

    public GenericInsertionPointFinder(Hint hint, char ch) {
        this._hint = hint;
        this._char = ch;
    }

    @Override
    public int findInsertionPoint(IFile file) {
        int n;
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        bufferManager.connect(file.getFullPath(), LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer buffer = bufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.NORMALIZE);
            IDocument doc = buffer.getDocument();
            String contents = doc.get();
            int point = -1;
            switch (this._hint) {
                case Beginning: {
                    point = 0;
                    break;
                }
                case End: {
                    point = contents.length();
                    break;
                }
                case BeforeFirstOccurrence: {
                    point = contents.indexOf(this._char);
                    break;
                }
                case AfterFirstOccurrence: {
                    point = contents.indexOf(this._char) + 1;
                    break;
                }
                case BeforeLastOccurrence: {
                    point = contents.lastIndexOf(this._char);
                    break;
                }
                case AfterLastOccurrence: {
                    point = contents.lastIndexOf(this._char) + 1;
                    break;
                }
                default: {
                    assert (false) : "Unknown hint provided: " + (Object)((Object)this._hint);
                    break;
                }
            }
            if (point < 0) {
                point = contents.length() - 1;
            }
            n = point;
        }
        catch (Throwable throwable) {
            try {
                bufferManager.disconnect(file.getFullPath(), LocationKind.NORMALIZE, null);
                throw throwable;
            }
            catch (CoreException e) {
                LoggingService.logException((Plugin)TemplateServicePlugin.getDefault(), (CoreException)e);
                assert (false) : "Error finding insertion point for file: " + file;
                return -1;
            }
        }
        bufferManager.disconnect(file.getFullPath(), LocationKind.NORMALIZE, null);
        return n;
    }

    public static enum Hint {
        Beginning,
        End,
        BeforeFirstOccurrence,
        AfterFirstOccurrence,
        BeforeLastOccurrence,
        AfterLastOccurrence;

    }
}

