/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.html.core;

import java.util.Iterator;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssParser;
import org.eclipse.mylyn.internal.wikitext.core.util.css.CssRule;
import org.eclipse.mylyn.internal.wikitext.html.core.ElementMatcher;
import org.eclipse.mylyn.internal.wikitext.html.core.SpanHtmlElementStrategy;
import org.eclipse.mylyn.internal.wikitext.html.core.SpanStrategy;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.util.XmlStreamWriter;

public class FontElementStrategy
extends SpanHtmlElementStrategy {
    public FontElementStrategy() {
        super(new FontElementMatcher(), new FontSpanStrategy());
    }

    private static final class FontElementMatcher
    implements ElementMatcher<DocumentBuilder.SpanType> {
        private FontElementMatcher() {
        }

        @Override
        public boolean matches(DocumentBuilder.SpanType elementType, Attributes attributes) {
            String cssStyle;
            if (elementType == DocumentBuilder.SpanType.SPAN && (cssStyle = attributes.getCssStyle()) != null) {
                Iterator rules = new CssParser().createRuleIterator(cssStyle);
                while (rules.hasNext()) {
                    CssRule rule = (CssRule)rules.next();
                    if (!rule.name.equals("color") && !rule.name.equals("font-size")) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class FontSpanStrategy
    implements SpanStrategy {
        private FontSpanStrategy() {
        }

        @Override
        public void beginSpan(DocumentBuilder builder, DocumentBuilder.SpanType type, Attributes attributes) {
            if (builder instanceof HtmlDocumentBuilder) {
                HtmlDocumentBuilder htmlBuilder = (HtmlDocumentBuilder)builder;
                XmlStreamWriter writer = htmlBuilder.getWriter();
                writer.writeStartElement(htmlBuilder.getHtmlNsUri(), "font");
                String cssStyle = attributes.getCssStyle();
                if (cssStyle != null) {
                    Iterator rules = new CssParser().createRuleIterator(cssStyle);
                    while (rules.hasNext()) {
                        CssRule rule = (CssRule)rules.next();
                        if (rule.name.equals("color")) {
                            writer.writeAttribute("color", rule.value);
                            continue;
                        }
                        if (!rule.name.equals("font-size")) continue;
                        writer.writeAttribute("size", rule.value);
                    }
                }
            } else {
                builder.beginSpan(type, attributes);
            }
        }

        @Override
        public void endSpan(DocumentBuilder builder) {
            if (builder instanceof HtmlDocumentBuilder) {
                HtmlDocumentBuilder htmlBuilder = (HtmlDocumentBuilder)builder;
                XmlStreamWriter writer = htmlBuilder.getWriter();
                writer.writeEndElement();
            } else {
                builder.endSpan();
            }
        }
    }
}

