/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.wizard.search;

import oracle.eclipse.tools.webtier.jsf.ui.search.JSFVariableSearchQuery;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;

public class JSFSearchPage
extends DialogPage
implements ISearchPage {
    private ISearchPageContainer container;
    private Text expressionText;

    public JSFSearchPage() {
    }

    public JSFSearchPage(String title) {
        super(title);
    }

    public JSFSearchPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        result.setFont(parent.getFont());
        GridLayout layout = new GridLayout(2, false);
        result.setLayout((Layout)layout);
        this.addTextPatternControls(result);
        Label separator = new Label(result, 0);
        separator.setVisible(false);
        GridData data = new GridData(4, 4, false, false, 2, 1);
        data.heightHint = this.convertHeightInCharsToPixels(1) / 3;
        separator.setLayoutData((Object)data);
        this.addFileNameControls(result);
        this.setControl((Control)result);
    }

    private void addTextPatternControls(Composite group) {
        ISelection selection;
        Label label = new Label(group, 16384);
        label.setText("Text (* = any string, ? = any character):");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        label.setFont(group.getFont());
        this.expressionText = new Text(group, 2048);
        this.expressionText.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        if (this.container != null && (selection = this.container.getSelection()) instanceof IStructuredSelection) {
            Object firstElement;
            if (selection instanceof TextSelection) {
                this.expressionText.setText(((TextSelection)selection).getText());
            }
            if ((firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof String) {
                this.expressionText.setText((String)firstElement);
            }
        }
    }

    private void addFileNameControls(Composite group) {
    }

    public boolean performAction() {
        IResource resource = this.getResource();
        String elText = this.expressionText.getText();
        if (elText != null && !elText.trim().isEmpty() && !elText.contains(".") && resource instanceof IFile) {
            NewSearchUI.runQueryInBackground((ISearchQuery)new JSFVariableSearchQuery(resource.getProject(), elText));
        }
        return true;
    }

    private IResource getResource() {
        IEditorInput editorInput = this.container.getActiveEditorInput();
        if (editorInput != null) {
            IFile iFile = (IFile)editorInput.getAdapter(IFile.class);
            if (iFile != null) {
                return iFile;
            }
        } else {
            Object selectedElement;
            ISelection selection = this.container.getSelection();
            if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
                return (IResource)selectedElement;
            }
        }
        return null;
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
        this.container.setSelectedScope(3);
    }
}

