/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.wizard;

import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.webtier.jsf.ui.Messages;
import oracle.eclipse.tools.webtier.jsf.ui.internal.Activator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractDialogEditorCreationAdvisor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.ValidatorSelectionDialogCreationAdvisor;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.JSFAppConfigManagerFactory;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;

public class ValidatorSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "oracle.eclipse.tools.webtier.jsf.ui.wizard.ValidatorSelectionDialog";
    private final ValidatorSelectionDialogCreationAdvisor _advisor;

    public ValidatorSelectionDialog(Shell shell, ValidatorSelectionDialogCreationAdvisor advisor) {
        super(shell, advisor.getMulipleSelection());
        this.setSelectionHistory(new ValidatorSelectionHistory());
        this._advisor = advisor;
        this.setTitle(this._advisor.getTitle());
        this.setSeparatorLabel(Messages.ValidatorSelectionDialog_separatorLabel);
        this.setListLabelProvider(new ValidatorLabelProvider());
        this.setDetailsLabelProvider(new ValidatorDetailsLabelProvider());
        this.setInitialPattern("?", 2);
    }

    protected void doBindData() {
        this._advisor.bindData((IObservableValue)new AbstractObservableValue(){

            protected void doSetValue(Object value) {
                ValidatorSelectionDialog.this.setMessage((String)value);
            }

            protected Object doGetValue() {
                return ValidatorSelectionDialog.this.getMessage();
            }

            public Object getValueType() {
                return String.class;
            }
        }, new AbstractDialogEditorCreationAdvisor.IStatusUpdater(){

            public void updateStatus(IStatus status) {
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Control createdDialogArea = super.createDialogArea(parent);
        createdDialogArea = this._advisor.createEditingArea((Composite)createdDialogArea);
        return createdDialogArea;
    }

    protected void computeResult() {
        super.computeResult();
        Object[] results = this.getResult();
        ((IObservableValue)this._advisor.getSelectionModel().getStateModel()).setValue(this._advisor.getMulipleSelection() ? results : results[0]);
        this._advisor.computeResult();
    }

    public boolean close() {
        this._advisor.dispose();
        return super.close();
    }

    protected Control createExtendedContentArea(Composite parent) {
        ValidatorSelectionHistory history;
        ValidatorSelectionDialogCreationAdvisor.ValidatorInfoObservableValue selectionModel = new ValidatorSelectionDialogCreationAdvisor.ValidatorInfoObservableValue();
        this._advisor.setUiInitialized();
        this._advisor.getSelectionModel().setStateModel((IObservable)selectionModel);
        this.doBindData();
        ValidatorSelectionDialogCreationAdvisor.ValidatorInfo info = (ValidatorSelectionDialogCreationAdvisor.ValidatorInfo)selectionModel.getValue();
        if (info != null && (history = (ValidatorSelectionHistory)this.getSelectionHistory()) != null) {
            history.accessed(info);
        }
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ValidatorFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        IJSFAppConfigManager mgr = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)this._advisor.getIProject());
        if (mgr != null) {
            List validators = mgr.getValidators();
            if (progressMonitor != null) {
                progressMonitor.beginTask(Messages.ValidatorSelectionDialog_searchJob_taskName, validators.size());
            }
            for (ValidatorType validator : validators) {
                ValidatorIdType validatorId = validator.getValidatorId();
                if (validatorId == null || validatorId.getTextContent() == null || validatorId.getTextContent().trim().length() == 0) continue;
                ValidatorClassType validatorClass = validator.getValidatorClass();
                contentProvider.add((Object)new ValidatorSelectionDialogCreationAdvisor.ValidatorInfo(validatorId.getTextContent(), validatorClass.getTextContent(), this.getString(validator.getDisplayName()), this.getString(validator.getDescription())), itemsFilter);
                if (progressMonitor == null) continue;
                progressMonitor.worked(1);
            }
        }
        if (progressMonitor != null) {
            progressMonitor.done();
        }
    }

    private String getString(EList eList) {
        StringBuilder builder = new StringBuilder();
        for (Object object : eList) {
            if (!(object instanceof String)) continue;
            builder.append((String)object);
        }
        return builder.toString();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public String getElementName(Object item) {
        return ((ValidatorSelectionDialogCreationAdvisor.ValidatorInfo)item).getId();
    }

    protected Comparator<ValidatorSelectionDialogCreationAdvisor.ValidatorInfo> getItemsComparator() {
        return new Comparator<ValidatorSelectionDialogCreationAdvisor.ValidatorInfo>(){

            @Override
            public int compare(ValidatorSelectionDialogCreationAdvisor.ValidatorInfo o1, ValidatorSelectionDialogCreationAdvisor.ValidatorInfo o2) {
                Collator collator = Collator.getInstance();
                return collator.compare(o1.getId(), o2.getId());
            }
        };
    }

    protected IStatus validateItem(Object item) {
        return ValidationStatus.OK_STATUS;
    }

    private static final class ValidatorDetailsLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private ValidatorDetailsLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ValidatorSelectionDialogCreationAdvisor.ValidatorInfo) {
                ValidatorSelectionDialogCreationAdvisor.ValidatorInfo info = (ValidatorSelectionDialogCreationAdvisor.ValidatorInfo)element;
                return info.getClassName();
            }
            return null;
        }
    }

    protected class ValidatorFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public ValidatorFilter() {
            super((FilteredItemsSelectionDialog)ValidatorSelectionDialog.this);
        }

        public ValidatorFilter(SearchPattern searchPattern) {
            super((FilteredItemsSelectionDialog)ValidatorSelectionDialog.this, searchPattern);
        }

        public boolean isConsistentItem(Object item) {
            if (!(item instanceof ValidatorSelectionDialogCreationAdvisor.ValidatorInfo)) {
                return false;
            }
            ValidatorSelectionDialogCreationAdvisor.ValidatorInfo info = (ValidatorSelectionDialogCreationAdvisor.ValidatorInfo)item;
            return this.doesValidatorExist(info.getId());
        }

        private boolean doesValidatorExist(String id) {
            boolean exists = false;
            IJSFAppConfigManager mgr = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)ValidatorSelectionDialog.this._advisor.getIProject());
            if (mgr != null) {
                List validators = mgr.getValidators();
                for (ValidatorType validator : validators) {
                    ValidatorIdType validatorId = validator.getValidatorId();
                    if (validatorId == null && id == null) {
                        exists = true;
                        break;
                    }
                    if (validatorId != null && validatorId.getTextContent() == null && id == null) {
                        exists = true;
                        break;
                    }
                    if (validatorId == null || validatorId.getTextContent() == null || !validatorId.getTextContent().equals(id)) continue;
                    exists = true;
                    break;
                }
            }
            return exists;
        }

        public boolean matchItem(Object item) {
            if (!(item instanceof ValidatorSelectionDialogCreationAdvisor.ValidatorInfo)) {
                return false;
            }
            ValidatorSelectionDialogCreationAdvisor.ValidatorInfo info = (ValidatorSelectionDialogCreationAdvisor.ValidatorInfo)item;
            return this.matches(info.getId());
        }
    }

    private static final class ValidatorLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private static final String WPE_PLUGUIN_ID = "org.eclipse.jst.jsf.common.ui";
        private static final String WPE_VALIDATOR_IMAGE = "/icons/jsf_validator.gif";
        private ImageDescriptor _imageDescriptor;

        private ValidatorLabelProvider() {
        }

        public Image getImage(Object element) {
            ImageDescriptor imageDescriptor = this.getImageDescriptor();
            if (imageDescriptor == null) {
                return null;
            }
            return CommonImages.createImage((ImageDescriptor)imageDescriptor);
        }

        private ImageDescriptor getImageDescriptor() {
            if (this._imageDescriptor == null) {
                this._imageDescriptor = Activator.imageDescriptorFromPlugin((String)WPE_PLUGUIN_ID, (String)WPE_VALIDATOR_IMAGE);
            }
            return this._imageDescriptor;
        }

        public String getText(Object element) {
            if (element instanceof ValidatorSelectionDialogCreationAdvisor.ValidatorInfo) {
                ValidatorSelectionDialogCreationAdvisor.ValidatorInfo info = (ValidatorSelectionDialogCreationAdvisor.ValidatorInfo)element;
                return info.getId();
            }
            return null;
        }
    }

    private static final class ValidatorSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private ValidatorSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
        }
    }
}

