/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.wizard;

import oracle.eclipse.tools.application.common.services.appservices.IAppClassLoaderProvider;
import oracle.eclipse.tools.application.common.services.variables.JDTDataType;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.ui.internal.Messages;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class IteratorDataTypeValidator
implements IValidator {
    private IObservableValue _initializationObservable;
    private IDocument _doc;

    public IteratorDataTypeValidator(IDocument doc, IObservableValue initializationObservable) {
        this._doc = doc;
        this._initializationObservable = initializationObservable;
    }

    public IStatus validate(Object value) {
        if (!this.isIniting()) {
            String dt = (String)value;
            if (dt == null || dt.trim().equals("")) {
                return ValidationStatus.error((String)Messages.ArtificialVariableWizard_noEmptyType);
            }
            try (IAppClassLoaderProvider.IClassLoader loader = null;){
                try {
                    if (!JDTDataType.isPrimitive((String)dt)) {
                        loader = ((IAppClassLoaderProvider)this._doc.getProject().getAppService(IAppClassLoaderProvider.class)).getAppClassLoader();
                        loader.loadClass(dt);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    IStatus iStatus = ValidationStatus.error((String)Messages.IteratorDataTypeValidator_unrecognizedJavaType);
                    if (loader != null) {
                        loader.close();
                    }
                    return iStatus;
                }
            }
        }
        return ValidationStatus.OK_STATUS;
    }

    private boolean isIniting() {
        return (Boolean)this._initializationObservable.getValue();
    }
}

