/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.validator;

import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.jsf.ui.Messages;
import oracle.eclipse.tools.webtier.jsf.ui.internal.Activator;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;
import org.eclipse.jst.jsf.validation.internal.appconfig.AppConfigValidationUtil;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class ViewDataValidator
implements IValidator {
    private static final IStatus OK_STATUS = new Status(0, "oracle.eclipse.tools.webtier.jsf.ui", "");
    private static final IStatus VALIDATOR_ID_EMPTY_STATUS = new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", Messages.NewValidatorDialog_ValidatorIdCannotBeBlank);
    private static final IStatus DUPLICATE_VALIDATOR_ID_STATUS = new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", Messages.NewValidatorDialog_ValidatorIdExists);
    private static final IStatus VALIDATOR_CLASS_NAME_EMPTY_STATUS = new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", Messages.NewValidatorDialog_ValidatorClassCannotBeBlank);
    private static final IStatus VALIDATOR_CLASS_NAME_NOT_VALIDATOR_STATUS = new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", Messages.NewValidatorDialog_ValidatorClassMustImplementValidator);
    private final List<String> existingValidatorIds;
    private final IProject project;

    public ViewDataValidator(IProject project, List<String> list) {
        this.project = project;
        this.existingValidatorIds = list;
    }

    public IStatus validate(Object value) {
        ValidatorType validator = (ValidatorType)value;
        IStatus error = this.isValidValidatorId(validator);
        if (!error.isOK()) {
            return error;
        }
        error = this.isValidValidatorClass(validator);
        if (!error.isOK()) {
            return error;
        }
        return OK_STATUS;
    }

    private IStatus isValidValidatorId(ValidatorType validator) {
        String validatorId = validator.getValidatorId().getTextContent();
        String string = validatorId = validatorId == null ? "" : validatorId.trim();
        if (validatorId.length() == 0) {
            return VALIDATOR_ID_EMPTY_STATUS;
        }
        if (this.existingValidatorIds.contains(validatorId)) {
            return DUPLICATE_VALIDATOR_ID_STATUS;
        }
        return OK_STATUS;
    }

    private IStatus isValidValidatorClass(ValidatorType validator) {
        String validatorClassName = validator.getValidatorClass().getTextContent();
        String string = validatorClassName = validatorClassName == null ? "" : validatorClassName.trim();
        if (validatorClassName.length() == 0) {
            return VALIDATOR_CLASS_NAME_EMPTY_STATUS;
        }
        IMessage classNameValidationErrorMessage = AppConfigValidationUtil.validateClassName((String)validatorClassName, null, (boolean)true, (IProject)this.project);
        if (classNameValidationErrorMessage != null) {
            return new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", classNameValidationErrorMessage.getText());
        }
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        IType type = null;
        try {
            type = javaProject.findType(validatorClassName);
            if (type != null && !AppConfigValidationUtil.isInstanceOf((IType)type, (String)"javax.faces.validator.Validator")) {
                return VALIDATOR_CLASS_NAME_NOT_VALIDATOR_STATUS;
            }
        }
        catch (JavaModelException jme) {
            LoggingService.logError((Plugin)Activator.getDefault(), (String)jme.getLocalizedMessage());
        }
        return OK_STATUS;
    }
}

