/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.validator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.webtier.jsf.ui.Messages;
import oracle.eclipse.tools.webtier.jsf.ui.util.JsfUiUtil;
import oracle.eclipse.tools.webtier.jsf.ui.validator.ComputedUIValue;
import oracle.eclipse.tools.webtier.jsf.ui.validator.JsfValidatorDialogCreationAdvisor;
import oracle.eclipse.tools.webtier.jsf.ui.validator.ViewDataValidator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.CustomEditDialog;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractBindingMediator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractDialogEditorCreationAdvisor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractValueBindingMediator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.DefaultDeferredValueBindingMediator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.DefaultValueBindingMediator;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.JSFAppConfigManagerFactory;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NewValidatorAction
extends Action {
    private IProject project;
    private static final String HELPID = "oracle.eclipse.tools.webtier.jsf.ui.NewValidatorDialog";

    public void run() {
        String facesConfigFilename;
        if (this.project == null) {
            throw new IllegalArgumentException("Was expecting a valid non-null project");
        }
        try {
            facesConfigFilename = JsfUiUtil.getFacesConfigFile(this.project, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        if (facesConfigFilename != null) {
            final Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            DataBindingContext context = new DataBindingContext();
            WritableValue userModel = new WritableValue((Object)ComputedUIValue.createValidator(), ValidatorType.class);
            CustomEditDialog dialog = new CustomEditDialog(new IShellProvider(){

                public Shell getShell() {
                    return shell;
                }
            }, (AbstractDialogEditorCreationAdvisor)new JsfValidatorDialogCreationAdvisor(shell, this.project, context, Messages.NewValidatorDialog_NewValidatorDialogTitle, new AbstractDialogEditorCreationAdvisor.MessageSourceObservableValue(""), (AbstractBindingMediator<IObservableValue, UpdateValueStrategy>)new UserDataMediator((IObservableValue)userModel), (AbstractBindingMediator<IObservableValue, UpdateValueStrategy>)new IntermediateDataMediator((IObservableValue)userModel), (AbstractBindingMediator<IObservableValue, UpdateValueStrategy>)new SelectionDataMediator(this.project, this.getExistingValidatorIds(this.project))));
            dialog.setStatusLineAboveButtons(true);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, HELPID);
            switch (dialog.open()) {
                case 0: {
                    Object newValidator = userModel.getValue();
                    if (!(newValidator instanceof ValidatorType)) break;
                    this.updateFacesConfigFile(facesConfigFilename, (ValidatorType)newValidator);
                }
            }
        }
    }

    public void selectionChanged(ISelection selection) {
        Object firstSegment;
        TreeSelection treeSelection;
        TreePath[] treePaths;
        if (selection instanceof TreeSelection && (treePaths = (treeSelection = (TreeSelection)selection).getPaths()) != null && treePaths.length > 0 && (firstSegment = treePaths[0].getFirstSegment()) instanceof IProject) {
            this.project = (IProject)firstSegment;
        }
    }

    private void updateFacesConfigFile(String facesConfigFilename, ValidatorType validator) {
        FacesConfigArtifactEdit facesConfigEdit = null;
        try {
            facesConfigEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)this.project, (String)facesConfigFilename);
            DescriptionType description = (DescriptionType)validator.getDescription().get(0);
            String descriptionString = description.getTextContent();
            if (descriptionString == null || descriptionString.trim().length() == 0) {
                validator.getDescription().clear();
            }
            facesConfigEdit.getFacesConfig().getValidator().add((Object)validator);
            JsfUiUtil.save(facesConfigEdit);
        }
        finally {
            if (facesConfigEdit != null) {
                facesConfigEdit.dispose();
                facesConfigEdit = null;
            }
        }
    }

    private List<String> getExistingValidatorIds(IProject proj) {
        IJSFAppConfigManager appConfigManager;
        ArrayList<String> existingValidatorIds = new ArrayList<String>();
        if (proj != null && (appConfigManager = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)proj)) != null) {
            List validatorObjs = appConfigManager.getValidators();
            for (Object validatorObj : validatorObjs) {
                String validatorId;
                ValidatorIdType validatorIdType;
                if (!(validatorObj instanceof ValidatorType) || (validatorIdType = ((ValidatorType)validatorObj).getValidatorId()) == null || (validatorId = validatorIdType.getTextContent()) == null) continue;
                existingValidatorIds.add(validatorId.trim());
            }
        }
        return existingValidatorIds;
    }

    private static final class IntermediateDataMediator
    extends DefaultValueBindingMediator<IObservableValue, UpdateValueStrategy> {
        public IntermediateDataMediator(IObservableValue observable) {
            super(observable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        }
    }

    public static class SelectionDataMediator
    extends DefaultDeferredValueBindingMediator<IObservableValue, UpdateValueStrategy> {
        private final IProject _project;
        private final List<String> _list;

        public SelectionDataMediator(IProject project, List<String> list) {
            super(new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
            this._project = project;
            this._list = list;
        }

        protected List<AbstractValueBindingMediator.ValidatorDescriptor> getTargetUpdateValidators() {
            AbstractValueBindingMediator.ValidatorDescriptor desc = new AbstractValueBindingMediator.ValidatorDescriptor((IValidator)new ViewDataValidator(this._project, this._list), AbstractValueBindingMediator.ValidatorDescriptor.EValidatorRuntime.AfterGetValidator);
            return Collections.singletonList(desc);
        }
    }

    private static final class UserDataMediator
    extends DefaultValueBindingMediator<IObservableValue, UpdateValueStrategy> {
        public UserDataMediator(IObservableValue userModel) {
            super(userModel, new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        }
    }
}

