/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.validator;

import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.jsf.ui.Messages;
import oracle.eclipse.tools.webtier.jsf.ui.internal.Activator;
import oracle.eclipse.tools.webtier.jsf.ui.validator.ComputedUIValue;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractBindingMediator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractDialogEditorCreationAdvisor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractDialogEditorValueCreationAdvisor;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class JsfValidatorDialogCreationAdvisor
extends AbstractDialogEditorValueCreationAdvisor<IObservableValue, UpdateValueStrategy> {
    private final Shell shell;
    private Text validatorIdText;
    private Text validatorClassText;
    private Text descriptionText;
    private final IProject project;

    public JsfValidatorDialogCreationAdvisor(Shell shell, IProject project, DataBindingContext context, String title, AbstractDialogEditorCreationAdvisor.MessageSourceObservableValue messageObservableValue, AbstractBindingMediator<IObservableValue, UpdateValueStrategy> userModel, AbstractBindingMediator<IObservableValue, UpdateValueStrategy> intermediateModel, AbstractBindingMediator<IObservableValue, UpdateValueStrategy> selectionModel) {
        super(context, title, messageObservableValue, userModel, intermediateModel, selectionModel);
        this.shell = shell;
        this.project = project;
    }

    protected Control doCreateEditingArea(Composite parent) {
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout;
            gridLayout.marginWidth = 14;
            gridLayout.marginHeight = 0;
            gridLayout.marginTop = 2;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
        }
        Composite localParent = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 8;
        gridLayout.verticalSpacing = 8;
        localParent.setLayout((Layout)gridLayout);
        localParent.setLayoutData((Object)new GridData(4, 4, true, true));
        Label validatorIdLabel = new Label(localParent, 0);
        validatorIdLabel.setText(Messages.NewValidatorDialog_ValidatorIdLabel);
        this.validatorIdText = new Text(localParent, 2052);
        GridData validatorIdTextGridData = new GridData(4, 0x1000000, true, false);
        validatorIdTextGridData.minimumWidth = 265;
        this.validatorIdText.setLayoutData((Object)validatorIdTextGridData);
        this.getEmptyComposite(localParent);
        Label validatorClassLabel = new Label(localParent, 0);
        validatorClassLabel.setText(Messages.NewValidatorDialog_ValidatorClassLabel);
        this.validatorClassText = new Text(localParent, 2052);
        GridData validatorClassTextGridData = new GridData(4, 0x1000000, true, false);
        validatorClassTextGridData.minimumWidth = 265;
        this.validatorClassText.setLayoutData((Object)validatorClassTextGridData);
        ToolBar validatorClassBrowserButtonToolBar = this.getToolBar(localParent, 256);
        ToolItem selectClassButton1 = new ToolItem(validatorClassBrowserButtonToolBar, 8);
        selectClassButton1.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
        selectClassButton1.setToolTipText(Messages.NewValidatorDialog_ClassBrowserTooltipText);
        selectClassButton1.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent se) {
                this.widgetSelected(se);
            }

            public void widgetSelected(SelectionEvent se) {
                JsfValidatorDialogCreationAdvisor.this.validatorClassBrowserButtonClicked();
            }
        });
        Label descriptionLabel = new Label(localParent, 0);
        descriptionLabel.setText(Messages.JSFConfigAddNavigationCaseDialog_descLabel);
        GridData descriptionLabelGridData = new GridData(4, 1, false, false);
        descriptionLabel.setLayoutData((Object)descriptionLabelGridData);
        this.descriptionText = new Text(localParent, 2626);
        GridData descTextGridData = new GridData(4, 1, true, false);
        descTextGridData.heightHint = 40;
        descTextGridData.minimumWidth = 265;
        this.descriptionText.setLayoutData((Object)descTextGridData);
        IObservableValue multiFeatureObservable = this.createMultiFeatureObservable();
        this.setInitState(AbstractDialogEditorCreationAdvisor.InitState.UI_INITIALIZED);
        this.getSelectionModel().setStateModel((IObservable)multiFeatureObservable);
        return localParent;
    }

    private IObservableValue createMultiFeatureObservable() {
        ISWTObservableValue validatorId = SWTObservables.observeText((Control)this.validatorIdText, (int)24);
        ISWTObservableValue validatorClass = SWTObservables.observeText((Control)this.validatorClassText, (int)24);
        ISWTObservableValue description = SWTObservables.observeText((Control)this.descriptionText);
        return new ComputedUIValue((IObservableValue)validatorClass, (IObservableValue)validatorId, (IObservableValue)description);
    }

    private ToolBar getToolBar(Composite parent, int style) {
        ToolBar toolBar = new ToolBar(parent, 0x800000 | style);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        toolBar.setLayout((Layout)gridLayout);
        int alignStyle = 0x1000000;
        if ((style | 0x200) == 512) {
            alignStyle = 1;
        }
        GridData gridData = new GridData(alignStyle, alignStyle, false, false);
        toolBar.setLayoutData((Object)gridData);
        return toolBar;
    }

    private Composite getEmptyComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1, 1, false, false);
        gridData.widthHint = 0;
        gridData.heightHint = 0;
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    private void validatorClassBrowserButtonClicked() {
        try {
            SelectionDialog classBrowserDialog = JavaUI.createTypeDialog((Shell)this.shell, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IProject)this.project, (int)2, (boolean)false);
            classBrowserDialog.setTitle(Messages.NewValidatorDialog_SelectValidatorClassDialogTitle);
            classBrowserDialog.setMessage(Messages.NewValidatorDialog_SelectValidatorClassDialogMessage);
            switch (classBrowserDialog.open()) {
                case 0: {
                    Object selectedClass = classBrowserDialog.getResult()[0];
                    if (selectedClass == null) {
                        return;
                    }
                    String fullyQualifiedClassName = ((IType)selectedClass).getFullyQualifiedName('.');
                    this.validatorClassText.setText(fullyQualifiedClassName);
                }
            }
        }
        catch (JavaModelException e) {
            LoggingService.logError((Plugin)Activator.getDefault(), (String)e.getLocalizedMessage());
        }
    }
}

