/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.search;

import java.util.regex.Pattern;
import oracle.eclipse.tools.application.common.services.variables.IProjectVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.IVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;

public class JSFVariableSearchQuery
implements ISearchQuery {
    private final IProject project;
    private final String searchString;
    private final SearchResult result;
    private Pattern searchStringMatch;

    public JSFVariableSearchQuery(IProject project, String searchString) {
        this.project = project;
        this.searchString = searchString;
        this.searchStringMatch = this.createSearchStringPattern(this.searchString);
        this.result = new SearchResult(this);
    }

    private Pattern createSearchStringPattern(String searchString2) {
        return TextSearchEngine.createPattern((String)searchString2, (boolean)true, (boolean)false);
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.result.removeAll();
        if (this.searchStringMatch == null) {
            return Status.OK_STATUS;
        }
        IProjectVariablesCache projectCache = VariablesController.getInstance().getProjectCache(this.project);
        for (Variable var : projectCache.getVariables()) {
            this.checkVariableAndMaybeAddToResult(var);
        }
        for (IVariablesCache cache : VariablesController.getInstance().getVariableCaches(this.project)) {
            for (Variable var : cache.getVariables()) {
                this.checkVariableAndMaybeAddToResult(var);
            }
        }
        return Status.OK_STATUS;
    }

    private void checkVariableAndMaybeAddToResult(Variable var) {
        ResourceLocation definitionLocation;
        if (this.searchStringMatch.matcher(var.getName()).matches() && (definitionLocation = var.getDefinitionLocation()) != null) {
            IFile file = (IFile)definitionLocation.getResource();
            int offset = (int)definitionLocation.getRange().getOffset();
            int length = (int)definitionLocation.getRange().getLength();
            this.result.addMatch(new Match((Object)file, offset, length));
        }
    }

    public String getLabel() {
        return "JSF Variable Search";
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.result;
    }

    public static enum SEARCH_TYPE {
        VAR_DECLARATION,
        VAR_REFERENCE;

    }

    public static class SearchResult
    extends AbstractTextSearchResult {
        private final ISearchQuery query;

        public SearchResult(ISearchQuery query) {
            this.query = query;
        }

        public String getLabel() {
            return "JSF Variable Search Result";
        }

        public ISearchQuery getQuery() {
            return this.query;
        }

        public String getTooltip() {
            return null;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public IEditorMatchAdapter getEditorMatchAdapter() {
            return new IEditorMatchAdapter(){

                public boolean isShownInEditor(Match match, IEditorPart editor) {
                    return false;
                }

                public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
                    return new Match[0];
                }
            };
        }

        public IFileMatchAdapter getFileMatchAdapter() {
            return new IFileMatchAdapter(){

                public IFile getFile(Object element) {
                    return null;
                }

                public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
                    return new Match[0];
                }
            };
        }
    }
}

