/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.refactoring;

import java.io.IOException;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.StructuredModelFactory;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.FacesConfigArtifact;
import oracle.eclipse.tools.webtier.jsf.ui.internal.Activator;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.Messages;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.NLSSubstitution;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.NLSSubstitutionGroup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class NLSSourceModifier {
    private static final String BUNDLE = "${bundle}";
    private static final String KEY = "${key}";
    private static final String WEB_XML_FILE = "WEB-INF/web.xml";
    private String fSubstitutionPattern;

    private NLSSourceModifier(String substitutionPattern) {
        this.fSubstitutionPattern = substitutionPattern;
    }

    public static void create(MultiTextEdit multiTextEdit, IFile jsfFile, NLSSubstitutionGroup group, String substitutionPattern) {
        NLSSubstitution[] substitutions;
        NLSSourceModifier modifier = new NLSSourceModifier(substitutionPattern);
        NLSSubstitution[] nLSSubstitutionArray = substitutions = group.getSubstitutions();
        int n = substitutions.length;
        int n2 = 0;
        while (n2 < n) {
            NLSSubstitution substitution = nLSSubstitutionArray[n2];
            if (substitution.getState() != 1) {
                int offset = substitution.getNLSElement().getPosition().getOffset();
                int length = substitution.getNLSElement().getPosition().getLength();
                ReplaceEdit edit = new ReplaceEdit(offset, length, modifier.createSubstitutionString(group.getBundleVariable(), substitution.getKey()));
                multiTextEdit.addChild((TextEdit)edit);
            }
            ++n2;
        }
    }

    private String substituteKey(String source, String key, String value) {
        StringBuffer buf = new StringBuffer();
        int i = source.indexOf(key);
        if (i != -1) {
            buf.append(source.substring(0, i));
            buf.append(value);
            buf.append(source.substring(i + key.length()));
        }
        return buf.toString();
    }

    private String createSubstitutionString(String bundle, String key) {
        Assert.isTrue((this.fSubstitutionPattern.indexOf(BUNDLE) >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.fSubstitutionPattern.indexOf(KEY) >= 0 ? 1 : 0) != 0);
        String result = this.substituteKey(this.fSubstitutionPattern, BUNDLE, bundle);
        return this.substituteKey(result, KEY, key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createConfigurationChange(CompositeChange result, IProject project, NLSSubstitutionGroup fSelectedGroup, String baseName, String var) {
        IFile facesConfFile = NLSSourceModifier.getFacesConfigFile(project);
        if (facesConfFile == null || !facesConfFile.exists()) return;
        IVisitableDOMModel domModel = null;
        try {
            domModel = StructuredModelFactory.getVisitableModelForRead((IFile)facesConfFile);
            if (domModel != null) {
                FacesConfigVisitor visitor = new FacesConfigVisitor();
                domModel.accept((IStructuredXMLModelVisitor)visitor);
                TextFileChange textEdit = new TextFileChange(Messages.NLSSourceModifier_defaultBundleAdd, facesConfFile);
                MultiTextEdit multiTextEdit = new MultiTextEdit();
                textEdit.setEdit((TextEdit)multiTextEdit);
                multiTextEdit.addChild((TextEdit)new InsertEdit(visitor.getOffset(), visitor.getText(baseName, var)));
                result.add((Change)textEdit);
            }
        }
        catch (CoreException ce) {
            Activator.log((Exception)((Object)ce));
            if (domModel == null) return;
            try {
                domModel.dispose();
                return;
            }
            catch (IllegalStateException illegalStateException) {}
            return;
        }
        catch (IOException ioe) {
            try {
                Activator.log(ioe);
                if (domModel == null) return;
            }
            catch (Throwable throwable) {
                if (domModel == null) throw throwable;
                try {
                    domModel.dispose();
                    throw throwable;
                }
                catch (IllegalStateException illegalStateException) {}
                throw throwable;
            }
            try {
                domModel.dispose();
                return;
            }
            catch (IllegalStateException illegalStateException) {}
            return;
        }
        if (domModel == null) return;
        try {
            domModel.dispose();
            return;
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public static IFile getFacesConfigFile(IProject project) {
        IFile facesConfigFile;
        Set files;
        FacesConfigArtifact facesConfigArtifact;
        IFile webXml;
        ResourceArtifact webXmlArtifact;
        IVirtualFile v;
        IVirtualFolder rootFolder;
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        IDependencyModel model = DependencyModelManager.getInstance().getModel();
        if (vc != null && (rootFolder = vc.getRootFolder()) != null && (v = rootFolder.getFile(WEB_XML_FILE)) != null && (webXmlArtifact = model.ensureResourceArtifact((IResource)(webXml = v.getUnderlyingFile()))) != null && (facesConfigArtifact = FacesConfigArtifact.FACTORY.getInstance((ResourceArtifact)webXmlArtifact)) != null && (files = facesConfigArtifact.getFacesConfigFiles()).size() > 0 && (facesConfigFile = (IFile)files.iterator().next()) != null && facesConfigFile.exists()) {
            return facesConfigFile;
        }
        return null;
    }

    static class FacesConfigVisitor
    implements IStructuredXMLModelVisitor {
        private static final String RESOURCE_BUNDLE_START = "<resource-bundle>\n";
        private static final String BASE_NAME_START = "\t<base-name>";
        private static final String BASE_NAME_END = "</base-name>\n";
        private static final String VAR_NAME_START = "\t<var>";
        private static final String VAR_NAME_END = "</var>\n";
        private static final String RESOURCE_BUNDLE_END = "</resource-bundle>\n";
        private static final String APPLICATION_START = "<application>\n";
        private static final String APPLICATION_END = "</application>\n";
        private int offset = 0;
        private boolean appLevelInsert = false;

        FacesConfigVisitor() {
        }

        public boolean visit(IDOMNode node) {
            return true;
        }

        public String getText(String baseName, String varName) {
            StringBuffer buffer = new StringBuffer();
            buffer.append('\n');
            if (!this.appLevelInsert) {
                this.indent(this.appLevelInsert, buffer);
                buffer.append(APPLICATION_START);
            }
            this.indent(this.appLevelInsert, buffer);
            buffer.append(RESOURCE_BUNDLE_START);
            this.indent(this.appLevelInsert, buffer);
            buffer.append(BASE_NAME_START);
            buffer.append(baseName);
            buffer.append(BASE_NAME_END);
            this.indent(this.appLevelInsert, buffer);
            buffer.append(VAR_NAME_START);
            buffer.append(varName);
            buffer.append(VAR_NAME_END);
            this.indent(this.appLevelInsert, buffer);
            buffer.append(RESOURCE_BUNDLE_END);
            this.indent(this.appLevelInsert, buffer);
            if (!this.appLevelInsert) {
                buffer.append(APPLICATION_END);
            }
            return buffer.toString();
        }

        private void indent(boolean app, StringBuffer buffer) {
            if (app) {
                this.indent(2, buffer);
            } else {
                this.indent(1, buffer);
            }
        }

        private void indent(int i, StringBuffer buffer) {
            int j = 0;
            while (j < i) {
                buffer.append('\t');
                ++j;
            }
        }

        public int getOffset() {
            return this.offset;
        }

        public boolean visit(IDOMElement element) {
            String name = element.getLocalName();
            if (name.equals("faces-config")) {
                this.offset = element.getStartEndOffset();
                return true;
            }
            if (name.equals("application")) {
                this.offset = element.getStartEndOffset();
                this.appLevelInsert = true;
                return false;
            }
            return true;
        }

        public boolean visit(IDOMDocument document) {
            return true;
        }

        public boolean visit(IDOMAttr attribute) {
            return false;
        }
    }
}

