/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.refactoring;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import oracle.eclipse.tools.application.common.services.appservices.IAppLocalizer;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.Messages;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.NLSHint;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.NLSPropertyFileModifier;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.NLSSourceModifier;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.NLSSubstitution;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.NLSSubstitutionGroup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class NLSRefactoring
extends Refactoring {
    private static final String DEFAULT_SUBST_PATTERN = "#{${bundle}['${key}']}";
    public static final String PROPERTY_FILE_EXT = ".properties";
    public static final String DEFAULT_PROPERTY_FILENAME = "messages";
    private IFile jsfFile;
    private List<NLSSubstitutionGroup> fSubstitutionGroups;
    private String fSubstitutionPattern;
    private String fPrefix;
    private NLSSubstitutionGroup fSelectedGroup;
    private boolean noMessageVar = false;

    public NLSRefactoring(IFile file) {
        this.jsfFile = file;
        NLSHint nlsHint = new NLSHint(file);
        this.fSubstitutionGroups = nlsHint.getSubstitutionGroups();
        this.setSubstitutionPattern(DEFAULT_SUBST_PATTERN);
        this.setPrefix(this.createSimplePrefix());
        if (this.fSubstitutionGroups.size() > 0) {
            this.setSelectedGroup(this.fSubstitutionGroups.get(0));
        }
    }

    private String createSimplePrefix() {
        String fn = this.jsfFile.getName();
        String ext = this.jsfFile.getFileExtension();
        String name = String.valueOf(fn.substring(0, fn.length() - ext.length() - 1)) + "_";
        return name;
    }

    public String getName() {
        return MessageFormat.format(Messages.NLSRefactoring_name, this.jsfFile.getName());
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.fSubstitutionGroups.size() == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format(Messages.NLSRefactoring_noStringsToExternalize, this.jsfFile.getName()));
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.checkParameters();
        try {
            pm.beginTask(Messages.NLSRefactoring_checking, 5);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkIfAnythingToDo());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            result.merge(this.validateModifiesFiles());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (this.fSelectedGroup.isLoneGroup() || this.fSelectedGroup.getBundleVariable() == null || this.noMessageVar) {
                result.merge(this.validateFacesConfigFiles());
            }
            pm.worked(1);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            result.merge(this.checkKeys());
            pm.worked(1);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private void checkParameters() {
        Assert.isNotNull(this.fSubstitutionGroups);
        Assert.isNotNull((Object)this.fSelectedGroup);
    }

    private RefactoringStatus validateFacesConfigFiles() {
        IFile facesConfigFile = NLSSourceModifier.getFacesConfigFile(this.jsfFile.getProject());
        RefactoringStatus status = new RefactoringStatus();
        if (facesConfigFile == null || !facesConfigFile.exists()) {
            status.addWarning(Messages.NLSRefactoring_cannotFindFacesConfigWarning);
        }
        return status;
    }

    private RefactoringStatus validateModifiesFiles() {
        return Checks.validateModifiesFiles((IFile[])this.getAllFilesToModify(), (Object)this.getValidationContext());
    }

    private RefactoringStatus checkKeys() {
        RefactoringStatus result = new RefactoringStatus();
        for (NLSSubstitutionGroup group : this.fSubstitutionGroups) {
            NLSSubstitution[] subs = group.getSubstitutions();
            int i = 0;
            while (i < subs.length) {
                NLSSubstitution substitution = subs[i];
                if (substitution.getState() == 0 && substitution.hasStateChanged()) {
                    result.merge(NLSRefactoring.checkKey(substitution.getKey()));
                }
                ++i;
            }
        }
        return result;
    }

    private static RefactoringStatus checkKey(String key) {
        RefactoringStatus result = new RefactoringStatus();
        if (key == null) {
            result.addFatalError("");
        }
        if (key.startsWith("!") || key.startsWith("#")) {
            result.addWarning(Messages.NLSRefactoring_bad_key);
        }
        if ("".equals(key.trim())) {
            result.addFatalError(Messages.NLSRefactoring_blank_key);
        }
        String[] UNWANTED_STRINGS = new String[]{" ", ":", "\"", "\\", "'", "?", "="};
        int i = 0;
        while (i < UNWANTED_STRINGS.length) {
            if (key.indexOf(UNWANTED_STRINGS[i]) != -1) {
                Object[] args = new String[]{key, UNWANTED_STRINGS[i]};
                String msg = MessageFormat.format("", args);
                result.addError(msg);
            }
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkIfAnythingToDo() {
        if (NLSSubstitution.countItems(this.fSelectedGroup.getSubstitutions(), 0) != 0) {
            return null;
        }
        if (this.willModifyPropertyFile(this.fSelectedGroup)) {
            return null;
        }
        if (this.willModifySource(this.fSelectedGroup)) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        result.addFatalError(Messages.NLSRefactoring_nothing_to_do);
        return result;
    }

    private boolean willModifySource(NLSSubstitutionGroup group) {
        NLSSubstitution[] subs = group.getSubstitutions();
        boolean allIgnored = true;
        int i = 0;
        while (i < subs.length) {
            if (subs[i].getState() != 1) {
                allIgnored = false;
            }
            ++i;
        }
        if (allIgnored) {
            return false;
        }
        i = 0;
        while (i < subs.length) {
            if (subs[i].hasSourceChange()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean willModifyPropertyFile(NLSSubstitutionGroup group) {
        NLSSubstitution[] subs = group.getSubstitutions();
        int i = 0;
        while (i < subs.length) {
            NLSSubstitution substitution = subs[i];
            if (substitution.hasPropertyFileChange()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IFile[] getAllFilesToModify() {
        ArrayList<IFile> files = new ArrayList<IFile>(2);
        for (NLSSubstitutionGroup group : this.fSubstitutionGroups) {
            IFile file;
            if (this.willModifySource(group) && this.jsfFile.exists()) {
                files.add(this.jsfFile);
            }
            if (!this.willModifyPropertyFile(group) || !(file = group.getBundleResource()).exists()) continue;
            files.add(file);
        }
        return files.toArray(new IFile[files.size()]);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            this.checkParameters();
            pm.beginTask("", 3);
            CompositeChange result = new CompositeChange("");
            TextFileChange textEdit = new TextFileChange(MessageFormat.format(Messages.ExternalizeWizardPage_title, this.jsfFile.getName()), this.jsfFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            result.add((Change)textEdit);
            textEdit.setEdit((TextEdit)multiTextEdit);
            if (this.fSelectedGroup.isLoneGroup() || this.fSelectedGroup.getBundleVariable() == null || this.noMessageVar) {
                this.noMessageVar = true;
                NLSSourceModifier.createConfigurationChange(result, this.jsfFile.getProject(), this.fSelectedGroup, this.fSelectedGroup.getBaseName(), "msg");
                this.fSelectedGroup.setBundleVariable("msg");
            }
            pm.worked(1);
            if (this.willModifySource(this.fSelectedGroup)) {
                NLSSourceModifier.create(multiTextEdit, this.jsfFile, this.fSelectedGroup, this.getSubstitutionPattern());
            }
            pm.worked(1);
            if (this.willModifyPropertyFile(this.fSelectedGroup)) {
                String selectionBaseName = this.fSelectedGroup.getBaseName();
                String mainResourceName = this.fSelectedGroup.getBundleResource().getName();
                String suffix = this.getSuffix(mainResourceName);
                Locale mainLocale = this.getLanguageFromSuffix(suffix);
                ArrayList<IPath> compatibleLocaleProperties = new ArrayList<IPath>();
                ArrayList<IPath> otherLocaleProperties = new ArrayList<IPath>();
                this.getNonCompatibleLocaleProperties(mainLocale, selectionBaseName, compatibleLocaleProperties, otherLocaleProperties);
                for (IPath path : compatibleLocaleProperties) {
                    result.add(NLSPropertyFileModifier.create(this.fSelectedGroup.getSubstitutions(), path, false));
                }
                for (IPath path : otherLocaleProperties) {
                    result.add(NLSPropertyFileModifier.create(this.fSelectedGroup.getSubstitutions(), path, true));
                }
            }
            pm.worked(1);
            CompositeChange compositeChange = result;
            return compositeChange;
        }
        finally {
            pm.done();
        }
    }

    private Locale getLanguageFromSuffix(String suffix) {
        if (suffix == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(suffix, "_");
        if (tokenizer.hasMoreTokens()) {
            String language = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                String country = tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) {
                    String variant = tokenizer.nextToken();
                    return new Locale(language, country, variant);
                }
                return new Locale(language, country);
            }
            return new Locale(language);
        }
        return null;
    }

    private List<IPath> getNonCompatibleLocaleProperties(Locale mainLocale, String baseName, List<IPath> compatibleLocaleProperties, List<IPath> otherLocaleProperties) {
        IDocument document = (IDocument)this.jsfFile.getAdapter(IDocument.class);
        Project project = document.getProject();
        IAppLocalizer appService = (IAppLocalizer)project.getAppService(IAppLocalizer.class);
        Collection locales = appService.getAvailableLocales(baseName);
        for (Locale locale : locales) {
            String name;
            String language = locale.getLanguage();
            IBundleResource bundle = appService.resolveBundle(baseName, locale);
            IFile file = bundle.getUnderlyingResource();
            if (file == null || !(name = file.getName()).endsWith(PROPERTY_FILE_EXT)) continue;
            String bn = name.substring(0, name.indexOf(PROPERTY_FILE_EXT));
            if (baseName.endsWith(bn)) {
                compatibleLocaleProperties.add(file.getFullPath());
                continue;
            }
            if (language == null || language.equals("")) continue;
            if (mainLocale != null && language.equals(mainLocale.getLanguage())) {
                compatibleLocaleProperties.add(file.getFullPath());
                continue;
            }
            otherLocaleProperties.add(file.getFullPath());
        }
        return Collections.EMPTY_LIST;
    }

    private String getSuffix(String baseName) {
        int index;
        if (baseName.endsWith(PROPERTY_FILE_EXT)) {
            int ext = baseName.indexOf(PROPERTY_FILE_EXT);
            baseName = baseName.substring(0, ext);
        }
        if ((index = baseName.indexOf(95)) < 0) {
            return null;
        }
        return baseName.substring(index + 1);
    }

    public String getSubstitutionPattern() {
        return this.fSubstitutionPattern;
    }

    public void setSubstitutionPattern(String pattern) {
        Assert.isNotNull((Object)pattern);
        this.fSubstitutionPattern = pattern;
    }

    public void setSelectedGroup(NLSSubstitutionGroup group) {
        this.fSelectedGroup = group;
    }

    public static NLSRefactoring create(IFile file) {
        return new NLSRefactoring(file);
    }

    public NLSSubstitutionGroup[] getSubstitutionGroups() {
        return this.fSubstitutionGroups.toArray(new NLSSubstitutionGroup[0]);
    }

    public String getPrefix() {
        return this.fPrefix;
    }

    public void setPrefix(String prefix) {
        this.fPrefix = prefix;
        for (NLSSubstitutionGroup group : this.fSubstitutionGroups) {
            NLSSubstitution[] substitutions = group.getSubstitutions();
            int i = 0;
            while (i < substitutions.length) {
                substitutions[i].setPrefix(prefix);
                ++i;
            }
        }
    }

    public IFile getFile() {
        return this.jsfFile;
    }
}

