/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.refactoring;

import java.text.MessageFormat;
import oracle.eclipse.tools.webtier.jsf.ui.internal.Activator;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.Messages;
import oracle.eclipse.tools.webtier.ui.utils.TagIDUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FixIdsWizard
extends RefactoringWizard {
    public FixIdsWizard(IFile file) {
        super((Refactoring)new FixIdRefactoring(file), 3);
        this.setDefaultPageTitle(MessageFormat.format(Messages.FixIdWizardPage_title, file.getName()));
        this.setWindowTitle(Messages.FixIdWizardPage_name);
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_EXTERNALIZE_STRINGS);
    }

    protected void addUserInputPages() {
    }

    public static void open(final IFile file, final Shell shell) {
        if (file == null || !file.exists()) {
            return;
        }
        Display display = shell != null ? shell.getDisplay() : Display.getCurrent();
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                RefactoringSaveHelper saveHelper = new RefactoringSaveHelper(1);
                saveHelper.saveEditors(shell);
                RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)new FixIdsWizard(file));
                try {
                    int result = op.run(shell, Messages.FixIdWizardPage_title);
                    if (result == 1 || result == 1025) {
                        saveHelper.triggerIncrementalBuild();
                    }
                }
                catch (InterruptedException e) {
                    Activator.log(e);
                }
            }
        });
    }

    private static class FixIdRefactoring
    extends Refactoring {
        private IFile jsfFile;

        public FixIdRefactoring(IFile file) {
            this.jsfFile = file;
        }

        public String getName() {
            return Messages.FixIdWizardPage_name;
        }

        public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return RefactoringStatus.create((IStatus)Status.OK_STATUS);
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return RefactoringStatus.create((IStatus)Status.OK_STATUS);
        }

        public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return TagIDUtils.fixFragmentIds((IFile)this.jsfFile);
        }
    }
}

