/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.refactoring;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.Messages;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.NLSRefactoring;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.NLSSubstitution;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.NLSSubstitutionGroup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.refactoring.nls.KeyValuePair;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEscapes;
import org.eclipse.jdt.internal.ui.refactoring.nls.MultiStateCellEditor;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.jsp.ui.StructuredTextViewerConfigurationJSP;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;

public class ExternalizeWizardPage
extends UserInputWizardPage {
    private static final String[] PROPERTIES = new String[3];
    private static final String[] fgTitles;
    private static final int STATE_PROP = 0;
    private static final int VAL_PROP = 1;
    private static final int KEY_PROP = 2;
    private static final int SIZE = 3;
    private static final int ROW_COUNT = 5;
    private static final String PAGE_NAME = "NLSWizardPage1";
    private Text fPrefixField;
    private Table fTable;
    private TableViewer fTableViewer;
    private SourceViewer fSourceViewer;
    private NLSSubstitutionGroup[] fSubstitutionGroups;
    private Button fExternalizeButton;
    private Button fIgnoreButton;
    private Button fEditButton;
    private NLSRefactoring fNLSRefactoring;
    private Combo fMessageBundleField;
    private IFile fJsfFile;

    static {
        ExternalizeWizardPage.PROPERTIES[0] = "task";
        ExternalizeWizardPage.PROPERTIES[2] = "key";
        ExternalizeWizardPage.PROPERTIES[1] = "value";
        fgTitles = new String[3];
        ExternalizeWizardPage.fgTitles[0] = "";
        ExternalizeWizardPage.fgTitles[2] = Messages.ExternalizeWizardPage_key;
        ExternalizeWizardPage.fgTitles[1] = Messages.ExternalizeWizardPage_value;
    }

    private static String getEscapedAsciiString(String s) {
        if (s != null) {
            StringBuffer sb = new StringBuffer(s.length());
            int length = s.length();
            int i = 0;
            while (i < length) {
                char c = s.charAt(i);
                sb.append(ExternalizeWizardPage.getEscapedAsciiString(c));
                ++i;
            }
            return sb.toString();
        }
        return null;
    }

    private static String getEscapedAsciiString(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return String.valueOf(c);
    }

    private NLSSubstitutionGroup getGroup(NLSSubstitution substitution) {
        NLSSubstitutionGroup[] nLSSubstitutionGroupArray = this.fSubstitutionGroups;
        int n = this.fSubstitutionGroups.length;
        int n2 = 0;
        while (n2 < n) {
            NLSSubstitution[] substitutions;
            NLSSubstitutionGroup group = nLSSubstitutionGroupArray[n2];
            NLSSubstitution[] nLSSubstitutionArray = substitutions = group.getSubstitutions();
            int n3 = substitutions.length;
            int n4 = 0;
            while (n4 < n3) {
                NLSSubstitution nlsSubstitution = nLSSubstitutionArray[n4];
                if (substitution.equals(nlsSubstitution)) {
                    return group;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public ExternalizeWizardPage(NLSRefactoring nlsRefactoring, IFile file) {
        super(PAGE_NAME);
        this.fSubstitutionGroups = nlsRefactoring.getSubstitutionGroups();
        this.fNLSRefactoring = nlsRefactoring;
        this.fJsfFile = file;
        this.setDescription(Messages.ExternalizeWizardPage_description);
        this.createDefaultExternalization();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite supercomposite = new Composite(parent, 0);
        supercomposite.setFont(parent.getFont());
        supercomposite.setLayout((Layout)new GridLayout());
        this.createKeyPrefixField(supercomposite);
        SashForm composite = new SashForm(supercomposite, 512);
        composite.setFont(supercomposite.getFont());
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.createTableViewer((Composite)composite);
        this.createSourceViewer((Composite)composite);
        this.createResourceBundleComposite(supercomposite);
        composite.setWeights(new int[]{65, 45});
        this.validateKeys(false);
        this.updateButtonStates((IStructuredSelection)StructuredSelection.EMPTY);
        this.setControl((Control)supercomposite);
        Dialog.applyDialogFont((Control)supercomposite);
    }

    private void createResourceBundleComposite(Composite supercomposite) {
        Composite accessorComposite = new Composite(supercomposite, 0);
        accessorComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        accessorComposite.setLayout((Layout)layout);
        Composite composite = new Composite(accessorComposite, 0);
        composite.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label accessorClassLabel = new Label(composite, 0);
        accessorClassLabel.setText(Messages.ExternalizeWizardPage_accessorclass_label);
        accessorClassLabel.setLayoutData((Object)new GridData());
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalizeWizardPage.this.doAccessorSelectionChanged();
            }
        };
        GridData data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(30);
        this.fMessageBundleField = new Combo(composite, 8);
        SWTUtil.setDefaultVisibleItemCount((Combo)this.fMessageBundleField);
        this.fMessageBundleField.setLayoutData((Object)data);
        this.fMessageBundleField.addSelectionListener((SelectionListener)listener);
        this.updateMessageBundleChoices();
    }

    protected void doAccessorSelectionChanged() {
        int selectionIndex = this.fMessageBundleField.getSelectionIndex();
        if (this.fMessageBundleField != null && selectionIndex >= 0) {
            NLSSubstitutionGroup group = this.getCurrentSelectedGroup();
            if (group != null) {
                this.fNLSRefactoring.setSelectedGroup(group);
                NLSSubstitution.updateSubtitutions(group.getSubstitutions(), this.getProperties(group), "null");
            }
            this.validateKeys(true);
        }
    }

    protected void updateMessageBundleChoices() {
        ArrayList<String> labelList = new ArrayList<String>();
        NLSSubstitutionGroup[] nLSSubstitutionGroupArray = this.fSubstitutionGroups;
        int n = this.fSubstitutionGroups.length;
        int n2 = 0;
        while (n2 < n) {
            NLSSubstitutionGroup group = nLSSubstitutionGroupArray[n2];
            String label = group.getLabel();
            this.fMessageBundleField.setData(label, (Object)group);
            labelList.add(label);
            ++n2;
        }
        this.fMessageBundleField.setItems(labelList.toArray(new String[0]));
        if (labelList.size() > 0) {
            this.fMessageBundleField.select(0);
        }
    }

    protected NLSSubstitutionGroup getCurrentSelectedGroup() {
        if (this.fMessageBundleField == null) {
            return null;
        }
        int ind = this.fMessageBundleField.getSelectionIndex();
        if (ind >= 0) {
            String label = this.fMessageBundleField.getItem(ind);
            return (NLSSubstitutionGroup)this.fMessageBundleField.getData(label);
        }
        return null;
    }

    private Properties getProperties(NLSSubstitutionGroup group) {
        IFile propertyFile = group.getBundleResource();
        Properties props = new Properties();
        try {
            if (propertyFile.exists()) {
                InputStream is = propertyFile.getContents();
                props.load(is);
                is.close();
            }
        }
        catch (Exception exception) {}
        return props;
    }

    private void createTableViewer(Composite composite) {
        this.createTableComposite(composite);
        this.fTableViewer = new TableViewer(this.fTable){

            protected void hookControl(Control control) {
                super.hookControl(control);
                ((Table)control).addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDoubleClick(MouseEvent e) {
                        if (this.getTable().getSelection().length == 0) {
                            return;
                        }
                        TableItem item = this.getTable().getSelection()[0];
                        if (item.getBounds(0).contains(e.x, e.y)) {
                            List widgetSel = this.getSelectionFromWidget();
                            if (widgetSel == null || widgetSel.size() != 1) {
                                return;
                            }
                            NLSSubstitution substitution = (NLSSubstitution)widgetSel.get(0);
                            Integer value = (Integer)this.getCellModifier().getValue((Object)substitution, PROPERTIES[0]);
                            int newValue = MultiStateCellEditor.getNextValue((int)2, (int)value);
                            this.getCellModifier().modify((Object)item, PROPERTIES[0], (Object)new Integer(newValue));
                        }
                    }
                });
            }
        };
        this.fTableViewer.setUseHashlookup(true);
        CellEditor[] editors = this.createCellEditors();
        this.fTableViewer.setCellEditors(editors);
        this.fTableViewer.setColumnProperties(PROPERTIES);
        this.fTableViewer.setCellModifier((ICellModifier)new CellModifier());
        this.fTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                NLSSubstitutionGroup group = null;
                if (ExternalizeWizardPage.this.fMessageBundleField == null) {
                    if (ExternalizeWizardPage.this.fSubstitutionGroups != null && ExternalizeWizardPage.this.fSubstitutionGroups.length > 0) {
                        group = ExternalizeWizardPage.this.fSubstitutionGroups[0];
                    }
                } else {
                    group = ExternalizeWizardPage.this.getCurrentSelectedGroup();
                }
                if (group != null) {
                    return group.getSubstitutions();
                }
                return new NLSSubstitutionGroup[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fTableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                NLSSubstitution curr = (NLSSubstitution)element;
                return curr.getInitialState() == 2 || curr.getInitialState() == 0 && curr.getInitialValue() == null;
            }
        });
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new NLSSubstitutionLabelProvider());
        this.fTableViewer.setInput(new Object());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExternalizeWizardPage.this.selectionChanged(event);
            }
        });
    }

    private void createDefaultExternalization() {
        NLSSubstitutionGroup[] nLSSubstitutionGroupArray = this.fSubstitutionGroups;
        int n = this.fSubstitutionGroups.length;
        int n2 = 0;
        while (n2 < n) {
            NLSSubstitutionGroup group = nLSSubstitutionGroupArray[n2];
            NLSSubstitution[] substitutions = group.getSubstitutions();
            int i = 0;
            while (i < substitutions.length) {
                NLSSubstitution substitution = substitutions[i];
                if (substitution.getState() == 2) {
                    substitution.setState(0);
                    substitution.generateKey(substitutions, this.getProperties(group));
                }
                ++i;
            }
            ++n2;
        }
    }

    private CellEditor[] createCellEditors() {
        CellEditor[] editors = new CellEditor[3];
        editors[0] = new MultiStateCellEditor((Composite)this.fTable, 2, 0);
        editors[2] = new TextCellEditor((Composite)this.fTable);
        editors[1] = new TextCellEditor((Composite)this.fTable);
        return editors;
    }

    private SourceViewer createViewer(Composite parent) {
        StructuredTextViewerConfiguration sourceViewerConfiguration = new StructuredTextViewerConfiguration(){
            StructuredTextViewerConfiguration baseConfiguration = new StructuredTextViewerConfigurationJSP();

            public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
                return this.baseConfiguration.getConfiguredContentTypes(sourceViewer);
            }

            public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
                return this.baseConfiguration.getLineStyleProviders(sourceViewer, partitionType);
            }
        };
        StructuredTextViewer viewer = new StructuredTextViewer(parent, null, null, false, 2816);
        viewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.wst.sse.ui.textfont"));
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(this.fJsfFile);
        IStructuredDocument document = model.getStructuredDocument();
        viewer.configure((SourceViewerConfiguration)sourceViewerConfiguration);
        viewer.setDocument((IDocument)document);
        return viewer;
    }

    private void createSourceViewer(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        c.setLayout((Layout)gl);
        Label l = new Label(c, 0);
        l.setText(Messages.ExternalizeWizardPage_context);
        l.setLayoutData((Object)new GridData());
        this.fSourceViewer = this.createViewer(c);
        this.fSourceViewer.setEditable(false);
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        gd.widthHint = this.convertWidthInCharsToPixels(40);
        this.fSourceViewer.getControl().setLayoutData((Object)gd);
    }

    private void createKeyPrefixField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        Label l = new Label(composite, 0);
        l.setText(Messages.ExternalizeWizardPage_common_prefix);
        l.setLayoutData((Object)new GridData());
        this.fPrefixField = new Text(composite, 2052);
        this.fPrefixField.setLayoutData((Object)new GridData(768));
        this.fPrefixField.setText(this.fNLSRefactoring.getPrefix());
        this.fPrefixField.selectAll();
        this.fPrefixField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExternalizeWizardPage.this.fNLSRefactoring.setPrefix(ExternalizeWizardPage.this.fPrefixField.getText());
                ExternalizeWizardPage.this.validateKeys(true);
            }
        });
    }

    private void validateKeys(boolean refreshTable) {
        RefactoringStatus status = new RefactoringStatus();
        NLSSubstitutionGroup group = this.getCurrentSelectedGroup();
        if (group != null) {
            this.checkInvalidKeys(group, status);
            this.checkDuplicateKeys(group, status);
            this.checkDuplicateWithProperties(group, status);
            this.checkMissingKeys(group, status);
            this.setPageComplete(status);
            if (refreshTable) {
                this.fTableViewer.refresh(true);
            }
        }
    }

    private void checkDuplicateWithProperties(NLSSubstitutionGroup group, RefactoringStatus status) {
        Properties properties = this.getProperties(group);
        NLSSubstitution[] substitutions = group.getSubstitutions();
        int i = 0;
        while (i < substitutions.length) {
            String key = substitutions[i].getKey();
            if (properties.containsKey(key) && !properties.get(key).equals(substitutions[i].getValue()) && status != null) {
                status.addFatalError(MessageFormat.format(Messages.ExternalizeWizardPage_keyExistInPropertyFile, key));
            }
            ++i;
        }
    }

    private void checkInvalidKeys(NLSSubstitutionGroup group, RefactoringStatus status) {
        NLSSubstitution[] substitutions = group.getSubstitutions();
        int i = 0;
        while (i < substitutions.length) {
            if (!this.isKeyValid(substitutions[i], status)) {
                return;
            }
            ++i;
        }
    }

    private boolean isKeyValid(NLSSubstitution substitution, RefactoringStatus status) {
        if (substitution == null) {
            return false;
        }
        if (substitution.getState() != 0) {
            return true;
        }
        String key = substitution.getKey();
        if (key == null || key.length() == 0) {
            if (status != null) {
                status.addFatalError(Messages.ExternalizeWizardPage_warning_keyInvalid);
            }
            return false;
        }
        int i = 0;
        while (i < key.length()) {
            if (Character.isWhitespace(key.charAt(i))) {
                if (status != null) {
                    status.addFatalError(Messages.ExternalizeWizardPage_warning_keyInvalid);
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    private void checkDuplicateKeys(NLSSubstitutionGroup group, RefactoringStatus status) {
        NLSSubstitution[] substitutions = group.getSubstitutions();
        int i = 0;
        while (i < substitutions.length) {
            NLSSubstitution substitution = substitutions[i];
            if (this.conflictingKeys(group, substitution)) {
                status.addFatalError(Messages.ExternalizeWizardPage_warning_conflicting);
                return;
            }
            ++i;
        }
    }

    private void checkMissingKeys(NLSSubstitutionGroup group, RefactoringStatus status) {
        NLSSubstitution[] substitutions = group.getSubstitutions();
        int i = 0;
        while (i < substitutions.length) {
            NLSSubstitution substitution = substitutions[i];
            if (substitution.getValue() == null && substitution.getKey() != null) {
                status.addWarning(Messages.ExternalizeWizardPage_warning_keymissing);
                return;
            }
            ++i;
        }
    }

    private boolean conflictingKeys(NLSSubstitutionGroup group, NLSSubstitution substitution) {
        NLSSubstitution[] substitutions = group.getSubstitutions();
        if (substitution.getState() == 0) {
            return substitution.isConflicting(substitutions);
        }
        return false;
    }

    private void createTableComposite(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setFont(parent.getFont());
        comp.setLayoutData((Object)new GridData(1808));
        FormLayout fl = new FormLayout();
        fl.marginWidth = 0;
        fl.marginHeight = 0;
        comp.setLayout((Layout)fl);
        Label l = new Label(comp, 0);
        l.setText(Messages.ExternalizeWizardPage_strings_to_externalize);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        l.setLayoutData((Object)formData);
        Control tableControl = this.createTable(comp);
        formData = new FormData();
        formData.top = new FormAttachment((Control)l, 5);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        tableControl.setLayoutData((Object)formData);
    }

    protected void doFilterCheckBoxPressed() {
        this.fTableViewer.refresh();
    }

    private Control createTable(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        c.setLayout((Layout)gl);
        this.fTable = new Table(c, 101122);
        this.fTable.setFont(parent.getFont());
        GridData tableGD = new GridData(1808);
        tableGD.heightHint = SWTUtil.getTableHeightHint((Table)this.fTable, (int)5);
        this.fTable.setLayoutData((Object)tableGD);
        this.fTable.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        this.fTable.setLayout((Layout)layout);
        this.fTable.setHeaderVisible(true);
        ColumnLayoutData[] columnLayoutData = new ColumnLayoutData[3];
        columnLayoutData[0] = new ColumnPixelData(18, false, true);
        columnLayoutData[2] = new ColumnWeightData(40, true);
        columnLayoutData[1] = new ColumnWeightData(40, true);
        int i = 0;
        while (i < fgTitles.length) {
            TableColumn tc = new TableColumn(this.fTable, 0, i);
            tc.setText(fgTitles[i]);
            layout.addColumnData(columnLayoutData[i]);
            tc.setResizable(columnLayoutData[i].resizable);
            ++i;
        }
        this.createButtonComposite(c);
        return c;
    }

    private void createButtonComposite(Composite parent) {
        Composite buttonComp = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        buttonComp.setLayout((Layout)gl);
        buttonComp.setLayoutData((Object)new GridData(1040));
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalizeWizardPage.this.handleButtonPressed(e.widget);
            }
        };
        this.fExternalizeButton = this.createTaskButton(buttonComp, Messages.ExternalizeWizardPage_Externalize_Selected, adapter);
        this.fIgnoreButton = this.createTaskButton(buttonComp, Messages.ExternalizeWizardPage_Ignore_Selected, adapter);
        new Label(buttonComp, 0);
        this.fEditButton = this.createTaskButton(buttonComp, Messages.ExternalizeWizardPage_Edit_key_and_value, adapter);
        this.fEditButton.setEnabled(false);
        buttonComp.pack();
    }

    protected void handleButtonPressed(Widget widget) {
        this.fTableViewer.getTable().forceFocus();
        if (widget == this.fExternalizeButton) {
            this.setSelectedTasks(0);
        } else if (widget == this.fIgnoreButton) {
            this.setSelectedTasks(1);
        } else if (widget == this.fEditButton) {
            this.openEditButton(this.fTableViewer.getSelection());
        }
    }

    private Button createTaskButton(Composite parent, String label, SelectionAdapter adapter) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint((Button)button);
        button.addSelectionListener((SelectionListener)adapter);
        return button;
    }

    private void openEditButton(ISelection selection) {
        try {
            IStructuredSelection sel = (IStructuredSelection)this.fTableViewer.getSelection();
            NLSSubstitution substitution = (NLSSubstitution)sel.getFirstElement();
            if (substitution == null) {
                return;
            }
            NLSInputDialog dialog = new NLSInputDialog(this.getShell(), substitution);
            if (dialog.open() == 1) {
                return;
            }
            KeyValuePair kvPair = dialog.getResult();
            if (substitution.getState() == 0) {
                substitution.setKey(kvPair.getKey());
            }
            substitution.setValue(kvPair.getValue());
            this.validateKeys(false);
        }
        finally {
            this.fTableViewer.refresh();
            this.fTableViewer.getControl().setFocus();
            this.fTableViewer.setSelection(selection);
        }
    }

    private List<?> getSelectedTableEntries() {
        ISelection sel = this.fTableViewer.getSelection();
        if (sel instanceof IStructuredSelection) {
            return ((IStructuredSelection)sel).toList();
        }
        return Collections.EMPTY_LIST;
    }

    private void setSelectedTasks(int state) {
        Assert.isTrue((state == 0 || state == 1 || state == 2 ? 1 : 0) != 0);
        NLSSubstitutionGroup group = this.getCurrentSelectedGroup();
        List<?> selected = this.getSelectedTableEntries();
        String[] props = new String[]{PROPERTIES[0]};
        for (NLSSubstitution substitution : selected) {
            substitution.setState(state);
            if (group == null || substitution.getState() != 0 || !substitution.hasStateChanged()) continue;
            substitution.generateKey(group.getSubstitutions(), this.getProperties(group));
        }
        this.fTableViewer.update(selected.toArray(), props);
        this.fTableViewer.getControl().setFocus();
        this.updateButtonStates((IStructuredSelection)this.fTableViewer.getSelection());
    }

    private void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.updateButtonStates(selection);
        this.updateSourceView(selection);
    }

    private void updateSourceView(IStructuredSelection selection) {
        NLSSubstitution first = (NLSSubstitution)selection.getFirstElement();
        if (first != null) {
            Region region = first.getNLSElement().getPosition();
            this.fSourceViewer.setSelectedRange(region.getOffset(), region.getLength());
            this.fSourceViewer.revealRange(region.getOffset(), region.getLength());
        }
    }

    private void updateButtonStates(IStructuredSelection selection) {
        this.fExternalizeButton.setEnabled(true);
        this.fIgnoreButton.setEnabled(true);
        if (this.containsOnlyElementsOfSameState(0, selection)) {
            this.fExternalizeButton.setEnabled(false);
        }
        if (this.containsOnlyElementsOfSameState(1, selection)) {
            this.fIgnoreButton.setEnabled(false);
        }
        this.fEditButton.setEnabled(selection.size() == 1);
    }

    private boolean containsOnlyElementsOfSameState(int state, IStructuredSelection selection) {
        for (NLSSubstitution substitution : selection) {
            if (substitution.getState() == state) continue;
            return false;
        }
        return true;
    }

    public boolean performFinish() {
        return super.performFinish();
    }

    public IWizardPage getNextPage() {
        return super.getNextPage();
    }

    public void dispose() {
        this.fPrefixField = null;
        this.fSourceViewer = null;
        this.fTable = null;
        this.fTableViewer = null;
        this.fEditButton = null;
        super.dispose();
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            if (property == null) {
                return false;
            }
            if (!(element instanceof NLSSubstitution)) {
                return false;
            }
            NLSSubstitution subst = (NLSSubstitution)element;
            return !PROPERTIES[2].equals(property) || subst.getState() == 0;
        }

        public Object getValue(Object element, String property) {
            if (element instanceof NLSSubstitution) {
                NLSSubstitution substitution = (NLSSubstitution)element;
                String res = null;
                if (PROPERTIES[2].equals(property)) {
                    res = substitution.getKeyWithoutPrefix();
                } else if (PROPERTIES[1].equals(property)) {
                    res = substitution.getValue();
                } else if (PROPERTIES[0].equals(property)) {
                    return new Integer(substitution.getState());
                }
                if (res != null) {
                    return ExternalizeWizardPage.getEscapedAsciiString(res);
                }
                return "";
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TableItem) {
                Object data = ((TableItem)element).getData();
                if (data instanceof NLSSubstitution) {
                    String string;
                    NLSSubstitution substitution = (NLSSubstitution)data;
                    if (PROPERTIES[2].equals(property)) {
                        string = (String)value;
                        try {
                            string = PropertiesFileEscapes.unescape((String)string);
                        }
                        catch (CoreException e) {
                            ExternalizeWizardPage.this.setPageComplete(RefactoringStatus.create((IStatus)e.getStatus()));
                            return;
                        }
                        substitution.setKey(string);
                    }
                    if (PROPERTIES[1].equals(property)) {
                        string = (String)value;
                        try {
                            string = PropertiesFileEscapes.unescape((String)string);
                        }
                        catch (CoreException e) {
                            ExternalizeWizardPage.this.setPageComplete(RefactoringStatus.create((IStatus)e.getStatus()));
                            return;
                        }
                        substitution.setValue(string);
                    }
                    if (PROPERTIES[0].equals(property)) {
                        substitution.setState((Integer)value);
                        NLSSubstitutionGroup parentGroup = ExternalizeWizardPage.this.getGroup(substitution);
                        if (substitution.getState() == 0 && substitution.hasStateChanged() && parentGroup != null) {
                            substitution.generateKey(parentGroup.getSubstitutions(), ExternalizeWizardPage.this.getProperties(parentGroup));
                        }
                    }
                }
                ExternalizeWizardPage.this.validateKeys(false);
                ExternalizeWizardPage.this.fTableViewer.update(data, null);
            }
        }
    }

    private class NLSInputDialog
    extends StatusDialog
    implements IDialogFieldListener {
        private StringDialogField fKeyField;
        private StringDialogField fValueField;
        private DialogField fMessageField;
        private NLSSubstitution fSubstitution;

        public NLSInputDialog(Shell parent, NLSSubstitution substitution) {
            super(parent);
            this.setTitle(Messages.ExternalizeWizardPage_NLSInputDialog_Title);
            this.fSubstitution = substitution;
            this.fMessageField = new DialogField();
            if (substitution.getState() == 0) {
                this.fMessageField.setLabelText(Messages.ExternalizeWizardPage_NLSInputDialog_ext_Label);
            } else {
                this.fMessageField.setLabelText(Messages.ExternalizeWizardPage_NLSInputDialog_Label);
            }
            this.fKeyField = new StringDialogField();
            this.fKeyField.setLabelText(Messages.ExternalizeWizardPage_NLSInputDialog_Enter_key);
            this.fKeyField.setDialogFieldListener((IDialogFieldListener)this);
            this.fValueField = new StringDialogField();
            this.fValueField.setLabelText(Messages.ExternalizeWizardPage_NLSInputDialog_Enter_value);
            this.fValueField.setDialogFieldListener((IDialogFieldListener)this);
            if (substitution.getState() == 0) {
                this.fKeyField.setText(substitution.getKeyWithoutPrefix());
            } else {
                this.fKeyField.setText("");
            }
            this.fValueField.setText(substitution.getValueNonEmpty());
        }

        public KeyValuePair getResult() {
            KeyValuePair res = new KeyValuePair(this.fKeyField.getText(), this.fValueField.getText());
            return res;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite inner = new Composite(composite, 0);
            inner.setFont(composite.getFont());
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            inner.setLayout((Layout)layout);
            this.fMessageField.doFillIntoGrid(inner, 2);
            if (this.fSubstitution.getState() == 0) {
                this.fKeyField.doFillIntoGrid(inner, 2);
                LayoutUtil.setWidthHint((Control)this.fKeyField.getTextControl(null), (int)this.convertWidthInCharsToPixels(45));
            }
            this.fValueField.doFillIntoGrid(inner, 2);
            LayoutUtil.setWidthHint((Control)this.fValueField.getTextControl(null), (int)this.convertWidthInCharsToPixels(45));
            LayoutUtil.setHorizontalGrabbing((Control)this.fValueField.getTextControl(null));
            this.fValueField.postSetFocusOnDialogField(parent.getDisplay());
            NLSInputDialog.applyDialogFont((Control)composite);
            return composite;
        }

        public void dialogFieldChanged(DialogField field) {
            IStatus keyStatus = this.validateKey(this.fKeyField.getText());
            this.updateStatus(keyStatus);
        }

        private IStatus validateKey(String val) {
            if (this.fSubstitution.getState() != 0) {
                return StatusInfo.OK_STATUS;
            }
            if (val == null || val.length() == 0) {
                return new StatusInfo(4, Messages.ExternalizeWizardPage_NLSInputDialog_Error_empty_key);
            }
            int i = 0;
            while (i < val.length()) {
                if (Character.isWhitespace(val.charAt(i))) {
                    return new StatusInfo(4, Messages.ExternalizeWizardPage_NLSInputDialog_Error_invalid_key);
                }
                ++i;
            }
            return StatusInfo.OK_STATUS;
        }
    }

    private class NLSSubstitutionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        private FontRegistry fFontRegistry = JFaceResources.getFontRegistry();

        public String getColumnText(Object element, int columnIndex) {
            String columnText = "";
            if (element instanceof NLSSubstitution) {
                NLSSubstitution substitution = (NLSSubstitution)element;
                if (columnIndex == 2) {
                    if (substitution.getState() == 0) {
                        columnText = BasicElementLabels.getJavaElementName((String)substitution.getKey());
                    }
                } else if (columnIndex == 1 && substitution.getValue() != null) {
                    columnText = substitution.getValue();
                }
            }
            return ExternalizeWizardPage.getEscapedAsciiString(columnText);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof NLSSubstitution) {
                return this.getNLSImage((NLSSubstitution)element);
            }
            return null;
        }

        public Font getFont(Object element) {
            NLSSubstitution substitution;
            if (element instanceof NLSSubstitution && ((substitution = (NLSSubstitution)element).hasPropertyFileChange() || substitution.hasSourceChange())) {
                return this.fFontRegistry.getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }

        private Image getNLSImage(NLSSubstitution sub) {
            if (sub.getValue() == null && sub.getKey() != null) {
                JavaElementImageDescriptor imageDescriptor = new JavaElementImageDescriptor(this.getNLSImageDescriptor(sub.getState()), 32, JavaElementImageProvider.SMALL_SIZE);
                return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)imageDescriptor);
            }
            NLSSubstitutionGroup group = ExternalizeWizardPage.this.getGroup(sub);
            if (group != null && (sub.isConflicting(group.getSubstitutions()) || !ExternalizeWizardPage.this.isKeyValid(sub, null))) {
                JavaElementImageDescriptor imageDescriptor = new JavaElementImageDescriptor(this.getNLSImageDescriptor(sub.getState()), 64, JavaElementImageProvider.SMALL_SIZE);
                return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)imageDescriptor);
            }
            return this.getNLSImage(sub.getState());
        }

        private Image getNLSImage(int task) {
            switch (task) {
                case 0: {
                    return JavaPluginImages.get((String)"org.eclipse.jdt.ui.translate.gif");
                }
                case 1: {
                    return JavaPluginImages.get((String)"org.eclipse.jdt.ui.never_translate.gif");
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        private ImageDescriptor getNLSImageDescriptor(int task) {
            switch (task) {
                case 0: {
                    return JavaPluginImages.DESC_OBJS_NLS_TRANSLATE;
                }
                case 1: {
                    return JavaPluginImages.DESC_OBJS_NLS_NEVER_TRANSLATE;
                }
                case 2: {
                    return JavaPluginImages.DESC_OBJS_NLS_SKIP;
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }
    }
}

