/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.quickfix.facelet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.DocumentVariableQuery;
import oracle.eclipse.tools.application.common.services.variables.IFileVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.JDTDataType;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.jsf.ui.internal.Activator;
import oracle.eclipse.tools.webtier.jsf.ui.quickfix.AbstractCompletionProposal;
import oracle.eclipse.tools.webtier.jsf.variable.FacesExternalVariable;
import oracle.eclipse.tools.xml.model.emfbinding.ExtendedEcoreUtil;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContextFactory;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INodeReader;
import oracle.eclipse.tools.xml.model.metadata.TleiAccess;
import oracle.eclipse.tools.xml.model.metadata.tlei.SubTypes;
import oracle.eclipse.tools.xml.model.service.IXMLMetadataContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jst.jsf.common.internal.types.CompositeType;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory2;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.jsf.facelet.core.internal.util.ViewUtil;
import org.eclipse.jst.jsf.metadataprocessors.features.ELIsNotValidException;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidELValues;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FaceletQuickAssistProcessor
implements IQuickAssistProcessor {
    private static final String LINE_DELIMITER = System.getProperty("line.separator", "\n");

    public String getErrorMessage() {
        return null;
    }

    public boolean canFix(Annotation annotation) {
        return true;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return true;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        List<TemporaryAnnotation> relevant = this.getRelevant(invocationContext);
        ArrayList<Object> props = new ArrayList<Object>();
        if (!relevant.isEmpty()) {
            props.addAll(this.processAnnotations(invocationContext, relevant));
        }
        props.addAll(this.addNonFixAssists(invocationContext));
        return props.toArray(new ICompletionProposal[0]);
    }

    private Collection<? extends ICompletionProposal> addNonFixAssists(IQuickAssistInvocationContext invocationContext) {
        IDocument doc;
        Node node;
        IDOMContextResolver domContextResolver;
        ArrayList<? extends ICompletionProposal> props = new ArrayList<ICompletionProposal>();
        IStructuredDocumentContext context = this.createSDContext(invocationContext);
        if (context != null && (domContextResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context)) != null && (node = domContextResolver.getNode()) instanceof Attr && (doc = this.getIDocument(context)) != null) {
            SubTypes subtype;
            Element parentNode;
            String uri;
            EStructuralFeature feature;
            INamespaceContext nsContext;
            IFileVariablesCache fileCache = VariablesController.getInstance().getFileCache(doc.getFile(), true);
            Set references = fileCache.getReferences();
            for (ValueReference ref : references) {
                List featureAdapters;
                String fieldName;
                Variable variable;
                DataType type;
                DataType.Field field = ref.getField((IModelContext)context);
                if (field != null || ref.getFieldName() == null || !ref.getLocation().contains((long)context.getDocumentPosition()) || ref.getFieldName().indexOf(46) >= 0 || !((type = (variable = ref.getVariable()).getType()) instanceof JDTDataType) || (field = ((JDTDataType)type).getField(fieldName = ref.getFieldName(), (IModelContext)context)) != null) continue;
                boolean isMethodSignature = false;
                String typeString = "java.lang.Object";
                IXMLMetadataContext mdContext = (IXMLMetadataContext)doc.getAdapter(IXMLMetadataContext.class);
                if (mdContext != null && (featureAdapters = mdContext.getMetaDataFeature(IValidELValues.class, "http://xmlns.oracle.com/adf/faces/rich", ((Attr)node).getOwnerElement().getLocalName(), ((Attr)node).getLocalName(), -1)) != null && featureAdapters.size() > 0) {
                    IValidELValues validValues = (IValidELValues)featureAdapters.get(0);
                    try {
                        CompositeType expectedRuntimeType = validValues.getExpectedRuntimeType();
                        boolean bl = isMethodSignature = !expectedRuntimeType.getIsTypeSignature()[0];
                        if (!isMethodSignature) {
                            String sig = expectedRuntimeType.getSignatures()[0];
                            typeString = Signature.toString((String)sig);
                        }
                    }
                    catch (ELIsNotValidException e) {
                        Activator.log((Exception)((Object)e));
                    }
                }
                props.add(new BeanPropertyProposal(((JDTDataType)type).getType(), ref.getFieldName(), true, typeString));
                props.add(new BeanPropertyProposal(((JDTDataType)type).getType(), ref.getFieldName(), false, typeString));
                props.add(new BeanMethodProposal(((JDTDataType)type).getType(), ref.getFieldName()));
            }
            INamespaceContextFactory factory = (INamespaceContextFactory)doc.getAdapter(INamespaceContextFactory.class);
            if (factory != null && (nsContext = factory.getNamespaceContext(doc.getFile())) != null && (feature = ExtendedEcoreUtil.INSTANCE.getFeature(uri = nsContext.getNamespace((Node)(parentNode = ((Attr)node).getOwnerElement())), INodeReader.INSTANCE.getElementQName(parentNode), INodeReader.INSTANCE.getAttributeName(node))) != null && (subtype = TleiAccess.INSTANCE.getSubtype(doc, feature)) == SubTypes.URI_SUBTYPE && ((Attr)node).getNodeValue() != null && !((Attr)node).getNodeValue().contains("#{")) {
                props.addAll(this.addUriToMapBeanRefactors((Attr)node, context, doc));
            }
        }
        return props;
    }

    private Collection<? extends ICompletionProposal> addUriToMapBeanRefactors(Attr node, IStructuredDocumentContext context, IDocument doc) {
        ArrayList<UriToMapBeanCompletionProposals> props = new ArrayList<UriToMapBeanCompletionProposals>();
        DocumentVariableQuery query = new DocumentVariableQuery(doc, context.getDocumentPosition());
        List vars = query.findVariable(new VariableQuery.QueryMatcher(){

            public boolean matches(Variable testMe) {
                if (testMe instanceof FacesExternalVariable) {
                    return testMe.getType() != null && testMe.getType().isMap();
                }
                return false;
            }
        });
        for (Variable var : vars) {
            props.add(new UriToMapBeanCompletionProposals(node, var));
        }
        return props;
    }

    private IDocument getIDocument(IStructuredDocumentContext context) {
        IResource file;
        IWorkspaceContextResolver wsResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context);
        if (wsResolver != null && (file = wsResolver.getResource()) != null && file.getType() == 1) {
            return (IDocument)file.getAdapter(IDocument.class);
        }
        return null;
    }

    private List<? extends ICompletionProposal> processAnnotations(IQuickAssistInvocationContext invocationContext, List<TemporaryAnnotation> relevant) {
        for (TemporaryAnnotation anno : relevant) {
            String prefix;
            IDOMContextResolver domContextResolver;
            org.w3c.dom.Document domDocument;
            IStructuredDocumentContext context;
            String text = anno.getText();
            if (text == null || !text.contains("Unknown tag") || (context = this.createSDContext(invocationContext)) == null || (domDocument = (domContextResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context)).getDOMDocument()) == null) continue;
            Element documentElement = domDocument.getDocumentElement();
            Node node = domContextResolver.getNode();
            if (!(documentElement instanceof IDOMElement) || !(node instanceof Element) || (prefix = ((Element)node).getPrefix()) == null) continue;
            return this.getCompletionsForPrefix(context, (IDOMElement)documentElement, prefix);
        }
        return Collections.emptyList();
    }

    private IStructuredDocumentContext createSDContext(IQuickAssistInvocationContext invocationContext) {
        IStructuredDocumentContext context = IStructuredDocumentContextFactory2.INSTANCE.getContext((ITextViewer)invocationContext.getSourceViewer(), invocationContext.getOffset());
        return context;
    }

    private List<PrefixCompletionProposal> getCompletionsForPrefix(IStructuredDocumentContext context, IDOMElement documentElement, String prefix) {
        ITagRegistry tagRegistry;
        IProject project;
        IWorkspaceContextResolver workspaceContextResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context);
        if (workspaceContextResolver != null && (project = workspaceContextResolver.getProject()) != null && (tagRegistry = ViewUtil.getHtmlTagRegistry((IProject)project)) != null) {
            ArrayList<PrefixCompletionProposal> props = new ArrayList<PrefixCompletionProposal>(tagRegistry.getAllTagLibraries().size());
            Map alreadyUsed = ViewUtil.getDocumentNamespaces((org.w3c.dom.Document)documentElement.getOwnerDocument());
            for (Namespace ns : tagRegistry.getAllTagLibraries()) {
                if (this.alreadyUsed(alreadyUsed, ns.getNSUri())) continue;
                PrefixCompletionProposal prop = new PrefixCompletionProposal(documentElement, prefix, ns.getNSUri());
                props.add(prop);
            }
            if (!props.isEmpty()) {
                Collections.sort(props, new Comparator<PrefixCompletionProposal>(){

                    @Override
                    public int compare(PrefixCompletionProposal o1, PrefixCompletionProposal o2) {
                        if (o1.isPreferred()) {
                            return -1;
                        }
                        if (o2.isPreferred()) {
                            return 1;
                        }
                        return 0;
                    }
                });
            }
            return props;
        }
        return Collections.emptyList();
    }

    private boolean alreadyUsed(Map<String, ViewUtil.PrefixEntry> alreadyUsed, String nsUri) {
        for (Map.Entry<String, ViewUtil.PrefixEntry> entry : alreadyUsed.entrySet()) {
            if (!entry.getValue().getUri().equals(nsUri)) continue;
            return true;
        }
        return false;
    }

    private List<TemporaryAnnotation> getRelevant(IQuickAssistInvocationContext invocationContext) {
        ArrayList<TemporaryAnnotation> relevant = new ArrayList<TemporaryAnnotation>(3);
        IAnnotationModel annotationModel = invocationContext.getSourceViewer().getAnnotationModel();
        Iterator annotationIterator = annotationModel.getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            TemporaryAnnotation tanno;
            Object next = annotationIterator.next();
            if (!(next instanceof TemporaryAnnotation) || !(tanno = (TemporaryAnnotation)next).getPosition().overlapsWith(invocationContext.getOffset(), invocationContext.getLength())) continue;
            relevant.add(tanno);
        }
        return relevant;
    }

    private static void formatJava(IProject project, IMethod method, IEditorPart editorPart) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        Map options = null;
        if (javaProject != null) {
            options = javaProject.getOptions(true);
        }
        TextEdit edit = ToolFactory.createCodeFormatter(options).format(4, method.getSource(), 0, method.getSource().length(), 0, LINE_DELIMITER);
        Document document = new Document(method.getSource());
        if (document != null) {
            FaceletQuickAssistProcessor.edit((org.eclipse.jface.text.IDocument)document, edit);
        }
    }

    private static void edit(org.eclipse.jface.text.IDocument doc, TextEdit edit) {
        if (edit == null) {
            return;
        }
        try {
            edit.apply(doc, 2);
        }
        catch (MalformedTreeException mte) {
            mte.printStackTrace();
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    private static class BeanMethodProposal
    extends AbstractCompletionProposal {
        private IType type;
        private String fieldName;

        public BeanMethodProposal(IType type, String fieldName) {
            super(String.format("Add action method %s", fieldName));
            this.type = type;
            this.fieldName = fieldName;
        }

        @Override
        public void apply(org.eclipse.jface.text.IDocument document) {
            try {
                String bareSource = String.format("public void %s() { }", this.fieldName);
                IMethod createMethod = this.type.createMethod(bareSource, null, false, null);
                IEditorPart editor = JavaUI.openInEditor((IJavaElement)createMethod);
                FaceletQuickAssistProcessor.formatJava(this.type.getJavaProject().getProject(), createMethod, editor);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            catch (MalformedTreeException e) {
                e.printStackTrace();
            }
        }
    }

    private static class BeanPropertyProposal
    extends AbstractCompletionProposal {
        private IType type;
        private String propName;
        private boolean includeSetter;
        private String typeString;

        public BeanPropertyProposal(IType type, String propName, boolean includeSetter, String typeString) {
            super(String.format("Add bean property %s%s", propName, includeSetter ? " read/write" : " readonly"));
            this.type = type;
            this.propName = propName;
            this.includeSetter = includeSetter;
            this.typeString = typeString != null ? typeString : "java.lang.Object";
        }

        @Override
        public void apply(org.eclipse.jface.text.IDocument document) {
            try {
                this.type.createField(String.format("private %s %s;", this.typeString, this.propName), null, false, null);
                IMethod getterMethod = this.type.createMethod(String.format("public %s get%s%s() { return this.%s; }", this.typeString, String.valueOf(Character.toUpperCase(this.propName.charAt(0))), this.propName.substring(1), this.propName), null, false, null);
                if (this.includeSetter) {
                    this.type.createMethod(String.format("public void set%s%s(%s %s) { this.%s = %s; }", String.valueOf(Character.toUpperCase(this.propName.charAt(0))), this.propName.substring(1), this.typeString, this.propName, this.propName, this.propName), null, false, null);
                }
                IEditorPart editor = JavaUI.openInEditor((IJavaElement)getterMethod);
                FaceletQuickAssistProcessor.formatJava(this.type.getJavaProject().getProject(), getterMethod, editor);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    private static class PrefixCompletionProposal
    implements ICompletionProposal {
        private final IDOMElement targetElement;
        private final String prefix;
        private final String ns;
        private Attr newAttr;

        public PrefixCompletionProposal(IDOMElement targetElement, String prefix, String ns) {
            this.targetElement = targetElement;
            this.prefix = prefix;
            this.ns = ns;
        }

        public boolean isPreferred() {
            if ("f".equals(this.prefix)) {
                return "http://java.sun.com/jsf/core".equals(this.ns);
            }
            if ("h".equals(this.prefix)) {
                return "http://java.sun.com/jsf/html".equals(this.ns);
            }
            if ("ui".equals(this.prefix)) {
                return "http://java.sun.com/jsf/facelets".equals(this.ns);
            }
            if ("af".equals(this.prefix)) {
                return "http://xmlns.oracle.com/adf/faces/rich".equals(this.ns);
            }
            if ("c".equals(this.prefix)) {
                return "http://java.sun.com/jsp/jstl/core".equals(this.ns);
            }
            if ("fn".equals(this.prefix)) {
                return "http://java.sun.com/jsp/jstl/functions".equals(this.ns);
            }
            return false;
        }

        public void apply(org.eclipse.jface.text.IDocument document) {
            String attrName = String.format("xmlns:%s", this.prefix);
            this.targetElement.setAttribute(attrName, this.ns);
            this.newAttr = this.targetElement.getAttributeNode(attrName);
        }

        public Point getSelection(org.eclipse.jface.text.IDocument document) {
            if (this.newAttr instanceof IDOMAttr) {
                return new Point(((IDOMAttr)this.newAttr).getStartOffset(), ((IDOMAttr)this.newAttr).getLength());
            }
            return null;
        }

        public String getAdditionalProposalInfo() {
            return String.format("Add new prefix %s the refers to library namespace %s", this.prefix, this.ns);
        }

        public String getDisplayString() {
            return String.format("Add namespace %s", this.ns);
        }

        public Image getImage() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }
    }

    public static class UriToMapBeanCompletionProposals
    implements ICompletionProposal {
        private final ResourceLocation variableDeclLocation;
        private final Attr node;
        private final String varName;

        public UriToMapBeanCompletionProposals(Attr node, Variable var) {
            this.varName = var.getName();
            this.variableDeclLocation = var.getDefinitionLocation();
            this.node = node;
        }

        public void apply(org.eclipse.jface.text.IDocument document) {
            String uri = this.node.getValue();
            String fieldName = new Path(uri).lastSegment().replace('.', '_');
            this.addMapEntry(fieldName, uri);
            String elExprStr = String.format("#{%s.%s}", this.varName, fieldName);
            this.node.setNodeValue(elExprStr);
        }

        /*
         * Exception decompiling
         */
        private void addMapEntry(String key, String value) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [30[WHILELOOP]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public Point getSelection(org.eclipse.jface.text.IDocument document) {
            return null;
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public String getDisplayString() {
            return String.format("Refactor uri to bean in %s", this.varName);
        }

        public Image getImage() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }
    }
}

