/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.managedbean;

import oracle.eclipse.tools.webtier.jsf.ui.util.JsfUiUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.ui.wizard.NewManagedBeanWizard;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NewManagedBeanAction
extends Action {
    private IProject project;

    public void run() {
        String facesConfigFilename;
        if (this.project == null) {
            return;
        }
        try {
            facesConfigFilename = JsfUiUtil.getFacesConfigFile(this.project, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        if (facesConfigFilename != null) {
            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            NewManagedBeanWizard wizard = new NewManagedBeanWizard(this.project);
            wizard.setForcePreviousAndNextButtons(true);
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
            wizardDialog.create();
            wizardDialog.setBlockOnOpen(true);
            if (wizardDialog.open() == 0) {
                this.updateFacesConfig(facesConfigFilename, wizard);
            }
        }
    }

    public void selectionChanged(ISelection selection) {
        Object firstSegment;
        TreeSelection treeSelection;
        TreePath[] treePaths;
        if (selection instanceof TreeSelection && (treePaths = (treeSelection = (TreeSelection)selection).getPaths()) != null && treePaths.length > 0 && (firstSegment = treePaths[0].getFirstSegment()) instanceof IProject) {
            this.project = (IProject)firstSegment;
        }
    }

    private void updateFacesConfig(String facesConfigFilename, NewManagedBeanWizard wizard) {
        FacesConfigArtifactEdit facesConfigEdit = null;
        try {
            facesConfigEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)this.project, (String)facesConfigFilename);
            FacesConfigFactory facesConfigFactory = FacesConfigPackage.eINSTANCE.getFacesConfigFactory();
            ManagedBeanType managedBean = facesConfigFactory.createManagedBeanType();
            ManagedBeanNameType name = facesConfigFactory.createManagedBeanNameType();
            name.setTextContent(wizard.getManagedBeanName());
            managedBean.setManagedBeanName(name);
            ManagedBeanClassType clazz = facesConfigFactory.createManagedBeanClassType();
            clazz.setTextContent(wizard.getManagedBeanClass());
            managedBean.setManagedBeanClass(clazz);
            ManagedBeanScopeType scope = facesConfigFactory.createManagedBeanScopeType();
            scope.setTextContent(wizard.getManagedBeanScope());
            managedBean.setManagedBeanScope(scope);
            String userDescription = wizard.getManagedBeanDescription();
            if (userDescription != null && userDescription.trim().length() > 0) {
                DescriptionType description = facesConfigFactory.createDescriptionType();
                description.setTextContent(wizard.getManagedBeanDescription());
                managedBean.getDescription().add((Object)description);
            }
            facesConfigEdit.getFacesConfig().getManagedBean().add((Object)managedBean);
            JsfUiUtil.save(facesConfigEdit);
        }
        finally {
            if (facesConfigEdit != null) {
                facesConfigEdit.dispose();
                assert (facesConfigEdit.isDisposed());
                facesConfigEdit = null;
            }
        }
    }
}

