/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.converter;

import java.util.List;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.jsf.ui.Messages;
import oracle.eclipse.tools.webtier.jsf.ui.internal.Activator;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.validation.internal.appconfig.AppConfigValidationUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class NewConverterDialog
extends SelectionStatusDialog {
    private static final String REGISTRATION_TYPE = "REGISTRATION_TYPE";
    private static final String ID = "ID";
    private static final String CLASS = "CLASS";
    private final Shell shell;
    private final IProject project;
    private final ConverterType converter;
    private final List<String> existingConverterIds;
    private final List<String> existingConvertersForClass;
    private DataBindingContext dataBindingContext;
    private Binding converterIdBinding;
    private Binding converterForClassBinding;
    private Binding implementationClassForConverterIdBinding;
    private Binding implementationClassForConverterClassBinding;
    private final UpdateValueStrategy updateValueStrategyForRegistrationById;
    private final UpdateValueStrategy updateValueStrategyForRegistrationByClass;
    private Text converterIdText;
    private Text implementationClassText;
    private Text descriptionText;
    private static final IStatus OK_STATUS = new Status(0, "oracle.eclipse.tools.webtier.jsf.ui", "");
    private static final IStatus ERROR_STATUS = new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", "");
    private static final IStatus CONVERTER_ID_EMPTY_STATUS = new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", Messages.NewConverterDialog_ConverterIdCannotBeBlank);
    private static final IStatus CLASS_TO_CONVERT_EMPTY_STATUS = new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", Messages.NewConverterDialog_ConverterForClassCannotBeBlank);
    private static final IStatus DUPLICATE_CONVERTER_ID_STATUS = new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", Messages.NewConverterDialog_ConverterIdExists);
    private static final IStatus DUPLICATE_CLASS_TO_CONVERT_STATUS = new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", Messages.NewConverterDialog_ConverterForClassExists);
    private static final IStatus IMPLEMENTATION_CLASS_NAME_EMPTY_STATUS = new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", Messages.NewConverterDialog_ImplementationClassCannotBeBlank);
    private static final IStatus IMPLEMENTATION_CLASS_NAME_NOT_CONVERTER_STATUS = new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", Messages.NewConverterDialog_ImplementationClassMustImplementConverter);
    private static final String HELPID = "oracle.eclipse.tools.webtier.jsf.ui.NewConverterDialog";

    public NewConverterDialog(Shell shell, IProject project, ConverterType converterModel, List<String> existingConverterIds, List<String> existingConvertersForClass) {
        super(shell);
        this.shell = shell;
        this.project = project;
        this.converter = converterModel;
        this.existingConverterIds = existingConverterIds;
        this.existingConvertersForClass = existingConvertersForClass;
        this.updateValueStrategyForRegistrationById = new UpdateValueStrategy();
        this.updateValueStrategyForRegistrationById.setAfterConvertValidator((IValidator)new ViewDataValidatorForRegistrationById());
        this.updateValueStrategyForRegistrationByClass = new UpdateValueStrategy();
        this.updateValueStrategyForRegistrationByClass.setAfterConvertValidator((IValidator)new ViewDataValidatorForRegistrationByClass());
        this.setTitle(Messages.NewConverterDialog_NewConverterDialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Layout layout = composite.getLayout();
        if (layout instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout;
            gridLayout.marginWidth = 14;
            gridLayout.marginHeight = 0;
            gridLayout.marginTop = 14;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
        }
        Composite localParent = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 8;
        gridLayout.verticalSpacing = 8;
        localParent.setLayout((Layout)gridLayout);
        localParent.setLayoutData((Object)new GridData(4, 4, true, false));
        Label registrationLabel = new Label(localParent, 0);
        registrationLabel.setText(Messages.NewConverterDialog_RegistrationLabel);
        Composite registrationComposite = new Composite(localParent, 0);
        GridLayout registrationCompositeLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 8;
        gridLayout.verticalSpacing = 8;
        GridData registrationCompositeGridData = new GridData(4, 4, true, false, 2, 1);
        registrationCompositeGridData.minimumWidth = 265;
        registrationComposite.setLayoutData((Object)registrationCompositeGridData);
        registrationComposite.setLayout((Layout)registrationCompositeLayout);
        Composite registrationRadioButtonsComposite = new Composite(registrationComposite, 0);
        registrationRadioButtonsComposite.setLayout((Layout)new FillLayout());
        Button registrationByIdRadioButton = new Button(registrationRadioButtonsComposite, 16);
        registrationByIdRadioButton.setText(Messages.NewConverterDialog_RegistrationByIdLabel);
        registrationByIdRadioButton.setData(REGISTRATION_TYPE, (Object)ID);
        Button registrationByClassRadioButton = new Button(registrationRadioButtonsComposite, 16);
        registrationByClassRadioButton.setText(Messages.NewConverterDialog_RegistrationByClassLabel);
        registrationByClassRadioButton.setData(REGISTRATION_TYPE, (Object)CLASS);
        final Label registrationIdLabel = new Label(localParent, 0);
        registrationIdLabel.setText(Messages.NewConverterDialog_ConverterIdLabel);
        GridData registrationIdLabelGridData = new GridData();
        registrationIdLabel.setLayoutData((Object)registrationIdLabelGridData);
        this.converterIdText = new Text(localParent, 2052);
        GridData registrationTextLayoutData = new GridData(4, 0x1000000, true, false);
        registrationTextLayoutData.minimumWidth = 265;
        this.converterIdText.setLayoutData((Object)registrationTextLayoutData);
        ToolBar converterClassBrowserButtonToolBar = this.getToolBar(localParent, 256);
        final ToolItem converterClassBrowserButton = new ToolItem(converterClassBrowserButtonToolBar, 8);
        converterClassBrowserButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
        converterClassBrowserButton.setToolTipText(Messages.NewConverterDialog_ClassBrowserTooltipText);
        converterClassBrowserButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent se) {
                this.widgetSelected(se);
            }

            public void widgetSelected(SelectionEvent se) {
                NewConverterDialog.this.classBrowserButtonClicked();
            }
        });
        Listener radioButtonListener = new Listener(){

            public void handleEvent(Event event) {
                Button button = (Button)event.widget;
                String selectedButtonValue = (String)button.getData(NewConverterDialog.REGISTRATION_TYPE);
                if (button.getSelection() && selectedButtonValue != null) {
                    if (selectedButtonValue.equals(NewConverterDialog.ID)) {
                        converterClassBrowserButton.getParent().setVisible(false);
                        registrationIdLabel.setText(Messages.NewConverterDialog_ConverterIdLabel);
                        registrationIdLabel.pack();
                        NewConverterDialog.this.bindConverterId();
                    } else {
                        converterClassBrowserButton.getParent().setVisible(true);
                        registrationIdLabel.setText(Messages.NewConverterDialog_ClassToConvertLabel);
                        registrationIdLabel.pack();
                        NewConverterDialog.this.bindConverterForClass();
                    }
                }
            }
        };
        registrationByIdRadioButton.addListener(13, radioButtonListener);
        registrationByClassRadioButton.addListener(13, radioButtonListener);
        Label implementationClassLabel1 = new Label(localParent, 0);
        implementationClassLabel1.setText(Messages.NewConverterDialog_ImplementationClassLabel);
        this.implementationClassText = new Text(localParent, 2052);
        GridData implementationClassTextGridData1 = new GridData(4, 0x1000000, true, false);
        implementationClassTextGridData1.minimumWidth = 265;
        this.implementationClassText.setLayoutData((Object)implementationClassTextGridData1);
        ToolBar implementationClassBrowserButtonToolBar = this.getToolBar(localParent, 256);
        ToolItem selectClassButton11 = new ToolItem(implementationClassBrowserButtonToolBar, 8);
        selectClassButton11.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
        selectClassButton11.setToolTipText(Messages.NewConverterDialog_ClassBrowserTooltipText);
        selectClassButton11.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent se) {
                this.widgetSelected(se);
            }

            public void widgetSelected(SelectionEvent se) {
                NewConverterDialog.this.implementationClassBrowserButtonClicked();
            }
        });
        Label descriptionLabel = new Label(localParent, 0);
        descriptionLabel.setText(Messages.JSFConfigAddNavigationCaseDialog_descLabel);
        descriptionLabel.setLayoutData((Object)new GridData(4, 1, false, false));
        this.descriptionText = new Text(localParent, 2626);
        GridData descTextGridData = new GridData(4, 1, true, false);
        descTextGridData.heightHint = 40;
        descTextGridData.minimumWidth = 265;
        this.descriptionText.setLayoutData((Object)descTextGridData);
        this.bindData();
        this.setStatusLineAboveButtons(true);
        this.disableOkButton();
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, HELPID);
    }

    private void disableOkButton() {
        this.updateStatus(ERROR_STATUS);
    }

    private ToolBar getToolBar(Composite parent, int style) {
        ToolBar toolBar = new ToolBar(parent, 0x800000 | style);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        toolBar.setLayout((Layout)gridLayout);
        int alignStyle = 0x1000000;
        if ((style | 0x200) == 512) {
            alignStyle = 1;
        }
        GridData gridData = new GridData(alignStyle, alignStyle, false, false);
        toolBar.setLayoutData((Object)gridData);
        return toolBar;
    }

    private void classBrowserButtonClicked() {
        try {
            SelectionDialog classBrowserDialog = this.createClassBrowserDialog(Messages.NewConverterDialog_SelectClassToConvertDialogTitle, Messages.NewConverterDialog_SelectConverterClassDialogMessage);
            switch (classBrowserDialog.open()) {
                case 0: {
                    Object selectedClass = classBrowserDialog.getResult()[0];
                    if (selectedClass == null) {
                        return;
                    }
                    String fullyQualifiedClassName = ((IType)selectedClass).getFullyQualifiedName('.');
                    this.converterIdText.setText(fullyQualifiedClassName);
                }
            }
        }
        catch (JavaModelException e) {
            LoggingService.logError((Plugin)Activator.getDefault(), (String)e.getLocalizedMessage());
        }
    }

    private SelectionDialog createClassBrowserDialog(String title, String message) throws JavaModelException {
        SelectionDialog classBrowserDialog = JavaUI.createTypeDialog((Shell)this.shell, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IProject)this.project, (int)2, (boolean)false);
        classBrowserDialog.setTitle(title);
        classBrowserDialog.setMessage(message);
        return classBrowserDialog;
    }

    private void implementationClassBrowserButtonClicked() {
        try {
            SelectionDialog classBrowserDialog = this.createClassBrowserDialog(Messages.NewConverterDialog_SelectConverterClassDialogTitle, Messages.NewConverterDialog_SelectAConverterClassDialogMessage);
            switch (classBrowserDialog.open()) {
                case 0: {
                    Object selectedClass = classBrowserDialog.getResult()[0];
                    if (selectedClass == null) {
                        return;
                    }
                    String fullyQualifiedClassName = ((IType)selectedClass).getFullyQualifiedName('.');
                    this.implementationClassText.setText(fullyQualifiedClassName);
                }
            }
        }
        catch (JavaModelException e) {
            LoggingService.logError((Plugin)Activator.getDefault(), (String)e.getLocalizedMessage());
        }
    }

    private void bindData() {
        this.dataBindingContext = new DataBindingContext();
        this.bindConverterId();
        this.dataBindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.descriptionText), EMFObservables.observeValue((EObject)((DescriptionType)this.converter.getDescription().get(0)), (EStructuralFeature)FacesConfigPackage.eINSTANCE.getDescriptionType_TextContent()), new UpdateValueStrategy(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        this.dataBindingContext.updateTargets();
    }

    private void bindConverterId() {
        if (this.converterForClassBinding != null) {
            this.converterForClassBinding.dispose();
            this.converterForClassBinding = null;
        }
        if (this.implementationClassForConverterClassBinding != null) {
            this.implementationClassForConverterClassBinding.dispose();
            this.implementationClassForConverterClassBinding = null;
        }
        if (this.converterIdBinding == null) {
            this.converterIdBinding = this.dataBindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.converterIdText, (int)24), EMFObservables.observeValue((EObject)this.converter.getConverterId(), (EStructuralFeature)FacesConfigPackage.eINSTANCE.getConverterIdType_TextContent()), this.updateValueStrategyForRegistrationById, new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        }
        if (this.implementationClassForConverterIdBinding == null) {
            this.implementationClassForConverterIdBinding = this.dataBindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.implementationClassText, (int)24), EMFObservables.observeValue((EObject)this.converter.getConverterClass(), (EStructuralFeature)FacesConfigPackage.eINSTANCE.getConverterClassType_TextContent()), this.updateValueStrategyForRegistrationById, new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        }
    }

    private void bindConverterForClass() {
        if (this.converterIdBinding != null) {
            this.converterIdBinding.dispose();
            this.converterIdBinding = null;
        }
        if (this.implementationClassForConverterIdBinding != null) {
            this.implementationClassForConverterIdBinding.dispose();
            this.implementationClassForConverterIdBinding = null;
        }
        if (this.converterForClassBinding == null) {
            this.converterForClassBinding = this.dataBindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.converterIdText, (int)24), EMFObservables.observeValue((EObject)this.converter.getConverterForClass(), (EStructuralFeature)FacesConfigPackage.eINSTANCE.getConverterForClassType_TextContent()), this.updateValueStrategyForRegistrationByClass, new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        }
        if (this.implementationClassForConverterClassBinding == null) {
            this.implementationClassForConverterClassBinding = this.dataBindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.implementationClassText, (int)24), EMFObservables.observeValue((EObject)this.converter.getConverterClass(), (EStructuralFeature)FacesConfigPackage.eINSTANCE.getConverterClassType_TextContent()), this.updateValueStrategyForRegistrationByClass, new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        }
    }

    protected void computeResult() {
        this.dataBindingContext.updateModels();
    }

    private boolean isValidConverterId() {
        String converterId = this.converterIdText.getText().trim();
        if (converterId.length() == 0) {
            this.updateStatus(CONVERTER_ID_EMPTY_STATUS);
            return false;
        }
        if (this.existingConverterIds.contains(converterId)) {
            this.updateStatus(DUPLICATE_CONVERTER_ID_STATUS);
            return false;
        }
        return true;
    }

    private boolean isValidConverterForClass() {
        String converterForClass = this.converterIdText.getText().trim();
        if (converterForClass.length() == 0) {
            this.updateStatus(CLASS_TO_CONVERT_EMPTY_STATUS);
            return false;
        }
        if (this.existingConvertersForClass.contains(converterForClass)) {
            this.updateStatus(DUPLICATE_CLASS_TO_CONVERT_STATUS);
            return false;
        }
        IMessage classValidationErrorMessage = AppConfigValidationUtil.validateClassName((String)converterForClass, null, (boolean)true, (IProject)this.project);
        if (classValidationErrorMessage != null) {
            this.updateStatus((IStatus)new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", classValidationErrorMessage.getText()));
            return false;
        }
        return true;
    }

    private boolean isValidImplementationClass() {
        String implementationClassName = this.implementationClassText.getText().trim();
        if (implementationClassName.length() == 0) {
            this.updateStatus(IMPLEMENTATION_CLASS_NAME_EMPTY_STATUS);
            return false;
        }
        IMessage classNameValidationErrorMessage = AppConfigValidationUtil.validateClassName((String)implementationClassName, null, (boolean)true, (IProject)this.project);
        if (classNameValidationErrorMessage != null) {
            this.updateStatus((IStatus)new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", classNameValidationErrorMessage.getText()));
            return false;
        }
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        IType type = null;
        try {
            type = javaProject.findType(implementationClassName);
            if (type != null && !AppConfigValidationUtil.isInstanceOf((IType)type, (String)"javax.faces.convert.Converter")) {
                this.updateStatus(IMPLEMENTATION_CLASS_NAME_NOT_CONVERTER_STATUS);
                return false;
            }
        }
        catch (JavaModelException jme) {
            LoggingService.logError((Plugin)Activator.getDefault(), (String)jme.getLocalizedMessage());
        }
        return true;
    }

    private class ViewDataValidatorForRegistrationByClass
    implements IValidator {
        private ViewDataValidatorForRegistrationByClass() {
        }

        public IStatus validate(Object value) {
            if (!NewConverterDialog.this.isValidConverterForClass()) {
                return ERROR_STATUS;
            }
            if (!NewConverterDialog.this.isValidImplementationClass()) {
                return ERROR_STATUS;
            }
            NewConverterDialog.this.updateStatus(OK_STATUS);
            return OK_STATUS;
        }
    }

    private class ViewDataValidatorForRegistrationById
    implements IValidator {
        private ViewDataValidatorForRegistrationById() {
        }

        public IStatus validate(Object value) {
            if (!NewConverterDialog.this.isValidConverterId()) {
                return ERROR_STATUS;
            }
            if (!NewConverterDialog.this.isValidImplementationClass()) {
                return ERROR_STATUS;
            }
            NewConverterDialog.this.updateStatus(OK_STATUS);
            return OK_STATUS;
        }
    }
}

