/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import oracle.eclipse.tools.application.common.services.appservices.IWebRootResolver;
import oracle.eclipse.tools.common.ui.wizards.NewFileWizard;
import oracle.eclipse.tools.common.ui.wizards.NewFileWizardPage;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.util.wtp.webxml.WebXmlUpdater;
import oracle.eclipse.tools.webtier.common.services.util.FacetUtil;
import oracle.eclipse.tools.webtier.jsf.Activator;
import oracle.eclipse.tools.webtier.jsf.JsfUtil;
import oracle.eclipse.tools.webtier.jsf.ui.Messages;
import oracle.eclipse.tools.webtier.jsf.ui.config.NewJsfConfigFileWizardPage;
import oracle.eclipse.tools.webtier.ui.internal.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.common.componentcore.ComponentCore;

public class JsfConfigFileWizard
extends NewFileWizard {
    private static final Activator PLUGIN_CONTAINING_JSF_TEMPLATES = Activator.getDefault();
    private static final String FACES_CONFIG_XML_RELATIVE_PATH_FOR_J2EE = "templates/new-app/web-app_1.1/web/WEB-INF/faces-config.xml";
    private static final String FACES_CONFIG_XML_RELATIVE_PATH_FOR_JAVAEE_1_2 = "templates/new-app/web-app_1.2/web/WEB-INF/faces-config.xml";
    private static final String FACES_CONFIG_XML_RELATIVE_PATH_FOR_JAVAEE_2_0 = "templates/new-app/web-app_2.0/web/WEB-INF/faces-config.xml";
    private static final String FACES_CONFIG_XML_RELATIVE_PATH_FOR_JAVAEE_2_1 = "templates/new-app/web-app_2.1/web/WEB-INF/faces-config.xml";
    private static final String FACES_CONFIG_XML_RELATIVE_PATH_FOR_JAVAEE_2_2 = "templates/new-app/web-app_2.2/web/WEB-INF/faces-config.xml";
    private static final String CONTEXT_PARAM_NAME_FOR_CONFIG_FILES = "javax.faces.CONFIG_FILES";
    private IProject _project;
    private NewJsfConfigFileWizardPage _page;

    public JsfConfigFileWizard() {
        this.setWindowTitle(Messages.JsfConfigFileWizard_WindowTitle);
        this.setDefaultPageImageDescriptor(Activator.Images.NEW_PROJECT_WIZARD_BANNER.getImageDescriptor());
        this.setNeedsProgressMonitor(true);
    }

    public JsfConfigFileWizard(IProject project) {
        this();
        this._project = project;
        this.setInitialContainerFullPath(this.getWebContentWEBINFFolder());
    }

    protected NewFileWizardPage createFilePage() {
        this._page = new NewJsfConfigFileWizardPage("FilePage", this.getSelection());
        this._page.setTitle(Messages.JsfConfigFileWizard_NewFileWizardPageTitle);
        this._page.setDescription(Messages.JsfConfigFileWizard_NewFileWizardPageDescription);
        return this._page;
    }

    private IPath getWebContentWEBINFFolder() {
        IFolder webContentFolder = (IFolder)ComponentCore.createComponent((IProject)this._project).getRootFolder().getUnderlyingFolder();
        if (webContentFolder != null) {
            return webContentFolder.getFullPath().append((IPath)new Path("WEB-INF"));
        }
        return this._project.getFullPath();
    }

    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        IFile facesConfigFile = this.getFile();
        if (facesConfigFile == null) {
            throw new IllegalArgumentException("Cannot read selected file.");
        }
        IProject project = facesConfigFile.getProject();
        if (project == null) {
            throw new IllegalArgumentException("Invalid project.");
        }
        try {
            File facesConfigTemplateFile = FacetUtil.getFileFromPlugin((Plugin)PLUGIN_CONTAINING_JSF_TEMPLATES, (String)this.getFacesConfigTemplateFilePath());
            facesConfigFile.setContents((InputStream)new FileInputStream(facesConfigTemplateFile), 1, null);
            IResource root = IWebRootResolver.Util.getRoot((IProject)project);
            if (root != null) {
                IPath contextRoot = root.getRawLocation();
                String facesConfigContextRelativePath = "/" + facesConfigFile.getLocation().makeRelativeTo(contextRoot).toString();
                WebXmlUpdater webXmlUpdater = new WebXmlUpdater(project, (IProgressMonitor)new NullProgressMonitor());
                webXmlUpdater.addCommaSeparatedValueToContextParam(CONTEXT_PARAM_NAME_FOR_CONFIG_FILES, facesConfigContextRelativePath);
            }
        }
        catch (IOException e) {
            LoggingService.logError((Plugin)oracle.eclipse.tools.webtier.jsf.ui.internal.Activator.getDefault(), (String)e.getLocalizedMessage());
        }
        catch (URISyntaxException e) {
            LoggingService.logError((Plugin)oracle.eclipse.tools.webtier.jsf.ui.internal.Activator.getDefault(), (String)e.getLocalizedMessage());
        }
        catch (CoreException e) {
            LoggingService.logError((Plugin)oracle.eclipse.tools.webtier.jsf.ui.internal.Activator.getDefault(), (String)e.getLocalizedMessage());
        }
        return true;
    }

    private String getFacesConfigTemplateFilePath() {
        String jsfVersion = JsfUtil.getJsfTechExtensionVersion((IProject)this.getFile().getProject());
        if (jsfVersion == null) {
            throw new IllegalArgumentException("Not a JSF project. Was expecting a JSF project");
        }
        if (jsfVersion.equalsIgnoreCase("1.1")) {
            return FACES_CONFIG_XML_RELATIVE_PATH_FOR_J2EE;
        }
        if (jsfVersion.equalsIgnoreCase("1.2")) {
            return FACES_CONFIG_XML_RELATIVE_PATH_FOR_JAVAEE_1_2;
        }
        if (jsfVersion.equalsIgnoreCase("2.0")) {
            return FACES_CONFIG_XML_RELATIVE_PATH_FOR_JAVAEE_2_0;
        }
        if (jsfVersion.equalsIgnoreCase("2.1")) {
            return FACES_CONFIG_XML_RELATIVE_PATH_FOR_JAVAEE_2_1;
        }
        if (jsfVersion.equalsIgnoreCase("2.2")) {
            return FACES_CONFIG_XML_RELATIVE_PATH_FOR_JAVAEE_2_2;
        }
        throw new IllegalArgumentException("Cannot determine version of JSF tech extension in project");
    }
}

