/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.config;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.webtier.jsf.ui.Messages;
import oracle.eclipse.tools.webtier.jsf.ui.util.JsfUiUtil;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FromOutcomeType;
import org.eclipse.jst.jsf.facesconfig.emf.FromViewIdType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.properties.ActionOutcomeSelectionDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class JSFConfigAddNavigationCaseDialog
extends SelectionStatusDialog {
    private static IStatus STATUS_OK = new Status(0, "oracle.eclipse.tools.webtier.ui", " ");
    private static IStatus STATUS_EXISTING_FROMOUTCOME = new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.JSFConfigAddNavigationCaseDialog_status_duplicateFromOutcome);
    private static IStatus STATUS_EMPTY_DESTPAGE = new Status(4, "oracle.eclipse.tools.webtier.ui", Messages.JSFConfigAddNavigationCaseDialog_status_emptyDestPage);
    private static final String HELPID = "oracle.eclipse.tools.webtier.ui.AddNavigationCaseDialog";
    private IProject iProject;
    private NavigationCaseType navigationCase;
    private NavigationRuleType navigationRule;
    private List<String> existingFromOutcomes;
    private List<String> allowableExistingFromOutcomes;
    private Text outcomeText;
    private Text destPageText;
    private Text descText;
    private DataBindingContext dataBindContext;
    private Binding outcomeBinding;
    private Binding destPageBinding;
    private Binding descBinding;

    public JSFConfigAddNavigationCaseDialog(Shell parent, IProject iProject, NavigationCaseType navigationCase, NavigationRuleType navigationRule, List<String> allowableExistingFromOutcomes) {
        super(parent);
        this.iProject = iProject;
        this.navigationCase = navigationCase;
        this.navigationRule = navigationRule;
        this.allowableExistingFromOutcomes = allowableExistingFromOutcomes != null ? allowableExistingFromOutcomes : new ArrayList<String>();
        this.setTitle(Messages.JSFConfigAddNavigationCaseDialog_title);
        this.getExistingFromOutcomes();
    }

    public JSFConfigAddNavigationCaseDialog(Shell parent, IProject iProject, NavigationCaseType navigationCase, NavigationRuleType navigationRule) {
        this(parent, iProject, navigationCase, navigationRule, null);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Layout layout = composite.getLayout();
        if (layout instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout;
            gridLayout.marginWidth = 14;
            gridLayout.marginHeight = 0;
            gridLayout.marginTop = 14;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
        }
        Composite localParent = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 8;
        gridLayout.verticalSpacing = 8;
        localParent.setLayout((Layout)gridLayout);
        localParent.setLayoutData((Object)new GridData(4, 4, true, true));
        Label outcomeLabel = new Label(localParent, 0);
        outcomeLabel.setText(Messages.JSFConfigAddNavigationCaseDialog_outcomeLabel);
        this.outcomeText = new Text(localParent, 2052);
        GridData outcomeTextGridData = new GridData(4, 0x1000000, true, false);
        outcomeTextGridData.minimumWidth = 265;
        this.outcomeText.setLayoutData((Object)outcomeTextGridData);
        this.outcomeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                JSFConfigAddNavigationCaseDialog.this.validate();
            }
        });
        ToolBar outcomeButtonToolbar = this.getToolBar(localParent, 256);
        ToolItem selectOutcomeButton = new ToolItem(outcomeButtonToolbar, 8);
        selectOutcomeButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
        selectOutcomeButton.setToolTipText(Messages.JSFConfigAddNavigationCaseDialog_selectOutcomeButton_tooltip);
        selectOutcomeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent se) {
                this.widgetSelected(se);
            }

            public void widgetSelected(SelectionEvent se) {
                JSFConfigAddNavigationCaseDialog.this.handleSelectOutcomeButtonSelected();
            }
        });
        Label destPageLabel = new Label(localParent, 0);
        destPageLabel.setText(Messages.JSFConfigAddNavigationCaseDialog_destPageLabel);
        this.destPageText = new Text(localParent, 2052);
        GridData destPageTextGridData = new GridData(4, 0x1000000, true, false);
        destPageTextGridData.minimumWidth = 265;
        this.destPageText.setLayoutData((Object)destPageTextGridData);
        this.destPageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                JSFConfigAddNavigationCaseDialog.this.validate();
            }
        });
        ToolBar destPageButtonToolBar = this.getToolBar(localParent, 256);
        ToolItem selectPageButton = new ToolItem(destPageButtonToolBar, 8);
        selectPageButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
        selectPageButton.setToolTipText(Messages.JSFConfigAddNavigationCaseDialog_selectPageButton_tooltip);
        selectPageButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent se) {
                this.widgetSelected(se);
            }

            public void widgetSelected(SelectionEvent se) {
                JSFConfigAddNavigationCaseDialog.this.handleSelectPageButtonSelected();
            }
        });
        Label descLabel = new Label(localParent, 0);
        descLabel.setText(Messages.JSFConfigAddNavigationCaseDialog_descLabel);
        GridData descLabelGridData = new GridData(4, 1, false, false);
        descLabel.setLayoutData((Object)descLabelGridData);
        this.descText = new Text(localParent, 2626);
        GridData descTextGridData = new GridData(4, 1, true, false);
        descTextGridData.heightHint = 40;
        descTextGridData.minimumWidth = 265;
        this.descText.setLayoutData((Object)descTextGridData);
        this.dataBindContext = new DataBindingContext();
        this.bindData();
        this.setStatusLineAboveButtons(true);
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, HELPID);
    }

    private ToolBar getToolBar(Composite parent, int style) {
        ToolBar toolBar = new ToolBar(parent, 0x800000 | style);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        toolBar.setLayout((Layout)gridLayout);
        int alignStyle = 16384;
        if ((style | 0x200) == 512) {
            alignStyle = 1;
        }
        GridData gridData = new GridData(alignStyle, alignStyle, false, false);
        toolBar.setLayoutData((Object)gridData);
        return toolBar;
    }

    private void validate() {
        IStatus status = STATUS_OK;
        if (this.existingFromOutcomes.contains(this.outcomeText.getText())) {
            status = STATUS_EXISTING_FROMOUTCOME;
        } else if (this.destPageText.getText().isEmpty()) {
            status = STATUS_EMPTY_DESTPAGE;
        }
        this.updateStatus(status);
    }

    private void handleSelectOutcomeButtonSelected() {
        ActionOutcomeSelectionDialog dialog;
        IVirtualResource resource;
        IVirtualFolder webRootFolder;
        IVirtualComponent component;
        String fromViewId;
        FromViewIdType fromViewIdType;
        String jspName = null;
        if (this.navigationRule != null && (fromViewIdType = this.navigationRule.getFromViewId()) != null && (fromViewId = fromViewIdType.getTextContent()) != null && fromViewId.length() > 0 && this.iProject != null && (component = ComponentCore.createComponent((IProject)this.iProject)) != null && (webRootFolder = component.getRootFolder()) != null && (resource = webRootFolder.findMember(fromViewId)) != null) {
            jspName = resource.getWorkspaceRelativePath().toString();
        }
        if ((dialog = new ActionOutcomeSelectionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), this.outcomeText.getText(), jspName)).open() == 0) {
            this.outcomeText.setText(dialog.getSelectedAction());
        }
    }

    private void handleSelectPageButtonSelected() {
        String JSFFile = JsfUiUtil.selectJSFFileFromDialog(this.iProject);
        if (JSFFile != null) {
            this.destPageText.setText(JSFFile);
        }
    }

    private void bindData() {
        FromOutcomeType eObject = this.navigationCase.getFromOutcome();
        EAttribute eStructuralFeature = FacesConfigPackage.eINSTANCE.getFromOutcomeType_TextContent();
        this.outcomeBinding = this.dataBindContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.outcomeText), EMFObservables.observeValue((EObject)eObject, (EStructuralFeature)eStructuralFeature), new UpdateValueStrategy(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        this.outcomeBinding.updateModelToTarget();
        eObject = this.navigationCase.getToViewId();
        eStructuralFeature = FacesConfigPackage.eINSTANCE.getToViewIdType_TextContent();
        this.destPageBinding = this.dataBindContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.destPageText), EMFObservables.observeValue((EObject)eObject, (EStructuralFeature)eStructuralFeature), new UpdateValueStrategy(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        this.destPageBinding.updateModelToTarget();
        eObject = (DescriptionType)this.navigationCase.getDescription().get(0);
        eStructuralFeature = FacesConfigPackage.eINSTANCE.getDescriptionType_TextContent();
        this.descBinding = this.dataBindContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.descText), EMFObservables.observeValue((EObject)eObject, (EStructuralFeature)eStructuralFeature), new UpdateValueStrategy(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        this.descBinding.updateModelToTarget();
    }

    protected void computeResult() {
        this.outcomeBinding.updateTargetToModel();
        this.destPageBinding.updateTargetToModel();
        this.descBinding.updateTargetToModel();
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getOkButton().setEnabled(!this.destPageText.getText().isEmpty());
        return control;
    }

    private void getExistingFromOutcomes() {
        this.existingFromOutcomes = new ArrayList<String>();
        if (this.navigationRule != null) {
            EList navCases = this.navigationRule.getNavigationCase();
            for (Object navCase : navCases) {
                String fromOutcome;
                FromOutcomeType fromOutcomeType;
                if (!(navCase instanceof NavigationCaseType) || (fromOutcomeType = ((NavigationCaseType)navCase).getFromOutcome()) == null || (fromOutcome = fromOutcomeType.getTextContent()) == null || this.allowableExistingFromOutcomes.contains(fromOutcome)) continue;
                this.existingFromOutcomes.add(fromOutcome);
            }
        }
    }
}

