/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.config;

import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationRuleArtifact;
import oracle.eclipse.tools.webtier.jsf.ui.config.JSFConfigAddNavigationCaseDialog;
import oracle.eclipse.tools.webtier.jsf.ui.config.JSFConfigAddNavigationRuleDialog;
import oracle.eclipse.tools.webtier.jsf.ui.util.JsfUiUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.FromOutcomeType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.emf.ToViewIdType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.ui.PlatformUI;

public class JSFConfigAddNavigationCaseAction
extends Action {
    private NavigationRuleArtifact artifact;

    public void run() {
        if (this.artifact != null) {
            FacesConfigArtifactEdit fcArtifactEdit = null;
            try {
                NavigationRuleType navRule;
                fcArtifactEdit = JsfUiUtil.getFacesConfigArtifactEdit((IArtifact)this.artifact, 1);
                if (fcArtifactEdit != null && (navRule = JsfUiUtil.getNavigationRule(fcArtifactEdit, (IArtifact)this.artifact)) != null) {
                    NavigationCaseType navCase = JSFConfigAddNavigationRuleDialog.createNavigationCase();
                    int dialogReturn = new JSFConfigAddNavigationCaseDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), this.artifact.getProject(), navCase, navRule).open();
                    if (dialogReturn == 0 && this.sanitizeNavigationCase(navCase)) {
                        navRule.getNavigationCase().add((Object)navCase);
                        JsfUiUtil.save(fcArtifactEdit);
                    }
                }
            }
            finally {
                if (fcArtifactEdit != null) {
                    fcArtifactEdit.dispose();
                }
            }
        }
    }

    public void selectionChanged(ISelection selection) {
        TreeSelection treeSelection;
        TreePath[] treePaths;
        boolean setEnabled = false;
        if (selection instanceof TreeSelection && (treePaths = (treeSelection = (TreeSelection)selection).getPaths()) != null && treePaths.length > 0) {
            int i = 0;
            while (i < treePaths[0].getSegmentCount()) {
                Object segment = treePaths[0].getSegment(i);
                if (segment instanceof NavigationRuleArtifact) {
                    this.artifact = (NavigationRuleArtifact)segment;
                    setEnabled = true;
                    break;
                }
                ++i;
            }
        }
        this.setEnabled(setEnabled);
    }

    private boolean sanitizeNavigationCase(NavigationCaseType navigationCase) {
        boolean isStillValid = false;
        if (navigationCase != null) {
            DescriptionType descriptionType;
            EList descriptionTypes;
            ToViewIdType toViewIdType;
            FromOutcomeType fromOutcomeType = navigationCase.getFromOutcome();
            if (fromOutcomeType != null) {
                String fromOutcome = fromOutcomeType.getTextContent();
                if (fromOutcome == null || fromOutcome.trim().isEmpty()) {
                    navigationCase.setFromOutcome(null);
                } else {
                    isStillValid = true;
                }
            }
            if ((toViewIdType = navigationCase.getToViewId()) != null) {
                String toViewId = toViewIdType.getTextContent();
                if (toViewId == null || toViewId.trim().isEmpty()) {
                    navigationCase.setToViewId(null);
                } else {
                    isStillValid = true;
                }
            }
            if ((descriptionTypes = navigationCase.getDescription()) != null && !descriptionTypes.isEmpty() && (descriptionType = (DescriptionType)descriptionTypes.get(0)) != null) {
                String description = descriptionType.getTextContent();
                if (description == null || description.trim().isEmpty()) {
                    descriptionTypes.remove(descriptionType);
                } else {
                    isStillValid = true;
                }
            }
        }
        return isStillValid;
    }
}

