/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.taskflow;

import java.util.Map;
import oracle.eclipse.tools.adf.controller.model.TaskFlowType;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import oracle.eclipse.tools.adf.debugger.AdfDebugModel;
import oracle.eclipse.tools.adf.debugger.taskflow.IActivityBreakpoint;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaMethodBreakpoint;

public class ActivityBreakpoint
extends JavaMethodBreakpoint
implements IActivityBreakpoint {
    public static final String ADF_TASKFLOW_BREAKPOINT_MARKER = "oracle.eclipse.tools.adf.debugger.taskflowMarker";
    public static final String TASKFLOW_NAME = "oracle.eclipse.tools.adf.debugger.taskflow.taskflowname";
    public static final String ACTIVITY_ID = "oracle.eclipse.tools.adf.debugger.taskflow.activityid";
    private static final String TEMPLATE_NAME = "oracle.eclipse.tools.adf.debugger.taskflow.templateName";
    private String taskflowName = null;
    private String activityId = null;
    private String templateName = null;
    private static final String GET_TASKFLOW_ID = ".getTaskFlowId()";

    public ActivityBreakpoint() {
    }

    public ActivityBreakpoint(final IResource resource, final String taskflowName, final String activityId, final boolean register, final Map attributes) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker(ActivityBreakpoint.ADF_TASKFLOW_BREAKPOINT_MARKER);
                ActivityBreakpoint.this.setMarker(marker);
                int lineNumber = -1;
                int charStart = 10268;
                int charEnd = 10290;
                ActivityBreakpoint.this.addLineBreakpointAttributes(attributes, ActivityBreakpoint.this.getModelIdentifier(), true, lineNumber, charStart, charEnd);
                ActivityBreakpoint.this.addTypeNameAndHitCount(attributes, "oracle.adfinternal.controller.debug.ActivityBreakpointFacadeImpl", 0);
                ActivityBreakpoint.this.addMethodNameAndSignature(attributes, "markActivityBreakpoint", "(Loracle/adfinternal/controller/debug/ActivityBreakpointDetail;)V");
                attributes.put("org.eclipse.jdt.debug.core.entry", true);
                attributes.put("org.eclipse.jdt.debug.core.exit", false);
                attributes.put("org.eclipse.jdt.debug.core.native", false);
                attributes.put("org.eclipse.jdt.debug.core.suspendPolicy", new Integer(ActivityBreakpoint.this.getDefaultSuspendPolicy()));
                attributes.put(ActivityBreakpoint.ACTIVITY_ID, activityId);
                attributes.put(ActivityBreakpoint.TASKFLOW_NAME, taskflowName);
                ActivityBreakpoint.this.taskflowName = taskflowName;
                ActivityBreakpoint.this.activityId = activityId;
                ActivityBreakpoint.this.updateConditionAttributres(attributes);
                marker.setAttributes(attributes);
                ActivityBreakpoint.this.setMarker(marker);
                ActivityBreakpoint.this.register(register);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    private void addMethodNameAndSignature(Map attributes, String methodName, String methodSignature) {
        if (methodName != null) {
            attributes.put("org.eclipse.jdt.debug.core.methodName", methodName);
        }
        if (methodSignature != null) {
            attributes.put("org.eclipse.jdt.debug.core.methodSignature", methodSignature);
        }
    }

    @Override
    public String getTaskflowName() {
        return this.taskflowName == null ? "UNBOUNDED_TASK_FLOW" : this.taskflowName;
    }

    @Override
    public String getActivityId() {
        return this.activityId == null ? "" : this.activityId;
    }

    public String getTemplateName() {
        return this.templateName == null ? "" : this.templateName;
    }

    public void setTemplateName(String name) {
        this.templateName = name;
    }

    private void setConditionString(Map attributes) {
        if (this.taskflowName.equals("UNBOUNDED_TASK_FLOW")) {
            String condition = "activityBreakpointDetail.getTaskFlowId()==null && activityBreakpointDetail.getActivityId().equals(\"%s\")";
            condition = String.format(condition, this.activityId);
            attributes.put("org.eclipse.jdt.debug.core.condition", condition);
            return;
        }
        String condition = "activityBreakpointDetail.getTaskFlowId().equals(\"%s\") && activityBreakpointDetail.getActivityId().equals(\"%s\")";
        IFile file = (IFile)this.getMarker().getResource();
        TaskFlowType type = TaskFlowUtil.getTaskFlowType((IFile)file);
        if (type == TaskFlowType.Template) {
            condition = "activityBreakpointDetail.getActivityId().equals(\"%s\")";
            condition = String.format(condition, this.activityId);
            attributes.put(TEMPLATE_NAME, file.getName());
            this.templateName = file.getName();
        } else {
            condition = String.format(condition, this.taskflowName, this.activityId);
        }
        attributes.put("org.eclipse.jdt.debug.core.condition", condition);
    }

    private void updateConditionAttributres(Map attributes) {
        this.setConditionString(attributes);
        attributes.put("org.eclipse.jdt.debug.core.conditionEnabled", Boolean.TRUE);
    }

    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
        this.restoreCondition();
    }

    public String getModelIdentifier() {
        return AdfDebugModel.getModelIdentifier();
    }

    public String getLabel() {
        StringBuffer label = new StringBuffer();
        label.append("ADF TaskFlow breakpoint: ");
        if (this.getTemplateName().length() > 0) {
            label.append(this.getTemplateName());
        } else {
            label.append(this.getTaskflowName());
        }
        label.append("#");
        label.append(this.getActivityId());
        IProject p = this.getMarker().getResource().getProject();
        label.append(" in " + p.getName());
        return label.toString();
    }

    public void restoreCondition() {
        try {
            int n;
            String condition = this.getCondition();
            int n2 = n = condition != null ? condition.indexOf(GET_TASKFLOW_ID) : 0;
            if (n > 0) {
                String id = this.getMarker().getAttribute(ACTIVITY_ID, "");
                this.setActivityId(id);
                String name = this.getMarker().getAttribute(TASKFLOW_NAME, "");
                this.setTaskflowName(name);
            } else {
                String template = this.getMarker().getAttribute(TEMPLATE_NAME, "");
                if (template.length() > 0) {
                    this.setTemplateName(template);
                    String id = this.getMarker().getAttribute(ACTIVITY_ID, "");
                    this.setActivityId(id);
                }
            }
        }
        catch (Exception exception) {}
    }

    public static ActivityBreakpoint findBreakpoint(IFile file, String taskflowName, String activityId) {
        IBreakpoint[] brkpts;
        IBreakpointManager brkptMgr = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = brkpts = brkptMgr.getBreakpoints("oracle.eclipse.tools.weblogic.debugger");
        int n = brkpts.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityBreakpoint tfbp;
            IFile markerRes;
            IBreakpoint bp = iBreakpointArray[n2];
            if (bp instanceof ActivityBreakpoint && (markerRes = (IFile)(tfbp = (ActivityBreakpoint)bp).getMarker().getResource()).equals((Object)file)) {
                String taskflow = tfbp.getTaskflowName();
                String activity = tfbp.getActivityId();
                String templateName = tfbp.getTemplateName();
                if (templateName.length() > 0 && templateName.startsWith(taskflowName) && activity.equals(activityId)) {
                    return tfbp;
                }
                if (taskflow.equals(taskflowName) && activity.equals(activityId)) {
                    return tfbp;
                }
            }
            ++n2;
        }
        return null;
    }

    private void setActivityId(String id) {
        this.activityId = id;
    }

    private void setTaskflowName(String name) {
        this.taskflowName = name;
    }
}

