/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.pagedef;

import oracle.eclipse.tools.adf.debugger.AdfDebugModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;

public class DCBindingElement
implements IAdaptable {
    private JDIStackFrame stackFrame;
    private String bindingElmName = null;
    private IFile pageDefFile = null;
    private IJavaProject javaProj = null;
    private boolean isBeforeBinding = false;

    public DCBindingElement(JDIStackFrame stackFrm) {
        this.stackFrame = stackFrm;
    }

    public JDIStackFrame getStackFrame() {
        return this.stackFrame;
    }

    public IFile getPageDefFile() {
        this.init();
        return this.pageDefFile;
    }

    public String getBindingName() {
        this.init();
        return this.bindingElmName;
    }

    public boolean isBeforeBinding() {
        return this.isBeforeBinding;
    }

    public void init() {
        block25: {
            try {
                IProject p;
                IBreakpoint[] breakpoints;
                if (!this.stackFrame.getThread().isSuspended()) {
                    return;
                }
                if (this.bindingElmName != null) {
                    return;
                }
                IJavaObject thisObj = this.stackFrame.getThis();
                if (thisObj == null) break block25;
                IJavaFieldVariable nameFld = thisObj.getField("mName", true);
                this.bindingElmName = nameFld.getValue().getValueString();
                this.isBeforeBinding = AdfDebugModel.isInBeforeBindingMethod(this.stackFrame);
                IJavaFieldVariable fld = thisObj.getField("mBindingContainer", true);
                if (fld == null) {
                    fld = thisObj.getField("mBC", true);
                }
                if (fld == null) break block25;
                IJavaThread thread = (IJavaThread)this.stackFrame.getThread();
                IJavaObject container = (IJavaObject)fld.getValue();
                fld = container.getField("mBindingContainerDef", true);
                IJavaObject containerDef = (IJavaObject)fld.getValue();
                fld = containerDef.getField("mFullName", true);
                String pageDefName = fld.getValue().getValueString();
                if (thread != null && (breakpoints = thread.getBreakpoints()) != null) {
                    IResource resource;
                    IMarker marker = null;
                    if (breakpoints.length == 1) {
                        marker = breakpoints[0].getMarker();
                        IMarker aux = breakpoints[0].getMarker();
                        try {
                            String brkptPageDef = aux.getAttribute("PAGEDF_NAME").toString();
                            if (pageDefName.indexOf(brkptPageDef) < 0) {
                                thread.resume();
                                return;
                            }
                        }
                        catch (CoreException coreException) {}
                    } else if (breakpoints.length > 1 && this.bindingElmName != null) {
                        IBreakpoint[] iBreakpointArray = breakpoints;
                        int n = breakpoints.length;
                        int brkptPageDef = 0;
                        while (brkptPageDef < n) {
                            IBreakpoint breakpoint = iBreakpointArray[brkptPageDef];
                            IMarker aux = breakpoint.getMarker();
                            if (aux != null) {
                                try {
                                    if (this.bindingElmName.equals(aux.getAttribute("BINDING_ID"))) {
                                        marker = aux;
                                        String brkptPageDef2 = aux.getAttribute("PAGEDF_NAME").toString();
                                        if (pageDefName.indexOf(brkptPageDef2) >= 0) break;
                                        thread.resume();
                                        return;
                                    }
                                }
                                catch (Exception exception) {}
                            }
                            ++brkptPageDef;
                        }
                    }
                    if (marker != null && (resource = marker.getResource()) instanceof IFile) {
                        this.pageDefFile = (IFile)resource;
                        if (!this.stackFrame.getThread().isSuspended()) {
                            return;
                        }
                        String projContextRoot = J2EEProjectUtilities.getServerContextRoot((IProject)this.pageDefFile.getProject());
                        String contextRoot = this.getContextPath(container);
                        if (contextRoot == null || !contextRoot.equals(projContextRoot)) {
                            thread.resume();
                            this.pageDefFile = null;
                            return;
                        }
                    }
                }
                if (this.pageDefFile == null) {
                    IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    int n = iProjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        p = iProjectArray[n2];
                        IFolder folder = p.getFolder("adfmsrc");
                        if (folder.exists()) {
                            String pageDefFilePath = String.valueOf(pageDefName.replace('.', '/')) + ".xml";
                            IPath pageDefPath = folder.getFullPath().append(String.valueOf('/') + pageDefFilePath);
                            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(pageDefPath);
                            if (f.exists()) {
                                this.pageDefFile = f;
                            }
                        }
                        ++n2;
                    }
                }
                if (this.pageDefFile != null) {
                    p = this.pageDefFile.getProject();
                    this.javaProj = JavaCore.create((IProject)p);
                }
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
        }
    }

    private String getContextPath(IJavaObject container) throws DebugException {
        IJavaThread thread;
        IJavaFieldVariable fld;
        StringBuffer contextRoot;
        block6: {
            contextRoot = new StringBuffer();
            fld = container.getField("mBindingContext", true);
            thread = (IJavaThread)this.stackFrame.getThread();
            if (thread.isSuspended()) break block6;
            return null;
        }
        try {
            IJavaObject httpReq;
            IJavaObject bindingCtx = (IJavaObject)fld.getValue();
            IJavaDebugTarget javaTarget = (IJavaDebugTarget)this.stackFrame.getDebugTarget();
            IJavaValue ret = bindingCtx.sendMessage("get", "(Ljava/lang/Object;)Ljava/lang/Object;", new IJavaValue[]{javaTarget.newValue("_http_request_")}, thread, true);
            if (ret != null && (ret = (httpReq = (IJavaObject)ret).sendMessage("getContextPath", "()Ljava/lang/String;", new IJavaValue[0], thread, true)) != null) {
                String val = ret.toString();
                char[] cArray = val.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (c != '\"' && c != '/') {
                        contextRoot.append(c);
                    }
                    ++n2;
                }
                return contextRoot.toString();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public Object getAdapter(Class clz) {
        this.init();
        if (clz == IJavaElement.class) {
            return this.javaProj;
        }
        return null;
    }
}

