/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.pagedef;

import java.util.Map;
import oracle.eclipse.tools.adf.debugger.AdfDebugModel;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaMethodBreakpoint;

public abstract class BindingBreakpoint
extends JavaMethodBreakpoint {
    protected String pageDefName = null;
    private String bindingId = null;
    private boolean isBreakBefore = false;

    public BindingBreakpoint() {
    }

    public BindingBreakpoint(final IResource resource, final String id, final boolean breakBefore, final Map attributes) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker(BindingBreakpoint.this.getMarkerId());
                int lineNumber = -1;
                int charStart = -1;
                int charEnd = -1;
                BindingBreakpoint.this.addLineBreakpointAttributes(attributes, BindingBreakpoint.this.getModelIdentifier(), true, lineNumber, charStart, charEnd);
                attributes.put("PAGEDF_NAME", resource.getName());
                BindingBreakpoint.this.addTypeNameAndHitCount(attributes, BindingBreakpoint.this.getDebugTypePattern(), 0);
                BindingBreakpoint.this.addMethodNameAndSignature(attributes, BindingBreakpoint.this.getDebugMethodName(breakBefore), BindingBreakpoint.this.getDebugMethodSignature(breakBefore));
                attributes.put("org.eclipse.jdt.debug.core.entry", true);
                attributes.put("org.eclipse.jdt.debug.core.exit", false);
                attributes.put("org.eclipse.jdt.debug.core.native", false);
                attributes.put("org.eclipse.jdt.debug.core.suspendPolicy", new Integer(BindingBreakpoint.this.getDefaultSuspendPolicy()));
                String name = resource.getName();
                BindingBreakpoint.this.pageDefName = name.substring(0, name.indexOf(".xml"));
                BindingBreakpoint.this.bindingId = id;
                BindingBreakpoint.this.isBreakBefore = breakBefore;
                BindingBreakpoint.this.setDataBindingAttributes(attributes);
                BindingBreakpoint.this.updateConditionAttributres(attributes, breakBefore);
                marker.setAttributes(attributes);
                BindingBreakpoint.this.setMarker(marker);
                BindingBreakpoint.this.register(true);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    protected abstract String getMarkerId();

    public String getModelIdentifier() {
        return AdfDebugModel.getModelIdentifier();
    }

    protected void setDataBindingAttributes(Map attributes) {
        attributes.put("PAGEDF_NAME", this.pageDefName);
        attributes.put("BINDING_ID", this.bindingId);
        attributes.put("IS_BREAK_BEFORE", this.isBreakBefore);
    }

    private void updateConditionAttributres(Map attributes, boolean breakBefore) {
        String condition = String.format(this.getConditionString(), this.bindingId);
        attributes.put("org.eclipse.jdt.debug.core.condition", condition);
        attributes.put("org.eclipse.jdt.debug.core.conditionEnabled", Boolean.TRUE);
    }

    protected abstract String getConditionString();

    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
    }

    protected void updateBindingOrExecutableAttributes(Map attributes, String name) {
        attributes.put("BINDING_ID", name);
    }

    protected abstract String getDebugMethodSignature(boolean var1);

    protected abstract String getDebugMethodName(boolean var1);

    protected abstract String getDebugTypePattern();

    public String getLabel() {
        String position = this.isBreakBefore() ? "Before " : "After ";
        String label = String.valueOf(position) + this.getType() + " '" + this.getId() + "' in " + this.getPageDefName() + ".xml";
        IProject project = this.getMarker().getResource().getProject();
        label = String.valueOf(label) + " in project " + project.getName();
        return label;
    }

    protected String getType() {
        return "binding";
    }

    private void addMethodNameAndSignature(Map attributes, String methodName, String methodSignature) {
        if (methodName != null) {
            attributes.put("org.eclipse.jdt.debug.core.methodName", methodName);
        }
        if (methodSignature != null) {
            attributes.put("org.eclipse.jdt.debug.core.methodSignature", methodSignature);
        }
    }

    public Object getId() {
        if (this.bindingId == null) {
            this.bindingId = this.getMarker().getAttribute("BINDING_ID", "");
        }
        return this.bindingId;
    }

    public Object getPageDefName() {
        if (this.pageDefName == null) {
            this.pageDefName = this.getMarker().getAttribute("PAGEDF_NAME", "");
        }
        return this.pageDefName;
    }

    public boolean isBreakBefore() {
        this.isBreakBefore = this.getMarker().getAttribute("IS_BREAK_BEFORE", false);
        return this.isBreakBefore;
    }
}

