/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.debugger.lifecycle;

import java.util.Map;
import oracle.eclipse.tools.adf.debugger.AdfDebugModel;
import oracle.eclipse.tools.adf.debugger.lifecycle.IAdfLifecyclePhaseBreakpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaMethodBreakpoint;

public class AdfLifecyclePhaseBreakpoint
extends JavaMethodBreakpoint
implements IAdfLifecyclePhaseBreakpoint {
    public static final String ADF_LIFE_CYCLE_BREAKPOINT_MARKER = "oracle.eclipse.tools.adf.debugger.lifecycleBreakpointMarker";
    private String phaseName = null;
    private boolean isBreakBeforePhase = false;
    private boolean isBreakAfterPhase = false;
    private static String PHASE_NAME_CONDITION = "phaseName!=null && phaseName.equals(\"";
    private static String PHASE_BOUNDARY_CONDITION = "&& phaseBoundaryName!=null && phaseBoundaryName.equals(\"";

    public AdfLifecyclePhaseBreakpoint() {
    }

    public AdfLifecyclePhaseBreakpoint(String phaseName, boolean before, boolean after, boolean register, Map attributes) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IWorkspaceRunnable wr = new IWorkspaceRunnable((IResource)root, attributes, phaseName, after, before, register){
            private final /* synthetic */ IResource val$root;
            private final /* synthetic */ Map val$attributes;
            private final /* synthetic */ String val$phaseName;
            private final /* synthetic */ boolean val$after;
            private final /* synthetic */ boolean val$before;
            private final /* synthetic */ boolean val$register;
            {
                this.val$root = iResource;
                this.val$attributes = map;
                this.val$phaseName = string;
                this.val$after = bl;
                this.val$before = bl2;
                this.val$register = bl3;
            }

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = this.val$root.createMarker(AdfLifecyclePhaseBreakpoint.ADF_LIFE_CYCLE_BREAKPOINT_MARKER);
                AdfLifecyclePhaseBreakpoint.this.setMarker(marker);
                int lineNumber = -1;
                int charStart = 5540;
                int charEnd = 5557;
                AdfLifecyclePhaseBreakpoint.this.addLineBreakpointAttributes(this.val$attributes, AdfLifecyclePhaseBreakpoint.this.getModelIdentifier(), true, lineNumber, charStart, charEnd);
                AdfLifecyclePhaseBreakpoint.this.addTypeNameAndHitCount(this.val$attributes, "oracle.adf.controller.internal.debug.AdfLifecycleBreakpointFacadeFwk", 0);
                AdfLifecyclePhaseBreakpoint.this.addMethodNameAndSignature(this.val$attributes, "markPhaseBoundary", "(Ljava/lang/String;Ljava/lang/String;)V");
                this.val$attributes.put("org.eclipse.jdt.debug.core.entry", true);
                this.val$attributes.put("org.eclipse.jdt.debug.core.exit", false);
                this.val$attributes.put("org.eclipse.jdt.debug.core.native", false);
                this.val$attributes.put("org.eclipse.jdt.debug.core.suspendPolicy", new Integer(AdfLifecyclePhaseBreakpoint.this.getDefaultSuspendPolicy()));
                AdfLifecyclePhaseBreakpoint.this.phaseName = this.val$phaseName;
                AdfLifecyclePhaseBreakpoint.this.isBreakAfterPhase = this.val$after;
                AdfLifecyclePhaseBreakpoint.this.isBreakBeforePhase = this.val$before;
                AdfLifecyclePhaseBreakpoint.this.updateConditionAttributres(this.val$attributes);
                marker.setAttributes(this.val$attributes);
                AdfLifecyclePhaseBreakpoint.this.setMarker(marker);
                AdfLifecyclePhaseBreakpoint.this.register(this.val$register);
            }
        };
        this.run(this.getMarkerRule((IResource)root), wr);
    }

    private void addMethodNameAndSignature(Map attributes, String methodName, String methodSignature) {
        if (methodName != null) {
            attributes.put("org.eclipse.jdt.debug.core.methodName", methodName);
        }
        if (methodSignature != null) {
            attributes.put("org.eclipse.jdt.debug.core.methodSignature", methodSignature);
        }
    }

    @Override
    public String getPhaseName() {
        return this.phaseName;
    }

    public void setPhaseName(String name) {
        this.phaseName = name;
    }

    @Override
    public boolean isBefore() {
        return this.isBreakBeforePhase;
    }

    @Override
    public boolean isAfter() {
        return this.isBreakAfterPhase;
    }

    @Override
    public void setBefore(boolean before) throws CoreException {
        this.isBreakBeforePhase = before;
        this.setCondition(this.getConditionString());
    }

    @Override
    public void setAfter(boolean after) throws CoreException {
        this.isBreakAfterPhase = after;
        this.setCondition(this.getConditionString());
    }

    private String getConditionString() {
        StringBuilder condition = new StringBuilder(String.valueOf(PHASE_NAME_CONDITION) + this.phaseName + "\")");
        if (this.isBreakBeforePhase && !this.isBreakAfterPhase) {
            condition.append(String.valueOf(PHASE_BOUNDARY_CONDITION) + "BEFORE_PHASE" + "\")");
        } else if (!this.isBreakBeforePhase && this.isBreakAfterPhase) {
            condition.append(String.valueOf(PHASE_BOUNDARY_CONDITION) + "AFTER_PHASE" + "\")");
        }
        return condition.toString();
    }

    private void updateConditionAttributres(Map attributes) {
        attributes.put("org.eclipse.jdt.debug.core.condition", this.getConditionString());
        attributes.put("org.eclipse.jdt.debug.core.conditionEnabled", Boolean.TRUE);
    }

    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
        this.restoreCondition();
    }

    public String getModelIdentifier() {
        return AdfDebugModel.getModelIdentifier();
    }

    public String getLabel() {
        StringBuffer label = new StringBuffer();
        label.append("ADF lifecycle breakpoint: ");
        if (this.isBefore() && this.isAfter()) {
            label.append("before and after ");
        } else {
            label.append(this.isBefore() ? "before " : "");
            label.append(this.isAfter() ? "after " : "");
        }
        label.append(this.getPhaseName());
        return label.toString();
    }

    public void restoreCondition() {
        try {
            String condition = this.getCondition();
            int n = condition.indexOf(PHASE_NAME_CONDITION);
            if (n == 0) {
                String name = condition.substring(PHASE_NAME_CONDITION.length());
                name = name.substring(0, name.indexOf(34));
                this.setPhaseName(name);
                if (condition.indexOf("BEFORE_PHASE") < 0 && condition.indexOf("AFTER_PHASE") < 0) {
                    this.isBreakAfterPhase = true;
                    this.isBreakBeforePhase = true;
                } else {
                    if (condition.indexOf("BEFORE_PHASE") > 0) {
                        this.isBreakBeforePhase = true;
                    }
                    if (condition.indexOf("AFTER_PHASE") > 0) {
                        this.isBreakAfterPhase = true;
                    }
                }
            }
        }
        catch (Exception exception) {}
    }
}

