/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.utils.pem;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import oracle.cloudlogic.javaservice.utils.pem.PemFileHeader;
import oracle.cloudlogic.javaservice.utils.pem.PemFileWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PemFileObject {
    private FILE_TYPE type;
    private List<PemFileHeader> headers;
    private byte[] content;

    public String getAliasFromHeader() {
        PemFileHeader h = this.findAliasFromHeader();
        if (h == null) {
            return null;
        }
        return h.getValue();
    }

    private PemFileHeader findAliasFromHeader() {
        if (this.headers == null) {
            return null;
        }
        for (PemFileHeader h : this.headers) {
            if (!"alias".equals(h.getName())) continue;
            return h;
        }
        return null;
    }

    public void addAliasHeader(String alias) {
        PemFileHeader h = this.findAliasFromHeader();
        if (h == null) {
            this.getHeaders().add(new PemFileHeader("alias", alias));
        } else {
            h.setValue(alias);
        }
    }

    public boolean isCertificate() {
        return this.type == FILE_TYPE.CERTIFICATE;
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PemFileWriter writer = new PemFileWriter(new OutputStreamWriter(out));
            writer.writeObject(this);
            writer.flush();
            out.flush();
            out.close();
            return out.toByteArray();
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
    }

    public PemFileObject(String type, byte[] content) {
        this(type, null, content);
    }

    public PemFileObject(String type, List<PemFileHeader> headers, byte[] content) {
        this.type = FILE_TYPE.fromPrintableName(type);
        this.headers = headers;
        this.content = content;
    }

    public FILE_TYPE getType() {
        return this.type;
    }

    public List<PemFileHeader> getHeaders() {
        if (this.headers == null) {
            this.headers = new ArrayList<PemFileHeader>();
        }
        return this.headers;
    }

    public byte[] getContent() {
        return this.content;
    }

    public PemFileObject generate() {
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FILE_TYPE {
        RSA_PRIVATE_KEY,
        PRIVATE_KEY,
        CERTIFICATE,
        PUBLIC_KEY;


        public String getPrintableName() {
            return this.toString().replaceAll("_", " ");
        }

        public static FILE_TYPE fromPrintableName(String name) {
            return FILE_TYPE.valueOf(name.toString().replaceAll(" ", "_"));
        }
    }
}

