/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReflectionUtil {
    public static Object invoke(Object obj, String method) throws Throwable {
        return ReflectionUtil.invoke(obj, method, new Object[]{null});
    }

    public static Object invoke(Object obj, String method, Object nonNull) throws Throwable {
        return ReflectionUtil.invoke(obj, method, new Object[]{nonNull});
    }

    public static Object invoke(Object obj, String method, Class cls, Object arg) throws Throwable {
        return ReflectionUtil.invoke(obj, method, new Class[]{cls}, new Object[]{arg});
    }

    public static Object invoke(Object obj, String method, Object[] nonNulls, ClassLoader loader) throws Throwable {
        Class[] classes = ReflectionUtil.getClasses(nonNulls);
        if (classes == null) {
            nonNulls = null;
        }
        return ReflectionUtil.invoke(obj, method, classes, nonNulls, loader);
    }

    public static Object invoke(Object obj, String method, Object[] nonNulls) throws Exception {
        Class[] classes = ReflectionUtil.getClasses(nonNulls);
        if (classes == null) {
            nonNulls = null;
        }
        return ReflectionUtil.invoke(obj, method, classes, nonNulls);
    }

    public static Object invoke(Object obj, String methodName, Class[] argTypes, Object[] nonNulls) throws Exception {
        return ReflectionUtil.invoke(obj, methodName, argTypes, nonNulls, null);
    }

    public static Object invoke(Object obj, String methodName, Class[] argTypes, Object[] nonNulls, ClassLoader loader) throws Exception {
        if (obj == null) {
            throw new Exception("Object cant be null;");
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = original;
        }
        try {
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> cls = obj.getClass();
            Method method = cls.getMethod(methodName, argTypes);
            Object object = method.invoke(obj, nonNulls);
            return object;
        }
        catch (Throwable t) {
            throw new Exception("Invocation failed:", t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public static Object invokeStatic(String clsStr, String method, Object[] nonNulls) throws Exception {
        Class[] classes = ReflectionUtil.getClasses(nonNulls);
        if (classes == null) {
            nonNulls = null;
        }
        return ReflectionUtil.invokeStatic(clsStr, method, classes, nonNulls);
    }

    public static Class[] getClasses(Object[] objs) throws Exception {
        if (objs == null) {
            return null;
        }
        Class[] classes = new Class[objs.length];
        int i = 0;
        for (Object obj : objs) {
            if (obj == null) {
                if (objs.length == 1) {
                    classes = null;
                } else {
                    classes[i] = Object.class;
                }
            } else {
                classes[i] = obj.getClass();
            }
            ++i;
        }
        return classes;
    }

    public static Object invokeStatic(String clsStr, String methodName, Class[] argTypes, Object[] nonNulls) throws Exception {
        return ReflectionUtil.invokeStatic(clsStr, methodName, argTypes, nonNulls, null);
    }

    public static Object invokeStatic(String clsStr, String methodName, Class[] argTypes, Object[] nonNulls, ClassLoader loader) throws Exception {
        Class<?> cls = loader != null ? loader.loadClass(clsStr) : Class.forName(clsStr);
        Method method = cls.getMethod(methodName, argTypes);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new Exception("Not a static method ..." + methodName + " of " + clsStr);
        }
        return method.invoke(null, nonNulls);
    }

    public static Object instantiate(String clsStr) throws Exception {
        return ReflectionUtil.instantiate(clsStr, (ClassLoader)null);
    }

    public static Object instantiate(String clsStr, Object[] nonNulls) throws Throwable {
        Class[] classes = ReflectionUtil.getClasses(nonNulls);
        if (classes == null) {
            nonNulls = null;
        }
        return ReflectionUtil.instantiate(clsStr, classes, nonNulls);
    }

    public static Object instantiate(String clsStr, Class[] classes, Object[] values) throws Throwable {
        return ReflectionUtil.instantiate(clsStr, classes, values, null);
    }

    public static Object instantiate(String clsStr, Class[] classes, Object[] values, ClassLoader loader) throws Throwable {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = original;
        }
        Class<?> cls = loader.loadClass(clsStr);
        Constructor<?> con = cls.getConstructor(classes);
        try {
            Thread.currentThread().setContextClassLoader(loader);
            Object obj = con.newInstance(values);
            return obj;
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public static Object instantiate(String clsStr, ClassLoader loader) throws Exception {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = original;
        }
        Class<?> cls = loader.loadClass(clsStr);
        Constructor<?> con = cls.getConstructor(new Class[0]);
        try {
            Thread.currentThread().setContextClassLoader(loader);
            Object obj = con.newInstance(new Object[0]);
            return obj;
        }
        catch (Throwable t) {
            throw new Exception("Instantiation failed:", t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }
}

