/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;

public final class EncodingUtil {
    private static final byte[] reverseBase64Chars;
    private static final int END_OF_INPUT = -1;
    private static final int NON_BASE_64 = -1;
    private static final int NON_BASE_64_WHITESPACE = -2;
    private static final int NON_BASE_64_PADDING = -3;
    private static final byte[] base64Chars;

    public static boolean isBase64(String string, String enc) throws UnsupportedEncodingException {
        return EncodingUtil.isBase64(string.getBytes(enc));
    }

    public static boolean isBase64(String string) throws UnsupportedEncodingException {
        return EncodingUtil.isBase64(string.getBytes("UTF-8"));
    }

    public static boolean isBase64(byte[] bytes) {
        try {
            return EncodingUtil.isBase64(new ByteArrayInputStream(bytes));
        }
        catch (IOException x) {
            return false;
        }
    }

    public static boolean isBase64(InputStream in) throws IOException {
        int read;
        long numBase64Chars = 0L;
        int numPadding = 0;
        while ((read = in.read()) != -1) {
            if ((read = reverseBase64Chars[read]) == -1) {
                return false;
            }
            if (read == -2) continue;
            if (read == -3) {
                ++numPadding;
                ++numBase64Chars;
                continue;
            }
            if (numPadding > 0) {
                return false;
            }
            ++numBase64Chars;
        }
        if (numBase64Chars == 0L) {
            return false;
        }
        return numBase64Chars % 4L == 0L;
    }

    public static String encode(String string) throws UnsupportedEncodingException {
        return new String(EncodingUtil.encode(string.getBytes("UTF-8")), "UTF-8");
    }

    public static String encode(String string, String enc) throws UnsupportedEncodingException {
        return new String(EncodingUtil.encode(string.getBytes(enc)), enc);
    }

    public static String encodeToString(byte[] bytes) {
        return EncodingUtil.encodeToString(bytes, false);
    }

    public static String encodeToString(byte[] bytes, boolean lineBreaks) {
        try {
            return new String(EncodingUtil.encode(bytes, lineBreaks), "ASCII");
        }
        catch (UnsupportedEncodingException iex) {
            throw new RuntimeException(iex);
        }
    }

    public static byte[] encode(byte[] bytes) {
        return EncodingUtil.encode(bytes, false);
    }

    public static byte[] encode(byte[] bytes, boolean lineBreaks) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        int length = bytes.length;
        int mod = length % 3;
        if (mod != 0) {
            length += 3 - mod;
        }
        length = length * 4 / 3;
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        try {
            EncodingUtil.encode(in, out, lineBreaks);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        return out.toByteArray();
    }

    public static void encode(InputStream in, OutputStream out) throws IOException {
        EncodingUtil.encode(in, out, true);
    }

    public static void encode(InputStream in, OutputStream out, boolean lineBreaks) throws IOException {
        int[] inBuffer = new int[3];
        int lineCount = 0;
        boolean done = false;
        while (!done && (inBuffer[0] = in.read()) != -1) {
            inBuffer[1] = in.read();
            inBuffer[2] = in.read();
            out.write(base64Chars[inBuffer[0] >> 2]);
            if (inBuffer[1] != -1) {
                out.write(base64Chars[inBuffer[0] << 4 & 0x30 | inBuffer[1] >> 4]);
                if (inBuffer[2] != -1) {
                    out.write(base64Chars[inBuffer[1] << 2 & 0x3C | inBuffer[2] >> 6]);
                    out.write(base64Chars[inBuffer[2] & 0x3F]);
                } else {
                    out.write(base64Chars[inBuffer[1] << 2 & 0x3C]);
                    out.write(61);
                    done = true;
                }
            } else {
                out.write(base64Chars[inBuffer[0] << 4 & 0x30]);
                out.write(61);
                out.write(61);
                done = true;
            }
            if (!lineBreaks || (lineCount += 4) < 76) continue;
            out.write(10);
            lineCount = 0;
        }
        if (lineBreaks && lineCount >= 1) {
            out.write(10);
            lineCount = 0;
        }
        out.flush();
    }

    public static byte[] decodetoByteArray(String s) throws IOException {
        if (s == null) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes("UTF-8"));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncodingUtil.decode(in, out);
        return out.toByteArray();
    }

    public static String decode(String s) throws IOException {
        byte[] data = EncodingUtil.decodetoByteArray(s);
        if (data == null) {
            return null;
        }
        return new String(data, "UTF-8");
    }

    public static void decode(InputStream in, OutputStream out) throws IOException {
        EncodingUtil.decode(in, out, true);
    }

    public static void decode(InputStream in, OutputStream out, boolean throwExceptions) throws IOException {
        int[] inBuffer = new int[4];
        boolean done = false;
        while (!done && (inBuffer[0] = EncodingUtil.readBase64(in, throwExceptions)) != -1 && (inBuffer[1] = EncodingUtil.readBase64(in, throwExceptions)) != -1) {
            inBuffer[2] = EncodingUtil.readBase64(in, throwExceptions);
            inBuffer[3] = EncodingUtil.readBase64(in, throwExceptions);
            out.write(inBuffer[0] << 2 | inBuffer[1] >> 4);
            if (inBuffer[2] != -1) {
                out.write(inBuffer[1] << 4 | inBuffer[2] >> 2);
                if (inBuffer[3] != -1) {
                    out.write(inBuffer[2] << 6 | inBuffer[3]);
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        out.flush();
    }

    private static final int readBase64(InputStream in, boolean throwExceptions) throws IOException {
        int read;
        int numPadding = 0;
        do {
            if ((read = in.read()) == -1) {
                return -1;
            }
            read = reverseBase64Chars[(byte)read];
            if (throwExceptions && (read == -1 || numPadding > 0 && read > -1)) {
                throw new IOException("unexpected char:" + read);
            }
            if (read != -3) continue;
            ++numPadding;
        } while (read <= -1);
        return read;
    }

    public static String digestAndEncode(String text) throws UnsupportedEncodingException {
        return EncodingUtil.digestAndEncode(text, "SHA");
    }

    public static String digestAndEncode(byte[] content) {
        return EncodingUtil.digestAndEncode(content, "SHA");
    }

    public static String digestAndEncode(String text, String algo) throws UnsupportedEncodingException {
        if (text == null) {
            return null;
        }
        return EncodingUtil.digestAndEncode(text.getBytes("UTF-8"), algo);
    }

    public static String digestAndEncode(byte[] content, String algo) {
        try {
            if (content == null) {
                return null;
            }
            MessageDigest md = null;
            md = MessageDigest.getInstance(algo);
            byte[] data = EncodingUtil.encode(md.digest(content));
            String ret = new String(data, "UTF-8");
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String digestAndEncodeRmSlashEncode(String text) throws Exception {
        return EncodingUtil.digestAndEncodeReplaceNonFriendlyChars(text);
    }

    public static String digestAndEncodeRmSlashEncodeForFileSystem(String text) throws Exception {
        return EncodingUtil.digestAndEncodeReplaceNonFriendlyChars(text);
    }

    public static String digestAndEncodeReplaceNonFriendlyChars(String text) throws Exception {
        if (text == null) {
            return null;
        }
        MessageDigest md = null;
        md = MessageDigest.getInstance("SHA");
        byte[] data = EncodingUtil.encode(md.digest(text.getBytes("UTF-8")));
        String ret = new String(data, "UTF-8");
        ret = ret.replaceAll("/", "___");
        ret = ret.replaceAll("\\+", "__");
        ret = ret.replaceAll("=", "_");
        ret = "_" + ret;
        return ret;
    }

    public static String digestToAVariableName(String s) {
        try {
            return EncodingUtil.digestAndEncodeReplaceNonFriendlyChars(s);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while digesting:", e);
        }
    }

    public static String encodeURL(String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll("\\+", "%2B");
    }

    static {
        int i;
        reverseBase64Chars = new byte[256];
        base64Chars = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        for (i = 0; i < reverseBase64Chars.length; ++i) {
            EncodingUtil.reverseBase64Chars[i] = -1;
        }
        for (i = 0; i < base64Chars.length; i = (int)((byte)(i + 1))) {
            EncodingUtil.reverseBase64Chars[EncodingUtil.base64Chars[i]] = i;
        }
        EncodingUtil.reverseBase64Chars[32] = -2;
        EncodingUtil.reverseBase64Chars[10] = -2;
        EncodingUtil.reverseBase64Chars[13] = -2;
        EncodingUtil.reverseBase64Chars[9] = -2;
        EncodingUtil.reverseBase64Chars[12] = -2;
        EncodingUtil.reverseBase64Chars[61] = -3;
    }
}

