/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.types.AssociationType;
import oracle.cloudlogic.javaservice.types.CertificateDescription;
import oracle.cloudlogic.javaservice.types.CommandType;
import oracle.cloudlogic.javaservice.types.NameValuePairType;
import oracle.cloudlogic.javaservice.types.UserInstanceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonUtils {
    public static final Random random = new Random();
    public static final String JAVA_SERVICE_HINT_HEADER = "X-Oracle-Java-Service-Admin";
    public static final String JAVA_SERVICE_RESOURCE_TYPE = "X-Oracle-Java-Service-resource-type";
    public static final String JAVA_SERVICE_RESOURCE_NAME = "X-Oracle-Java-Service-resource-name";
    public static final String ENCODING = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void emptyArray(char[] pwd) {
        if (pwd == null) return;
        char[] cArray = pwd;
        synchronized (pwd) {
            for (int i = 0; i < pwd.length; ++i) {
                pwd[i] = 42;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!(f.isDirectory() ? !CommonUtils.deleteFolder(f) : !f.delete())) continue;
                return false;
            }
        }
        return folder.delete();
    }

    public static String getDynamicIdentifier(int length) {
        if (length < 0) {
            return null;
        }
        int q = length / 3;
        int r = length % 3;
        StringBuffer buf = new StringBuffer("");
        if (q > 0) {
            buf.append(CommonUtils.getRandomString(65, 90, q));
            buf.append(CommonUtils.getRandomString(48, 57, q));
            buf.append(CommonUtils.getRandomString(97, 122, q));
        }
        buf.append(CommonUtils.getRandomString(65, 90, r));
        return buf.toString();
    }

    public static String getRandomString(int asciiFrom, int asciiTo, int length) {
        if (asciiFrom > asciiTo || length < 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer("");
        int dif = asciiTo - asciiFrom + 1;
        for (int i = 0; i < length; ++i) {
            int num = random.nextInt();
            if (num < 0) {
                num = -num;
            }
            num = num % dif + asciiFrom;
            buf.append((char)num);
        }
        return buf.toString();
    }

    public static String getDynamicIdentifier() {
        int next = random.nextInt();
        if (next < 0) {
            next = -next;
        }
        return CommonUtils.getDynamicIdentifier(next % 10);
    }

    public static boolean isCausedBy(Throwable actual, Class causeClass) {
        return CommonUtils.getCause(actual, causeClass) != null;
    }

    public static <T> T getCause(Throwable actual, Class<T> causeClass) {
        if (causeClass.isAssignableFrom(actual.getClass())) {
            return (T)actual;
        }
        if (actual.getCause() == null) {
            return null;
        }
        return CommonUtils.getCause(actual.getCause(), causeClass);
    }

    public static CertificateDescription from(Certificate cert, String alias) {
        CertificateDescription item = new CertificateDescription();
        item.setAlias(alias);
        if (X509Certificate.class.isAssignableFrom(cert.getClass())) {
            item.setDn(((Object)((X509Certificate)cert).getSubjectDN()).toString());
            item.setExpiry(((X509Certificate)cert).getNotAfter());
        } else {
            item.setDn("");
        }
        return item;
    }

    public static List<AssociationType> findDBAssociations(UserInstanceType user) {
        ArrayList<AssociationType> list = new ArrayList<AssociationType>();
        for (AssociationType t : user.getAssociation()) {
            if (!t.getType().equalsIgnoreCase("database")) continue;
            list.add(t);
        }
        return list;
    }

    public static String[] getAllInnerErrorMessages(String top, Throwable th) {
        boolean msgFound;
        ArrayList<String> all = new ArrayList<String>();
        if (top != null) {
            all.add(top);
        }
        boolean bl = msgFound = top != null;
        while (th != null) {
            if (th.getMessage() != null && !th.getMessage().trim().equals("")) {
                if (!msgFound && all.size() > 0) {
                    all.add(0, th.getMessage());
                }
                if (!all.contains(th.getMessage())) {
                    all.add(th.getMessage());
                    msgFound = true;
                }
            } else {
                all.add(th.getClass().getName());
            }
            th = th.getCause();
        }
        return all.toArray(new String[0]);
    }

    public static String[] getAllInnerErrorMessages(Throwable th) {
        return CommonUtils.getAllInnerErrorMessages(null, th);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void emptyArray(byte[] pwd) {
        if (pwd == null) return;
        byte[] byArray = pwd;
        synchronized (pwd) {
            for (int i = 0; i < pwd.length; ++i) {
                pwd[i] = 42;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File to, File from) throws Exception {
        if (!to.getCanonicalPath().equalsIgnoreCase(from.getCanonicalPath())) {
            FileInputStream in = new FileInputStream(from);
            try {
                CommonUtils.writeToFile(to, in);
            }
            finally {
                ((InputStream)in).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, InputStream in) throws Exception {
        FileOutputStream out = new FileOutputStream(CommonUtils.validateOutputFile(file.getAbsolutePath(), true));
        try {
            CommonUtils.pipe(out, in);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readInputStream(InputStream in) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CommonUtils.pipe(out, in);
        try {
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(String file) throws Exception {
        FileInputStream in = null;
        try {
            in = new FileInputStream(CommonUtils.validateInputFile(file));
            byte[] byArray = CommonUtils.readInputStream(in);
            return byArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static String toEntitybody(byte[] log) {
        try {
            return log == null ? null : new String(log, ENCODING);
        }
        catch (UnsupportedEncodingException ue) {
            throw new RuntimeException(ue);
        }
    }

    public static byte[] fromThrowable(Throwable t) {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        try {
            PrintStream pr = new PrintStream((OutputStream)ba, true, ENCODING);
            t.printStackTrace(pr);
            pr.flush();
            ba.flush();
            ba.close();
            pr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ba.toByteArray();
    }

    public static File validateOutputDir(String dir) throws Exception {
        if (dir == null || dir.trim().equals("")) {
            throw new Exception("Path is null");
        }
        File file = new File(dir);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new Exception("file should be a dir.");
            }
        } else if (!file.mkdirs()) {
            throw new Exception("Unable to create path " + file.getAbsolutePath());
        }
        return file;
    }

    public static File validateOutputFile(String fileStr, boolean createParent) throws Exception {
        if (fileStr == null || fileStr.trim().equals("")) {
            throw new Exception("Path is null");
        }
        File file = new File(fileStr);
        if (file.exists()) {
            if (!file.isFile()) {
                throw new Exception("Path " + fileStr + " should be a file");
            }
        } else if (createParent && file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new Exception("Path " + file.getParentFile().getAbsolutePath() + " could not be created.");
        }
        return file;
    }

    public static File validateInputDir(String dir, String dirName) throws Exception {
        if (dir == null) {
            throw new Exception(dirName + " path can't be null");
        }
        File file = new File(dir);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new Exception("Path " + dir + " should be a directory for " + dirName);
            }
        } else {
            throw new Exception(dirName + " does not exist.:" + dir);
        }
        return file;
    }

    public static File validateInputPath(String fileStr) throws Exception {
        if (fileStr == null) {
            throw new Exception("Input path can't be null");
        }
        File file = new File(fileStr);
        if (!file.exists()) {
            throw new Exception("Path does not exist:" + fileStr);
        }
        return file;
    }

    public static File validateInputFile(String fileStr) throws Exception {
        return CommonUtils.validateInputFile(fileStr, "File");
    }

    public static String getCommaSeparatedListOfString(String[] list) {
        if (list == null) {
            return null;
        }
        return CommonUtils.getCommaSeparatedListOfString(Arrays.asList(list));
    }

    public static String getCommaSeparatedListOfString(Collection<String> list) {
        return CommonUtils.getCommaSeparatedListOfString(list, "(", ")", true);
    }

    public static String getSimpleCommaSeparatedListOfString(String[] list) {
        if (list == null) {
            return null;
        }
        return CommonUtils.getCommaSeparatedListOfString(list, "", "", false);
    }

    public static String getCommaSeparatedListOfString(String[] list, String open, String close, boolean singleQuoteElement) {
        List<String> listStr = null;
        if (list != null) {
            listStr = Arrays.asList(list);
        }
        return CommonUtils.getCommaSeparatedListOfString(listStr, open, close, singleQuoteElement);
    }

    public static String getCommaSeparatedListOfString(Collection<String> list, String open, String close, boolean singleQuoteElement) {
        return CommonUtils.getSeparatedListOfString(list, open, close, singleQuoteElement, ",");
    }

    public static String getSeparatedListOfString(Collection<String> list, String open, String close, boolean singleQuoteElement, String separator) {
        if (list == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(open);
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            String item = it.next();
            if (singleQuoteElement) {
                buffer.append("'" + item + "'");
            } else {
                buffer.append(item);
            }
            if (!it.hasNext()) continue;
            buffer.append(separator);
        }
        buffer.append(close);
        return buffer.toString();
    }

    public static File validateInputFile(String fileStr, String argName) throws Exception {
        if (fileStr == null) {
            throw new Exception(argName + " can't be null");
        }
        File file = new File(fileStr);
        if (file.exists()) {
            if (!file.isFile()) {
                throw new Exception(argName + " \"" + fileStr + "\" should be a file.");
            }
        } else {
            throw new Exception(argName + " \"" + fileStr + "\" does not exist.");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pipe(OutputStream out, InputStream in) throws IOException {
        byte[] buffer = new byte[102400];
        int read = in.read(buffer);
        while (read >= 0) {
            out.write(buffer, 0, read);
            out.flush();
            read = in.read(buffer);
        }
    }

    public static void writeToFile(File file, byte[] content) {
        if (content == null) {
            return;
        }
        FileOutputStream out = null;
        try {
            if (!file.exists()) {
                if (file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                    throw new Exception("Path could not be created.");
                }
                if (!file.createNewFile()) {
                    throw new Exception("File could not be created.");
                }
            }
            out = new FileOutputStream(file);
            out.write(content);
            out.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static String getArg(CommandType cmd, String arg) throws ServiceException {
        if (arg == null) {
            return null;
        }
        List<NameValuePairType> list = cmd.getArguments();
        for (NameValuePairType pair : list) {
            if (!arg.equals(pair.getName())) continue;
            String val = pair.getValue();
            if (val == null || val.contains("\n")) {
                throw new ServiceException("Invalid for argument " + arg);
            }
            if (val.length() > 1024) {
                throw new ServiceException("Invalid for argument. Length exceeded. " + arg);
            }
            return val;
        }
        return null;
    }

    public static void setArg(CommandType cmd, String arg, String value) {
        if (arg == null) {
            return;
        }
        List<NameValuePairType> list = cmd.getArguments();
        for (NameValuePairType pair : list) {
            if (!arg.equals(pair.getName())) continue;
            pair.setValue(value);
            return;
        }
        NameValuePairType pair = new NameValuePairType();
        pair.setName(arg);
        pair.setValue(value);
        cmd.getArguments().add(pair);
    }
}

