/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.extension;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.common.api.exception.UnknownResourceException;
import oracle.cloudlogic.javaservice.common.api.service.resource.CertificateService;
import oracle.cloudlogic.javaservice.types.CertificateDescription;
import oracle.cloudlogic.javaservice.utils.pem.PemFileObject;
import oracle.cloudlogic.javaservice.utils.pem.PemFileReader;
import oracle.cloudlogic.javaservice.utils.pem.PemFileWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateServiceExtension {
    CertificateService service = null;

    private CertificateServiceExtension(CertificateService service) {
        this.service = service;
    }

    public static CertificateServiceExtension getExtensionFor(CertificateService service) throws ServiceException {
        if (service == null) {
            throw new ServiceException("service cannot be null");
        }
        return new CertificateServiceExtension(service);
    }

    public List<CertificateDescription> listCertificateChain(String alias) throws ServiceException {
        throw new ServiceException("unimplemented");
    }

    public int addCertificates(KeyStore keystore, List<String> alias) throws ServiceException, KeyStoreException, CertificateEncodingException {
        if (alias == null) {
            alias = new ArrayList<String>();
            Enumeration<String> e = keystore.aliases();
            while (e.hasMoreElements()) {
                alias.add(e.nextElement());
            }
        }
        int count = 0;
        for (String a : alias) {
            if (!keystore.isCertificateEntry(a)) continue;
            try {
                this.service.describeCertificate(a);
            }
            catch (UnknownResourceException un) {
                Certificate c = keystore.getCertificate(a);
                this.service.addCertificate(new ByteArrayInputStream(c.getEncoded()), a);
                ++count;
            }
        }
        return count;
    }

    public int addCertificates(Reader pem, List<String> aliases) throws ServiceException, IOException {
        PemFileReader reader = new PemFileReader(pem);
        PemFileObject obj = reader.readPemObject();
        int count = 0;
        while (obj != null) {
            String alias;
            if (obj.isCertificate() && (alias = obj.getAliasFromHeader()) != null && (aliases == null || aliases.isEmpty() || aliases.contains(alias))) {
                try {
                    this.service.describeCertificate(alias);
                }
                catch (UnknownResourceException un) {
                    this.service.addCertificate(new ByteArrayInputStream(obj.getContent()), alias);
                    ++count;
                }
            }
            obj = reader.readPemObject();
        }
        return count;
    }

    public KeyStore downloadCertificatesAsJKS(List<String> alias) throws ServiceException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        if (alias == null || alias.isEmpty()) {
            alias = this.listAllAliases();
        }
        KeyStore keyStore = null;
        keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        for (String a : alias) {
            try {
                oracle.cloudlogic.javaservice.types.Certificate cert = this.service.describeCertificate(a);
                X509Certificate x = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(cert.getContents()));
                keyStore.setCertificateEntry(a, x);
            }
            catch (UnknownResourceException un) {}
        }
        return keyStore;
    }

    public List<String> listAllAliases() throws ServiceException {
        List<CertificateDescription> list = this.service.listCertificates();
        ArrayList<String> ret = new ArrayList<String>();
        for (CertificateDescription c : list) {
            ret.add(c.getAlias());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int downloadCertificatesAsPEM(List<String> alias, Writer pem) throws ServiceException, IOException {
        if (alias == null) {
            alias = this.listAllAliases();
        }
        int count = 0;
        PemFileWriter writer = new PemFileWriter(pem);
        try {
            for (String a : alias) {
                try {
                    oracle.cloudlogic.javaservice.types.Certificate cert = this.service.describeCertificate(a);
                    PemFileObject obj = new PemFileObject(PemFileObject.FILE_TYPE.CERTIFICATE.toString(), cert.getContents());
                    obj.addAliasHeader(a);
                    writer.writeObject(obj);
                    ++count;
                }
                catch (UnknownResourceException un) {}
            }
        }
        finally {
            writer.flush();
        }
        return count;
    }
}

