/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.common.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import oracle.cloudlogic.javaservice.common.api.ServiceManager;
import oracle.cloudlogic.javaservice.common.api.exception.MissingPropertyException;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.common.spi.Property;
import oracle.cloudlogic.javaservice.common.spi.SecurityTokenProvider;
import oracle.cloudlogic.javaservice.common.spi.ServiceManagerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManagerFactory {
    public static final String TARGET_SERVICE_TYPE_WEBLOGIC_LOCAL_JMX = "wls-local-jmx";
    public static final String TARGET_SERVICE_TYPE_WEBLOGIC_REMOTE_JMX = "wls-remote-jmx";
    public static final String TARGET_SERVICE_TYPE_OPC_AS_REST = "opc-admin-server-rest";
    public static final String TARGET_SERVICE_TYPE_JAVACLOUD_REST = "javacloud-rest";
    public static final String TARGET_SERVICE_TYPE_OASIS_CAMP_REST = "oasis-camp-rest";

    private ServiceManagerFactory() {
    }

    public static ServiceManager createServiceManager(String serviceType, String url, String user, byte[] pwd, Map<String, Object> properties) throws ServiceException {
        return ServiceManagerFactory.createServiceManager(serviceType, url, user, pwd, properties, null);
    }

    public static ServiceManager createServiceManager(String serviceType, String url, String user, Map<String, Object> properties, ClassLoader loader) throws ServiceException {
        if (properties == null) {
            properties = new HashMap<String, Object>();
        }
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        ServiceLoader<SecurityTokenProvider> tokenProviders = ServiceLoader.load(SecurityTokenProvider.class, loader);
        tokenProviders.reload();
        Iterator<SecurityTokenProvider> it = tokenProviders.iterator();
        if (it.hasNext()) {
            properties.put("PROP_SECURITY_TOKEN_PROVIDER", it.next());
        }
        return ServiceManagerFactory.createServiceManager(serviceType, url, user, null, properties, loader);
    }

    public static ServiceManager createServiceManager(String serviceType, String url, String user, byte[] pwd, Map<String, Object> properties, ClassLoader loader) throws ServiceException {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        ServiceLoader<ServiceManagerProvider> preProcessorLoader = ServiceLoader.load(ServiceManagerProvider.class, loader);
        preProcessorLoader.reload();
        ServiceManagerProvider provider = null;
        HashSet<String> availableProvidersCollect = new HashSet<String>();
        if (serviceType != null) {
            provider = ServiceManagerFactory.tryProvider(preProcessorLoader, serviceType, availableProvidersCollect);
        } else {
            if (url == null || url.trim().equals("")) {
                provider = ServiceManagerFactory.tryProvider(preProcessorLoader, TARGET_SERVICE_TYPE_WEBLOGIC_LOCAL_JMX, availableProvidersCollect);
            } else if (url.toLowerCase().startsWith("t3://")) {
                provider = ServiceManagerFactory.tryProvider(preProcessorLoader, TARGET_SERVICE_TYPE_WEBLOGIC_REMOTE_JMX, availableProvidersCollect);
            } else if (url.toLowerCase().startsWith("https")) {
                provider = ServiceManagerFactory.tryProvider(preProcessorLoader, TARGET_SERVICE_TYPE_JAVACLOUD_REST, availableProvidersCollect);
            }
            if (provider == null) {
                availableProvidersCollect.clear();
                provider = ServiceManagerFactory.tryProvider(preProcessorLoader, TARGET_SERVICE_TYPE_OPC_AS_REST, availableProvidersCollect);
                if (provider == null) {
                    availableProvidersCollect.clear();
                    provider = ServiceManagerFactory.tryProvider(preProcessorLoader, TARGET_SERVICE_TYPE_JAVACLOUD_REST, availableProvidersCollect);
                }
                if (provider == null && !availableProvidersCollect.isEmpty()) {
                    provider = ServiceManagerFactory.tryProvider(preProcessorLoader, (String)availableProvidersCollect.iterator().next(), availableProvidersCollect);
                }
            }
        }
        if (provider == null) {
            throw new ServiceException("Could not find any service providers for service type:" + serviceType + " Available providers:" + ((Object)availableProvidersCollect).toString());
        }
        List<Property> additionalProperty = provider.getAdditionalPropertyDescriptions(url);
        if (additionalProperty != null) {
            for (Property p : additionalProperty) {
                if (!p.isMandatory()) continue;
                boolean propFound = false;
                if (properties != null) {
                    if (properties.get(p.getName()) == null) {
                        if (p.getDefaultValue() != null) {
                            properties.put(p.getName(), p.getDefaultValue());
                            propFound = true;
                        }
                    } else {
                        propFound = true;
                    }
                }
                if (propFound) continue;
                throw new MissingPropertyException(p.getName(), "Missing property:" + p.getName());
            }
        }
        return provider.createServiceManager(url, user, pwd, properties);
    }

    private static ServiceManagerProvider tryProvider(ServiceLoader<ServiceManagerProvider> preProcessorLoader, String serviceType, Set<String> availableProviders) {
        for (ServiceManagerProvider provider : preProcessorLoader) {
            if (serviceType == null || serviceType.trim().equals("")) {
                return provider;
            }
            if (serviceType.equals(provider.getServiceType())) {
                return provider;
            }
            if (availableProviders == null) continue;
            availableProviders.add(provider.getServiceType());
        }
        return null;
    }
}

