/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.viewer;

import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.graphics.Image;

public class StatusConverter {
    public static IConverter statusToImage() {
        return new StatusToImageConverter();
    }

    public static IConverter statusToEnableBoolean() {
        return new StatusToEnableBooleanConverter();
    }

    public static IConverter statusToErrorMessageConverter() {
        return new StatusToErrorMessageConverter();
    }

    static class StatusToEnableBooleanConverter
    extends Converter {
        StatusToEnableBooleanConverter() {
            super(IStatus.class, Boolean.class);
        }

        public Object convert(Object fromObject) {
            if (((IStatus)fromObject).getSeverity() != 4) {
                return true;
            }
            return false;
        }
    }

    static class StatusToErrorMessageConverter
    extends Converter {
        public StatusToErrorMessageConverter() {
            super(IStatus.class, String.class);
        }

        public Object convert(Object fromObject) {
            IStatus status = (IStatus)fromObject;
            if (status.isMultiStatus()) {
                StringBuilder builder = new StringBuilder();
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus child = iStatusArray[n2];
                    builder.append(child.getMessage());
                    ++n2;
                }
                return builder.toString();
            }
            return status.getMessage();
        }
    }

    static class StatusToImageConverter
    extends Converter {
        public StatusToImageConverter() {
            super(IStatus.class, Image.class);
        }

        public Object convert(Object fromObject) {
            if (!(fromObject instanceof IStatus)) {
                return null;
            }
            IStatus status = (IStatus)fromObject;
            String fieldDecorationID = null;
            switch (status.getSeverity()) {
                case 1: {
                    fieldDecorationID = "DEC_INFORMATION";
                    break;
                }
                case 2: {
                    fieldDecorationID = "DEC_WARNING";
                    break;
                }
                case 4: 
                case 8: {
                    fieldDecorationID = "DEC_ERROR";
                }
            }
            FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration(fieldDecorationID);
            return fieldDecoration == null ? null : fieldDecoration.getImage();
        }
    }
}

