/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.viewer;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.SaveSummaryViewer;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.util.SaveSummaryCollector;
import oracle.eclipse.tools.adf.dtrt.util.TypedListenerList;
import oracle.eclipse.tools.common.util.Pair;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SaveSummaryCollectorViewer {
    private SaveSummaryCollector collector;
    private TreeViewer treeViewer;
    private TypedListenerList<IDoubleClickListener> doubleClickListeners;

    public void setInput(SaveSummaryCollector collector) {
        this.collector = collector;
        this.refresh();
    }

    public void dispose() {
        this.collector = null;
        if (this.treeViewer != null) {
            if (this.doubleClickListeners != null) {
                for (IDoubleClickListener listener : this.doubleClickListeners) {
                    this.treeViewer.removeDoubleClickListener(listener);
                }
            }
            this.treeViewer = null;
        }
        if (this.doubleClickListeners != null) {
            this.doubleClickListeners.clear();
            this.doubleClickListeners = null;
        }
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        if (listener != null) {
            if (this.treeViewer != null) {
                this.treeViewer.addDoubleClickListener(listener);
            } else {
                if (this.doubleClickListeners == null) {
                    this.doubleClickListeners = new TypedListenerList();
                }
                this.doubleClickListeners.add((Object)listener);
            }
        }
    }

    public void removeDoubleClickListener(IDoubleClickListener listener) {
        if (listener != null) {
            if (this.treeViewer != null) {
                this.treeViewer.removeDoubleClickListener(listener);
            } else if (this.doubleClickListeners != null) {
                this.doubleClickListeners.remove((Object)listener);
            }
        }
    }

    public SaveSummaryCollector getInput() {
        return this.collector;
    }

    public Control createControl(FormToolkit toolkit, Composite parent) {
        Composite composite = toolkit.createComposite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(composite);
        this.treeViewer = new TreeViewer(composite, 4){

            protected void fireDoubleClick(DoubleClickEvent event) {
                Object object = DTRTUIUtil.getFirstElement(event.getSelection());
                if ((object = CollectorContentProvider.toRawElement(object)) != null) {
                    event = new DoubleClickEvent(event.getViewer(), (ISelection)new StructuredSelection(object));
                    super.fireDoubleClick(event);
                }
            }
        };
        toolkit.adapt((Composite)this.treeViewer.getTree());
        DTRTUIUtil.applyGrabAllGridData((Control)this.treeViewer.getTree());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CollectorLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new CollectorContentProvider());
        if (this.doubleClickListeners != null) {
            for (IDoubleClickListener listener : this.doubleClickListeners) {
                this.treeViewer.addDoubleClickListener(listener);
            }
        }
        this.refresh();
        return composite;
    }

    public void refresh() {
        if (this.treeViewer != null) {
            this.treeViewer.setInput(this.collector != null ? this.collector.getSaveSummaries() : null);
            this.treeViewer.setExpandedElements(((CollectorContentProvider)this.treeViewer.getContentProvider()).getInitiallyExpandedObjects());
        }
    }

    private static class CollectorContentProvider
    implements ITreeContentProvider {
        private Map<Object, Object[]> parentChildrenMap;
        private Object[] initiallyExpandedObjects;

        private CollectorContentProvider() {
        }

        public static Object toRawElement(Object element) {
            return element instanceof Pair ? ((Pair)element).getSecond() : element;
        }

        public void dispose() {
            this.initiallyExpandedObjects = null;
            this.inputChanged(null, null, null);
        }

        public Object[] getInitiallyExpandedObjects() {
            return this.initiallyExpandedObjects != null ? this.initiallyExpandedObjects : DTRTUtil.EMPTY_ARRAY;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (this.parentChildrenMap != null) {
                this.parentChildrenMap.clear();
                this.parentChildrenMap = null;
            }
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Date> roots = null;
            if (this.parentChildrenMap == null && inputElement instanceof Collection) {
                Collection collection = (Collection)inputElement;
                for (Object object : collection) {
                    Pair pair;
                    if (!(object instanceof Pair) || !((pair = (Pair)object).getFirst() instanceof Date) || !(pair.getSecond() instanceof IOEPEExecutableContext.ISaveSummary)) continue;
                    Date date = (Date)pair.getFirst();
                    IOEPEExecutableContext.ISaveSummary saveSummary = (IOEPEExecutableContext.ISaveSummary)pair.getSecond();
                    if (saveSummary.getFileCount() <= 0) continue;
                    if (roots == null) {
                        this.parentChildrenMap = new HashMap<Object, Object[]>(collection.size());
                        roots = new ArrayList<Date>(collection.size());
                    }
                    roots.add(date);
                    ArrayList categories = new ArrayList(3);
                    Pair<?, ?> category = this.buildTree(date, SaveSummaryViewer.Messages.created, saveSummary.getCreatedFiles());
                    if (category != null) {
                        categories.add(category);
                    }
                    if ((category = this.buildTree(date, SaveSummaryViewer.Messages.deleted, saveSummary.getDeletedFiles())) != null) {
                        categories.add(category);
                    }
                    if ((category = this.buildTree(date, SaveSummaryViewer.Messages.changed, saveSummary.getChangedFiles())) != null) {
                        categories.add(category);
                    }
                    this.parentChildrenMap.put(date, categories.toArray());
                    if (this.initiallyExpandedObjects != null) continue;
                    this.initiallyExpandedObjects = new Object[categories.size() + 1];
                    this.initiallyExpandedObjects[0] = date;
                    int i = 0;
                    while (i < categories.size()) {
                        this.initiallyExpandedObjects[i + 1] = categories.get(i);
                        ++i;
                    }
                }
            }
            return roots != null ? roots.toArray() : DTRTUtil.EMPTY_ARRAY;
        }

        private Pair<?, ?> buildTree(Date parent, String categoryMessage, Collection<? extends IFile> files) {
            if (!files.isEmpty()) {
                Pair category = new Pair((Object)parent, (Object)NLS.bind((String)categoryMessage, (Object)files.size()));
                Object[] fileArray = files.toArray();
                Arrays.sort(fileArray, DTRTUtil.COMPARATOR);
                Object[] elementArray = new Object[fileArray.length];
                int i = 0;
                while (i < fileArray.length) {
                    elementArray[i] = new Pair((Object)category, fileArray[i]);
                    ++i;
                }
                this.parentChildrenMap.put(category, elementArray);
                return category;
            }
            return null;
        }

        public Object getParent(Object element) {
            return element instanceof Pair ? ((Pair)element).getFirst() : null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children;
            if (this.parentChildrenMap != null && (children = this.parentChildrenMap.get(parentElement)) != null) {
                return children;
            }
            return DTRTUtil.EMPTY_ARRAY;
        }
    }

    private static class CollectorLabelProvider
    extends LabelProvider {
        private CollectorLabelProvider() {
        }

        public String getText(Object element) {
            return (element = CollectorContentProvider.toRawElement(element)) instanceof IFile ? ((IFile)element).getFullPath().toString() : (element instanceof String ? (String)element : (element instanceof Date ? DateFormat.getInstance().format((Date)element) : ""));
        }

        public Image getImage(Object element) {
            ImageManager.IImageData imageData = (element = CollectorContentProvider.toRawElement(element)) instanceof IFile ? ImageManager.getInstance().getWorkbenchImageData(element) : (element instanceof String ? ImageManager.getInstance().getWorkbenchSharedImageData("IMG_OBJ_FOLDER") : (element instanceof Date ? DTRTBundleIcon.CLOCK : null));
            return DTRTUIUtil.getImage(imageData);
        }
    }
}

