/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.viewer;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.StatusConverter;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.ui.forms.swt.Popup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class PropertyDecorationPopup
extends Popup {
    private final FormToolkit toolkit;
    private final IObservableValue validationStatus;
    private Composite composite;

    public PropertyDecorationPopup(Shell shell, Control targetControl, FormToolkit toolkit, DataBindingContext bindingContext, IObservableValue validationStatus) {
        super(shell, new Point(targetControl.toDisplay((int)1, (int)1).x, targetControl.toDisplay((int)1, (int)1).y + targetControl.getSize().y));
        this.toolkit = toolkit;
        this.validationStatus = validationStatus;
    }

    protected Control createContentArea(Composite parent) {
        this.composite = (Composite)super.createContentArea(parent);
        ScrolledForm form = this.toolkit.createScrolledForm(this.composite);
        TableWrapLayout bodyLayout = new TableWrapLayout();
        bodyLayout.verticalSpacing = 10;
        bodyLayout.topMargin = 5;
        bodyLayout.rightMargin = 5;
        bodyLayout.bottomMargin = 0;
        bodyLayout.leftMargin = 5;
        form.getBody().setLayout((Layout)bodyLayout);
        Section section = this.toolkit.createSection(form.getBody(), 64);
        this.toolkit.createCompositeSeparator((Composite)section);
        section.clientVerticalSpacing = 9;
        section.setText(Messages.problems);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite errorComposite = new Composite((Composite)section, 0);
        errorComposite.setLayout((Layout)new GridLayout(2, false));
        IStatus status = (IStatus)this.validationStatus.getValue();
        List<IStatus> statuses = this.flattenMultiStatuses(status);
        for (IStatus item : statuses) {
            if (item.isOK()) continue;
            Label imageLabel = this.toolkit.createLabel(errorComposite, "");
            imageLabel.setImage((Image)StatusConverter.statusToImage().convert((Object)item));
            Label errorMessage = this.toolkit.createLabel(errorComposite, "");
            errorMessage.setText((String)StatusConverter.statusToErrorMessageConverter().convert((Object)item));
        }
        section.setClient((Control)errorComposite);
        parent.pack();
        return this.composite;
    }

    private List<IStatus> flattenMultiStatuses(IStatus status) {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        this.recursiveFlattenMultiStatus(statuses, status);
        return statuses;
    }

    private void recursiveFlattenMultiStatus(List<IStatus> statuses, IStatus status) {
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.recursiveFlattenMultiStatus(statuses, child);
                ++n2;
            }
        } else {
            statuses.add(status);
        }
    }

    protected Control getFocusControl() {
        return this.composite;
    }

    static class Messages
    extends NLS {
        public static String problems;

        static {
            NLS.initializeMessages((String)PropertyDecorationPopup.class.getName(), Messages.class);
        }

        Messages() {
        }
    }
}

