/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.viewer;

import oracle.eclipse.tools.adf.dtrt.ui.internal.DTRTUIBundle;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.AbstractPropertyViewer;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.IDescribableViewerListener;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.PopupControlDecorationUpdater;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.IDisposable;
import oracle.eclipse.tools.adf.dtrt.util.TypedListenerList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class DescribableViewer
extends AbstractPropertyViewer
implements IDisposable {
    private IDescribable describable;
    private boolean useDescribableToolTipText;
    private String hyperlinkToolTipText;
    private FormText text;
    private TypedListenerList<IDescribableViewerListener> listeners = new TypedListenerList();
    private ImageHyperlink browseHyperlink;
    private ImageHyperlink createHyperlink;
    private boolean sanitizeInput = true;
    private String nullString = "";
    private ControlDecorationSupport controlDecorationSupport;
    private ValidationStatusProvider validationStatusProvider;
    private WritableValue statusValue;
    private DisposeListener disposeListener;

    public DescribableViewer() {
        this.setDisposeWithWidget(true);
    }

    @Override
    protected void handleFirstHyperlinkListener() {
        if (this.getInput() != null) {
            this.refresh();
        }
    }

    @Override
    public void dispose() {
        this.describable = null;
        if (this.disposeListener != null) {
            this.unregisterDisposableListener();
            this.disposeListener = null;
        }
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        if (this.controlDecorationSupport != null) {
            this.controlDecorationSupport.dispose();
            this.controlDecorationSupport = null;
        }
        if (this.validationStatusProvider != null) {
            this.validationStatusProvider.dispose();
            this.validationStatusProvider = null;
        }
        if (this.statusValue != null) {
            this.statusValue.dispose();
            this.statusValue = null;
        }
        this.text = null;
        this.browseHyperlink = null;
        this.createHyperlink = null;
        super.dispose();
    }

    public void setInput(IDescribable describable) {
        this.describable = describable;
        this.refresh();
    }

    public IDescribable getInput() {
        return this.describable;
    }

    public void addListener(IDescribableViewerListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IDescribableViewerListener listener) {
        this.listeners.remove((Object)listener);
    }

    public boolean isSanitizeInput() {
        return this.sanitizeInput;
    }

    public void setSanitizeInput(boolean sanitize) {
        this.sanitizeInput = sanitize;
    }

    public void setUseDescribableToolTipText(boolean useDescribableToolTipText) {
        this.useDescribableToolTipText = useDescribableToolTipText;
    }

    public boolean isUseDescribableToolTipText() {
        return this.useDescribableToolTipText;
    }

    public void setHyperlinkToolTipText(String toolTipText) {
        this.hyperlinkToolTipText = toolTipText;
    }

    public String getHyperlinkToolTipText() {
        return this.isUseDescribableToolTipText() ? DTRTUtil.getToolTipText((IDescribable)this.getInput()) : this.hyperlinkToolTipText;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setStatus(IStatus status) {
        if (this.statusValue == null) {
            this.statusValue = new WritableValue();
        }
        this.statusValue.setValue((Object)status);
    }

    public IStatus getStatus() {
        return this.statusValue != null ? (IStatus)this.statusValue.getValue() : null;
    }

    public void setDisposeWithWidget(boolean dispose) {
        if (dispose) {
            this.registerDisposableListener(true);
        } else {
            this.unregisterDisposableListener();
        }
    }

    public boolean isDisposeWithWidget() {
        return this.disposeListener != null;
    }

    private void unregisterDisposableListener() {
        if (this.disposeListener != null) {
            if (this.text != null && !this.text.isDisposed()) {
                this.text.removeDisposeListener(this.disposeListener);
            }
            this.disposeListener = null;
        }
    }

    private void registerDisposableListener(boolean create) {
        if (this.disposeListener == null && create) {
            this.disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (!$assertionsDisabled && e.widget != DescribableViewer.this.text) {
                        throw new AssertionError();
                    }
                    DescribableViewer.this.dispose();
                }
            };
        }
        if (this.disposeListener != null && this.text != null && !this.text.isDisposed()) {
            this.text.removeDisposeListener(this.disposeListener);
            this.text.addDisposeListener(this.disposeListener);
        }
    }

    @Override
    public Control createControl(FormToolkit toolkit, Composite parent, boolean supportsBrowse, boolean supportsCreation) {
        return this.createControl(toolkit, parent, supportsBrowse, supportsCreation, false);
    }

    public Control createControl(FormToolkit toolkit, Composite parent, boolean supportsBrowse, boolean supportsCreation, boolean supportsValidation) {
        int columns = 1 + (supportsBrowse ? 1 : 0) + (supportsCreation ? 1 : 0);
        Composite composite = toolkit.createComposite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(columns).applyTo(composite);
        boolean readOnly = !supportsBrowse && !supportsCreation;
        this.text = DTRTUIUtil.createFormText(toolkit, composite, readOnly ? 8 : 0);
        this.adjustFormText(this.text, readOnly);
        this.text.setData("readOnly", (Object)readOnly);
        DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.text);
        this.text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                HyperlinkEvent event = new HyperlinkEvent((Widget)DescribableViewer.this.text.getParent(), (Object)DescribableViewer.this.getInput(), e.getLabel(), e.getStateMask());
                DescribableViewer.this.handleHyperlinkActivated(event);
            }
        });
        if (supportsBrowse) {
            this.browseHyperlink = this.createBrowseHyperlink(toolkit, composite);
        }
        if (supportsCreation) {
            this.createHyperlink = this.createCreationHyperlink(toolkit, composite);
        }
        if (supportsValidation) {
            if (this.statusValue == null) {
                this.statusValue = new WritableValue();
            }
            ISWTObservableValue observable = SWTObservables.observeVisible((Control)this.text);
            final WritableList writableList = new WritableList();
            writableList.add((Object)observable);
            this.validationStatusProvider = new ValidationStatusProvider(){

                public IObservableValue getValidationStatus() {
                    return DescribableViewer.this.statusValue;
                }

                public IObservableList getTargets() {
                    return writableList;
                }

                public IObservableList getModels() {
                    return null;
                }
            };
            PopupControlDecorationUpdater updater = new PopupControlDecorationUpdater(new DataBindingContext(), toolkit, (Control)this.text, this.validationStatusProvider.getValidationStatus());
            this.controlDecorationSupport = ControlDecorationSupport.create((ValidationStatusProvider)this.validationStatusProvider, (int)16512, (Composite)parent, (ControlDecorationUpdater)updater);
        }
        this.registerDisposableListener(false);
        this.refresh();
        return composite;
    }

    public void setBrowseControlEnabled(boolean enabled) {
        if (this.browseHyperlink != null) {
            this.browseHyperlink.setEnabled(enabled);
        }
    }

    public void setCreateControlEnabled(boolean enabled) {
        if (this.createHyperlink != null) {
            this.createHyperlink.setEnabled(enabled);
        }
    }

    protected void adjustFormText(FormText text, boolean readOnly) {
    }

    @Override
    public void refresh() {
        if (this.text != null) {
            IDescriptor aux;
            String label = null;
            IDescriptor descriptor = null;
            if (this.describable != null && (aux = this.describable.getDescriptor()) != null && (label = aux.getLabel()) != null) {
                descriptor = aux;
            }
            if (descriptor == null) {
                this.text.setText(DTRTUtil.toNotNullString((String)this.getNullString()), false, false);
            } else {
                StringBuilder sb = new StringBuilder("<form><p>");
                Image image = DTRTUIUtil.getImage(descriptor);
                if (image != null) {
                    this.text.setImage("d1", image);
                    sb.append("<img align=\"middle\" href=\"d1\"/> ");
                }
                if (!this.getHyperlinkListeners().isEmpty()) {
                    sb.append("<a href=\"l1\"");
                    String toolTipText = this.getHyperlinkToolTipText();
                    if (toolTipText != null) {
                        sb.append(" alt=\"").append(toolTipText.replace("\n", "&#13;")).append('\"');
                    }
                    sb.append('>');
                }
                sb.append(this.toText(label));
                if (!this.getHyperlinkListeners().isEmpty()) {
                    sb.append("</a>");
                }
                this.text.setText(sb.append("</p></form>").toString(), true, true);
            }
        }
    }

    private String toText(String string) {
        if (string != null && this.isSanitizeInput()) {
            string = string.replace("<", "&lt;");
            string = string.replace(">", "&gt;");
        }
        return string;
    }

    @Override
    protected void handleEvent(IDescribableViewerListener.ActionType type) {
        for (IDescribableViewerListener listener : this.listeners) {
            try {
                listener.handleEvent(this.getInput(), type);
            }
            catch (Exception e) {
                DTRTUIBundle.log(e);
            }
        }
    }

    static class Messages
    extends NLS {
        public static String create;
        public static String browse;

        static {
            NLS.initializeMessages((String)DescribableViewer.class.getName(), Messages.class);
        }

        Messages() {
        }
    }
}

