/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.viewer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.object.IBinding;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IIteratorBinding;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.FormTextHTMLGenerator;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.CustomSection;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.DescribableViewer;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.EnhancedRowLayout;
import oracle.eclipse.tools.adf.dtrt.usage.BindingObjectUsageManager;
import oracle.eclipse.tools.adf.dtrt.usage.LiveMonitoringProvider;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;

public class BindingObjectUsageViewer {
    private static final Comparator<BindingObjectUsageManager.Usage> USAGE_COMPARATOR = new Comparator<BindingObjectUsageManager.Usage>(){

        @Override
        public int compare(BindingObjectUsageManager.Usage o1, BindingObjectUsageManager.Usage o2) {
            IBindingObject b1 = o1.getBindingObject();
            IBindingObject b2 = o2.getBindingObject();
            return DTRTUtil.compare((Object)b1, (Object)b2);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    };
    private IFile boundSourceFile;
    private IDOMNode boundSourceNode;
    private BindingObjectUsageManager usageManager;
    private FormToolkit toolkit;
    private Label descriptionLabel;
    private Composite bindingControlParent;
    private Element documentElement;

    public static String computeDataControlObjectToolTipText(IDataControlObject dataControlObject) {
        if (dataControlObject != null) {
            ArrayList<IDataControlObject> path = new ArrayList<IDataControlObject>();
            IDataControlObject dco = dataControlObject;
            while (dco != null) {
                path.add(dco);
                dco = dco.getParent();
            }
            StringBuilder sb = new StringBuilder(path.size() * 8);
            int i = path.size() - 1;
            while (i >= 0) {
                sb.append(DTRTUtil.getLabel((IDescribable)((IDescribable)path.get(i))));
                if (i > 0) {
                    sb.append(" > ");
                }
                --i;
            }
            return sb.toString();
        }
        return null;
    }

    public void dispose() {
        this.documentElement = null;
        if (this.usageManager != null) {
            this.usageManager.dispose();
            this.usageManager = null;
        }
        this.toolkit = null;
        this.descriptionLabel = null;
        this.bindingControlParent = null;
    }

    private void initialize(IOEPEContext context, IFile boundSourceFile, IDOMDocument boundSourceDocument, IDOMNode boundSourceNode) {
        this.boundSourceFile = null;
        this.boundSourceNode = null;
        Element currentDocumentElement = this.documentElement;
        this.documentElement = null;
        if (boundSourceFile == null || boundSourceDocument == null) {
            if (this.usageManager != null) {
                this.usageManager.dispose();
                this.usageManager = null;
            }
        } else if (this.usageManager == null || this.usageManager.getContext() != context || boundSourceDocument.getDocumentElement() != currentDocumentElement) {
            if (this.usageManager != null) {
                this.usageManager.dispose();
            }
            this.usageManager = BindingObjectUsageManager.create((IOEPEContext)context);
            this.usageManager.setBoundSourceDocumentProvider((BindingObjectUsageManager.IBoundSourceDocumentProvider)new LiveMonitoringProvider());
            this.usageManager.addResetListener(new BindingObjectUsageManager.IResetListener(){

                public void handleReset(BindingObjectUsageManager usageManager) {
                    if (BindingObjectUsageViewer.this.bindingControlParent != null && !BindingObjectUsageViewer.this.bindingControlParent.isDisposed()) {
                        Display display = BindingObjectUsageViewer.this.bindingControlParent.getDisplay();
                        if (Thread.currentThread() == display.getThread()) {
                            BindingObjectUsageViewer.this.show();
                        } else {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    BindingObjectUsageViewer.this.show();
                                }
                            });
                        }
                    }
                }
            });
        }
        if (this.usageManager != null && boundSourceDocument != null) {
            this.boundSourceFile = boundSourceFile;
            this.boundSourceNode = boundSourceNode;
            this.documentElement = boundSourceDocument.getDocumentElement();
        }
    }

    private List<? extends IPageDefinition> getPageDefinitions() {
        return this.usageManager != null ? this.usageManager.getPageDefinitions() : Collections.emptyList();
    }

    public Control createControl(FormToolkit toolkit, Composite parent) {
        this.toolkit = toolkit;
        Composite composite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.descriptionLabel = toolkit.createLabel(composite, null, 64);
        GridData gridData = DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.descriptionLabel);
        gridData.horizontalIndent = 5;
        gridData.verticalIndent = 5;
        this.bindingControlParent = toolkit.createComposite(composite);
        DTRTUIUtil.applyGrabAllGridData((Control)this.bindingControlParent);
        EnhancedRowLayout layout = new EnhancedRowLayout();
        layout.wrapChildrenOfDefaultSizedComposited = true;
        layout.verticalPack = true;
        layout.pack = false;
        layout.spacing = -1;
        layout.horizontalSpacing = 8;
        layout.verticalSpacing = 8;
        this.bindingControlParent.setLayout((Layout)layout);
        return composite;
    }

    public void show(IOEPEContext context, IFile boundSourceFile, IDOMDocument boundSourceDocument) {
        this.initialize(context, boundSourceFile, boundSourceDocument, null);
        this.show();
    }

    public void show(IOEPEContext context, IFile boundSourceFile, IDOMNode boundSourceNode) {
        IDOMDocument boundSourceDocument = boundSourceNode != null ? (IDOMDocument)boundSourceNode.getOwnerDocument() : null;
        this.initialize(context, boundSourceFile, boundSourceDocument, boundSourceNode);
        this.show();
    }

    private void show() {
        if (this.bindingControlParent == null || this.bindingControlParent.isDisposed()) {
            return;
        }
        this.clearBindingControlParent();
        if (this.usageManager == null) {
            this.setDescription(Messages.noBindingInformation, true);
        } else if (this.getPageDefinitions().isEmpty()) {
            this.setDescription(Messages.noPageDefinition, true);
        } else {
            ArrayList usages;
            LiveMonitoringProvider documentProvider = (LiveMonitoringProvider)this.usageManager.getBoundSourceDocumentProvider();
            List list = usages = this.boundSourceNode != null ? documentProvider.computeUsages(this.usageManager, this.boundSourceFile, this.boundSourceNode, false) : this.usageManager.getUsages(this.boundSourceFile);
            if (usages.isEmpty()) {
                if (this.boundSourceNode == null) {
                    this.setDescription(Messages.documentNoBindings, true);
                } else if (this.mayUseBindingObject(this.boundSourceNode.toString())) {
                    this.setDescription(Messages.noValidBindings, true);
                } else {
                    this.setDescription(Messages.noBindings, true);
                }
            } else {
                String description = this.boundSourceNode == null ? (usages.size() == 1 ? Messages.documentOneBinding : NLS.bind((String)Messages.documentNumberOfBindings, (Object)usages.size())) : (usages.size() == 1 ? Messages.oneBinding : NLS.bind((String)Messages.numberOfBindings, (Object)usages.size()));
                this.setDescription(description, false);
                usages = new ArrayList(usages);
                Collections.sort(usages, USAGE_COMPARATOR);
                for (BindingObjectUsageManager.Usage usage : usages) {
                    this.show(usage);
                }
                DTRTUIUtil.controlChanged((Control)this.bindingControlParent);
            }
        }
    }

    private void setDescription(String message, boolean onlyContent) {
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setText(message);
            GridData gridData = onlyContent ? DTRTUIUtil.applyGrabAllGridData((Control)this.descriptionLabel) : DTRTUIUtil.applyGrabHorizontallyGridData((Control)this.descriptionLabel);
            gridData.horizontalIndent = 5;
            gridData.verticalIndent = 5;
            if (onlyContent && !Boolean.TRUE.equals(this.descriptionLabel.getData("onlyContent"))) {
                DTRTUIUtil.controlChanged((Control)this.descriptionLabel);
            }
            this.descriptionLabel.setData("onlyContent", (Object)onlyContent);
        }
    }

    private void clearBindingControlParent() {
        if (this.bindingControlParent != null && !this.bindingControlParent.isDisposed()) {
            Control[] children;
            Control[] controlArray = children = this.bindingControlParent.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
        }
    }

    private void show(BindingObjectUsageManager.Usage usage) {
        IDataControlObject dataControlObject;
        DescribableViewer viewer;
        Label label;
        IIteratorBinding iteratorBinding;
        final IBindingObject bindingObject = usage.getBindingObject();
        String bindingLabel = DTRTUtil.getLabel((IDescribable)bindingObject);
        final HyperlinkSettings hyperlinkSettings = new HyperlinkSettings(this.bindingControlParent.getDisplay());
        hyperlinkSettings.setHyperlinkUnderlineMode(2);
        hyperlinkSettings.setForeground(DTRTUIUtil.getColor(this.toolkit, 75, 126, 177));
        HyperlinkAdapter hyperlinkAdapter = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                BindingObjectUsageViewer.this.openPageDefinitionEditor(bindingObject, event.getHref());
            }
        };
        final IFile bindingObjectFile = this.usageManager.getContext().getAccessibleFile((IObject)bindingObject);
        String openPageDefinitionEditorToolTipText = bindingObjectFile != null ? NLS.bind((String)Messages.openPageDefinitionEditor, (Object)bindingObjectFile.getFullPath().toString()) : null;
        CustomSection section = CustomSection.createSection(this.toolkit, this.bindingControlParent, bindingObjectFile != null, 328);
        if (bindingObjectFile != null) {
            section.getTextLabel().setToolTipText(openPageDefinitionEditorToolTipText);
            section.getTextLabel().addHyperlinkListener((IHyperlinkListener)hyperlinkAdapter);
            section.getTextLabel().setHref((Object)bindingObject);
            section.getTextLabel().setForeground(hyperlinkSettings.getForeground());
        }
        section.titleBarTextMarginWidth = 12;
        section.setText(bindingLabel);
        Composite composite = this.toolkit.createComposite((Composite)section, 0);
        section.setClient((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Font labelFont = null;
        if (bindingObject instanceof IBinding && (iteratorBinding = ((IBinding)bindingObject).getIteratorBinding()) != null) {
            label = DTRTUIUtil.createSectionLabel(this.toolkit, composite, Messages.iteratorLabel);
            labelFont = label.getFont();
            viewer = new DescribableViewer(){

                @Override
                protected void adjustFormText(FormText text, boolean readOnly) {
                    if (bindingObjectFile != null) {
                        text.setHyperlinkSettings(hyperlinkSettings);
                    }
                }
            };
            if (bindingObjectFile != null) {
                viewer.setHyperlinkToolTipText(openPageDefinitionEditorToolTipText);
                viewer.addHyperlinkListener((IHyperlinkListener)hyperlinkAdapter);
            }
            DTRTUIUtil.applyGrabHorizontallyGridData(viewer.createControl(this.toolkit, composite, false, false));
            viewer.setInput((IDescribable)iteratorBinding);
        }
        if ((dataControlObject = bindingObject.getDataControlObject()) != null) {
            label = DTRTUIUtil.createSectionLabel(this.toolkit, composite, Messages.dataSourceLabel);
            labelFont = label.getFont();
            viewer = new DescribableViewer(){

                @Override
                protected void adjustFormText(FormText text, boolean readOnly) {
                    if (bindingObjectFile != null) {
                        text.setHyperlinkSettings(hyperlinkSettings);
                    }
                }
            };
            if (bindingObjectFile != null) {
                viewer.setHyperlinkToolTipText(BindingObjectUsageViewer.computeDataControlObjectToolTipText(dataControlObject));
                viewer.addHyperlinkListener((IHyperlinkListener)hyperlinkAdapter);
            }
            DTRTUIUtil.applyGrabHorizontallyGridData(viewer.createControl(this.toolkit, composite, false, false));
            viewer.setInput((IDescribable)dataControlObject);
        }
        if (labelFont == null) {
            Label dummy = DTRTUIUtil.createSectionLabel(this.toolkit, composite, "");
            labelFont = dummy.getFont();
            dummy.dispose();
        }
        ExpandableComposite expandableComposite = this.toolkit.createExpandableComposite(composite, 20);
        DTRTUIUtil.applyGrabAllGridData((Control)expandableComposite).horizontalSpan = 2;
        expandableComposite.clientVerticalSpacing = 5;
        expandableComposite.setFont(labelFont);
        expandableComposite.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        expandableComposite.setText(Messages.elements);
        expandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                DTRTUIUtil.controlChanged((Control)((ExpandableComposite)e.getSource()));
            }
        });
        FormText usageText = DTRTUIUtil.createFormText(this.toolkit, (Composite)expandableComposite, 0x48 | this.toolkit.getOrientation());
        usageText.setHyperlinkSettings(hyperlinkSettings);
        expandableComposite.setClient((Control)usageText);
        usageText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                BindingObjectUsageManager.INodeProxy nodeProxy = (BindingObjectUsageManager.INodeProxy)FormTextHTMLGenerator.decodeHRef((FormText)event.widget, event.getHref());
                DTRTUIUtil.openWebPageEditor(BindingObjectUsageViewer.this.bindingControlParent.getShell(), nodeProxy);
            }
        });
        FormTextHTMLGenerator.HTMLUnorderedList unorderedList = new FormTextHTMLGenerator.HTMLUnorderedList(usageText);
        for (BindingObjectUsageManager.INodeProxy nodeProxy : usage.getNodeProxies()) {
            unorderedList.addLI(null, nodeProxy, nodeProxy.toString());
        }
        unorderedList.flush();
    }

    private void openPageDefinitionEditor(IBindingObject bindingObject, Object selectedObject) {
        IFile file = this.usageManager.getContext().getAccessibleFile((IObject)bindingObject);
        if (file != null) {
            try {
                IEditorPart part = DTRTUIUtil.openEditor(file);
                if (part != null) {
                    if (!(selectedObject instanceof IObject)) {
                        selectedObject = bindingObject;
                    }
                    part.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(selectedObject));
                }
            }
            catch (Exception e) {
                DTRTUIUtil.handleError(this.bindingControlParent.getShell(), e);
            }
        } else {
            MessageDialog.openInformation((Shell)this.bindingControlParent.getShell(), (String)Messages.pageDefinitionNotCreatedDialogTitle, (String)Messages.pageDefinitionNotCreated);
        }
    }

    private boolean mayUseBindingObject(String value) {
        return value != null && value.contains("bindings.");
    }

    private static class Messages
    extends NLS {
        public static String noBindingInformation;
        public static String noPageDefinition;
        public static String noBindings;
        public static String noValidBindings;
        public static String numberOfBindings;
        public static String oneBinding;
        public static String documentNoBindings;
        public static String documentNumberOfBindings;
        public static String documentOneBinding;
        public static String iteratorLabel;
        public static String dataSourceLabel;
        public static String elements;
        public static String openPageDefinitionEditor;
        public static String pageDefinitionNotCreated;
        public static String pageDefinitionNotCreatedDialogTitle;

        static {
            NLS.initializeMessages((String)BindingObjectUsageViewer.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

