/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.viewer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.ui.internal.DTRTUIBundle;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.DescribableViewer;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.IDescribableViewerListener;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public abstract class AbstractPropertyViewer {
    private List<IHyperlinkListener> hyperlinkListeners;

    public void addHyperlinkListener(IHyperlinkListener listener) {
        boolean noListeners;
        assert (listener != null);
        boolean bl = noListeners = this.hyperlinkListeners == null;
        if (noListeners) {
            this.hyperlinkListeners = new ArrayList<IHyperlinkListener>(3);
        }
        this.hyperlinkListeners.add(listener);
        if (noListeners) {
            this.handleFirstHyperlinkListener();
        }
    }

    protected abstract void handleFirstHyperlinkListener();

    protected abstract Control createControl(FormToolkit var1, Composite var2, boolean var3, boolean var4);

    public void removeHyperlinkListener(IHyperlinkListener listener) {
        if (this.hyperlinkListeners != null && this.hyperlinkListeners.remove(listener) && this.hyperlinkListeners.isEmpty()) {
            this.hyperlinkListeners = null;
        }
    }

    public void dispose() {
        if (this.hyperlinkListeners != null) {
            this.hyperlinkListeners.clear();
            this.hyperlinkListeners = null;
        }
    }

    protected void handleHyperlinkActivated(HyperlinkEvent event) {
        if (this.hyperlinkListeners != null) {
            IHyperlinkListener[] array;
            IHyperlinkListener[] iHyperlinkListenerArray = array = this.hyperlinkListeners.toArray(new IHyperlinkListener[this.hyperlinkListeners.size()]);
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                IHyperlinkListener listener = iHyperlinkListenerArray[n2];
                try {
                    listener.linkActivated(event);
                }
                catch (Exception e) {
                    DTRTUIBundle.log(e);
                }
                ++n2;
            }
        }
    }

    public List<IHyperlinkListener> getHyperlinkListeners() {
        return this.hyperlinkListeners == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.hyperlinkListeners);
    }

    protected ImageHyperlink createCreationHyperlink(FormToolkit toolkit, Composite parent) {
        ImageHyperlink imageHyperlink = toolkit.createImageHyperlink(parent, 0x1000000);
        imageHyperlink.setToolTipText(DescribableViewer.Messages.create);
        imageHyperlink.setImage(DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.ACTION_CREATE));
        imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AbstractPropertyViewer.this.handleEvent(IDescribableViewerListener.ActionType.CREATE);
            }
        });
        return imageHyperlink;
    }

    protected ImageHyperlink createBrowseHyperlink(FormToolkit toolkit, Composite parent) {
        ImageHyperlink imageHyperlink = toolkit.createImageHyperlink(parent, 0x1000000);
        imageHyperlink.setToolTipText(DescribableViewer.Messages.browse);
        imageHyperlink.setImage(DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.ACTION_BROWSE));
        imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AbstractPropertyViewer.this.handleEvent(IDescribableViewerListener.ActionType.BROWSE);
            }
        });
        return imageHyperlink;
    }

    protected void handleEvent(IDescribableViewerListener.ActionType browse) {
    }

    public abstract void refresh();
}

