/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.validation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import oracle.eclipse.tools.adf.dtrt.ui.internal.DTRTUIBundle;
import oracle.eclipse.tools.adf.dtrt.ui.util.PageDefinitionMarkerManager;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;

public class ArtifactValidationPreferences
implements PropertyChangeListener {
    private boolean disableValidationPrefValue;
    private boolean makeErrorsWarningsPrefValue;
    private boolean savedDisablement;
    private boolean savedMakeErrorsWarnings;
    private IPreferenceStore preferenceStore;
    private PropertyChangeSupport pcs;

    public ArtifactValidationPreferences(IPreferenceStore preferenceStore) {
        this.preferenceStore = preferenceStore;
        this.pcs = new PropertyChangeSupport(this);
    }

    public void load() {
        this.preferenceStore.setDefault("validation.validationDisabled", false);
        this.preferenceStore.setDefault("validation.makeErrorsWarnings", true);
        this.disableValidationPrefValue = this.preferenceStore.getBoolean("validation.validationDisabled");
        this.makeErrorsWarningsPrefValue = this.preferenceStore.getBoolean("validation.makeErrorsWarnings");
        this.setSavedPreferenceValues();
    }

    private void setSavedPreferenceValues() {
        this.savedDisablement = this.disableValidationPrefValue;
        this.savedMakeErrorsWarnings = this.makeErrorsWarningsPrefValue;
    }

    public void save() {
        if (this.preferenceStore instanceof IPersistentPreferenceStore) {
            this.preferenceStore.setValue("validation.validationDisabled", Boolean.toString(this.disableValidationPrefValue));
            this.preferenceStore.setValue("validation.makeErrorsWarnings", Boolean.toString(this.makeErrorsWarningsPrefValue));
            try {
                ((IPersistentPreferenceStore)this.preferenceStore).save();
            }
            catch (IOException e) {
                DTRTUIBundle.log(e);
            }
            if (this.disableValidationPrefValue != this.savedDisablement) {
                if (this.savedDisablement) {
                    PageDefinitionMarkerManager.validateWorkspace();
                } else {
                    PageDefinitionMarkerManager.clearAllMarkers();
                }
            } else if (this.makeErrorsWarningsPrefValue != this.savedMakeErrorsWarnings) {
                PageDefinitionMarkerManager.validateWorkspace();
            }
            this.setSavedPreferenceValues();
        }
    }

    public boolean isValidationDisabled() {
        return this.disableValidationPrefValue;
    }

    public void setValidationDisabled(boolean newValue) {
        boolean oldValue = this.disableValidationPrefValue;
        this.disableValidationPrefValue = newValue;
        this.pcs.firePropertyChange("validationDisabled", oldValue, newValue);
    }

    public boolean isMakeErrorsWarnings() {
        return this.makeErrorsWarningsPrefValue;
    }

    public void setMakeErrorsWarnings(boolean newValue) {
        boolean oldValue = this.makeErrorsWarningsPrefValue;
        this.makeErrorsWarningsPrefValue = newValue;
        this.pcs.firePropertyChange("makeErrorsWarnings", oldValue, newValue);
    }

    public void resetToDefaults() {
        this.setValidationDisabled(false);
        this.setMakeErrorsWarnings(true);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("validationDisabled")) {
            this.disableValidationPrefValue = (Boolean)evt.getNewValue();
        } else if (evt.getPropertyName().equals("makeErrorsWarnings")) {
            this.makeErrorsWarningsPrefValue = (Boolean)evt.getNewValue();
        }
    }

    public boolean isDirty() {
        return this.makeErrorsWarningsPrefValue != this.savedMakeErrorsWarnings || this.disableValidationPrefValue != this.savedDisablement;
    }
}

