/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.util;

import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.IExceptionHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class UIExceptionHandler
implements IExceptionHandler {
    public static final UIExceptionHandler DEFAULT = new UIExceptionHandler();
    private Shell shell;

    public UIExceptionHandler setShell(Shell shell) {
        this.shell = shell;
        return this;
    }

    public Shell getShell() {
        return this.shell == null || this.shell.isDisposed() ? DTRTUIUtil.getPlatformShell() : this.shell;
    }

    public void handleException(final Exception exception) {
        if (Display.getCurrent() != null) {
            DTRTUIUtil.handleError(this.getShell(), exception);
        } else {
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (display != null) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        DTRTUIUtil.handleError(UIExceptionHandler.this.getShell(), exception);
                    }
                });
            } else {
                DTRTUIUtil.handleError(null, exception);
            }
        }
    }
}

