/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.util;

import oracle.eclipse.tools.adf.dtrt.ui.internal.DTRTUIBundle;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDisposable;
import oracle.eclipse.tools.adf.dtrt.util.TypedListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class SelectionHelper
implements ISelectionProvider,
ISelectionChangedListener,
IDisposable {
    private ISelectionProvider source;
    private ISelection selection;
    private TypedListenerList<ISelectionChangedListener> selectionChangedListeners = new TypedListenerList();
    private boolean isNotifying;

    public SelectionHelper() {
    }

    public SelectionHelper(ISelectionProvider source) {
        this();
        this.source = source;
    }

    public void dispose() {
        if (this.selectionChangedListeners != null) {
            this.selectionChangedListeners.clear();
            this.selectionChangedListeners = null;
        }
        this.selection = null;
        this.source = null;
    }

    public ISelectionProvider getSource() {
        return this.source == null ? this : this.source;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != this) {
            this.selectionChangedListeners.add((Object)listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return DTRTUIUtil.toNotNullSelection(this.selection);
    }

    public void setSelectionAndNotify(ISelection selection) {
        if (!this.isCurrentSelection(selection)) {
            this.setSelection(selection);
            this.notifySelectionChangeListeners();
        }
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public void notifySelectionChangeListeners() {
        if (!this.isNotifying) {
            this.isNotifying = true;
            try {
                SelectionChangedEvent event = new SelectionChangedEvent(this.getSource(), this.getSelection());
                for (ISelectionChangedListener listener : this.selectionChangedListeners) {
                    try {
                        listener.selectionChanged(event);
                    }
                    catch (RuntimeException e) {
                        DTRTUIBundle.log(e);
                    }
                }
            }
            finally {
                this.isNotifying = false;
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelectionAndNotify(DTRTUIUtil.toNotNullSelection(event));
    }

    public boolean isCurrentSelection(ISelection selection) {
        return selection == null ? this.getSelection().isEmpty() : selection.equals(this.selection);
    }
}

