/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.util;

import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.UIExceptionHandler;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.SaveSummaryCollectorViewer;
import oracle.eclipse.tools.adf.dtrt.util.SaveSummaryCollector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SaveSummaryCollectorDialog
extends TitleAreaDialog {
    private SaveSummaryCollector collector;
    private FormToolkit toolkit;
    private SaveSummaryCollectorViewer viewer;

    public SaveSummaryCollectorDialog(Shell parentShell, SaveSummaryCollector collector) {
        super(parentShell);
        this.collector = collector;
    }

    public boolean close() {
        this.collector = null;
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        if (this.viewer != null) {
            this.viewer.dispose();
            this.viewer = null;
        }
        return super.close();
    }

    protected boolean isResizable() {
        return true;
    }

    public SaveSummaryCollector getSaveSummaryCollector() {
        return this.collector;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.title);
        newShell.setSize(550, 350);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.title);
        this.setMessage(Messages.message);
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.viewer = new SaveSummaryCollectorViewer();
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IFile file;
                Object object = DTRTUIUtil.getFirstElement(event.getSelection());
                if (object instanceof IFile && (file = (IFile)object).isAccessible()) {
                    SaveSummaryCollectorDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                DTRTUIUtil.openEditor(file);
                            }
                            catch (CoreException e) {
                                UIExceptionHandler.DEFAULT.handleException((Exception)((Object)e));
                            }
                        }
                    });
                    SaveSummaryCollectorDialog.this.close();
                }
            }
        });
        DTRTUIUtil.applyGrabAllGridData(this.viewer.createControl(this.toolkit, composite));
        this.viewer.setInput(this.collector);
        return composite;
    }

    private static class Messages
    extends NLS {
        public static String title;
        public static String message;

        static {
            NLS.initializeMessages((String)SaveSummaryCollectorDialog.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

